package com.cxqm.xiaoerke.common.filter;

import java.util.HashMap;

/**
 * Created by sunzb on 2018/5/17.
 */
public class CKFAliyunBukert {

    private static ThreadLocal<HashMap<String, Object>> threadLocals = new ThreadLocal<HashMap<String, Object>>();

    public static final String CURRENT_BUKET_KEY = "CURRENT_BUKET_KEY";
    public static final String CURRENT_USERID = "CURRENT_USERID";

    public static Object getValue(String name) {

        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap<String, Object>());
        }
        return threadLocals.get().get(name);
    }

    public static String getBuketKey(){

        return (String) getValue(CURRENT_BUKET_KEY);
    }

    public static String getUserId(){

        return (String) getValue(CURRENT_USERID);
    }

    public static void setBuketKey(String t){

        setValue(CURRENT_BUKET_KEY,t);
    }

    public static void setUserId(String t){

        setValue(CURRENT_USERID,t);
    }

    public static void setValue(String name, Object value) {

        //清空另一个线程用户配置线程
        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap<String, Object>());
        }
        threadLocals.get().put(name, value);
    }

    public static void clearBuketKey(){

        removeValue(CURRENT_BUKET_KEY);
    }

    public static void clearUserId(){

        removeValue(CURRENT_USERID);
    }

    public static void removeValue(String name) {

        if (threadLocals.get() == null) {
            return;
        }
        threadLocals.get().remove(name);
    }

    public static void clear() {

        if (threadLocals.get() != null) {
            threadLocals.get().clear();
        }
    }

}
