package com.cxqm.xiaoerke.common.web;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.HttpRequestUtilBean;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.ApiInvokerException;
import com.cxqm.xiaoerke.common.utils.HttpRequestUtil;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by sunzsh on 2017/5/31.
 */
public class ApiInvoker implements Serializable{
	private static final long serialVersionUID = 1844198524983377043L;

	public ApiInvokerException validateResult(JSONObject jsonObject) {
		if (jsonObject == null) {
			return new ApiInvokerException();
		}
		String resultCode = jsonObject.getString("resultCode");
		String resultMsg = jsonObject.getString("resultMsg");
		if (resultCode == null || resultMsg == null) {
			return new ApiInvokerException();
		}
		if (!resultCode.equals("0")) {
			return new ApiInvokerException(resultCode, resultMsg);
		}
		return null;
	}

	public Page buildPageByJsonObj(JSONObject jo) {
		if (jo == null) {
			return null;
		}
		Integer pageNo = jo.getInteger("pageNo");
		Integer pageSize = jo.getInteger("pageSize");
		Long count = jo.getLong("count");

		Page p = new Page(pageNo, pageSize, count);
		return p;
	}

	private String baseUrl;
	private String primaryKey;

	public String getBaseUrl() {
		return baseUrl;
	}

	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

	public String getPrimaryKey() {
		return primaryKey;
	}

	public void setPrimaryKey(String primaryKey) {
		this.primaryKey = primaryKey;
	}


	public HttpRequestUtilBean post(String url, String...param) {
		Map<String, String> paramMap = new HashMap<String, String>();
		for (int i = 0; i < param.length; i+=2) {
			String key = param[i];
			String value = param.length > i+1 ? param[i+1] : null;
			paramMap.put(key, value);
		}
		return post(url, paramMap);
	}

	public HttpRequestUtilBean post(String url, Map<String, String> param) {
		System.out.println(url);
		System.out.println(this.baseUrl);
		String fullUrl = this.baseUrl + url;
		if (param == null) {
			param = new HashMap<String, String>();
		}
		ApiValidateTokenVo apiValidateTokenVo = ApiValidateInterceptor.generateToken(this.primaryKey, param);
		StringBuffer paramBody = new StringBuffer();
		for (String k : param.keySet()) {
			try {
				paramBody.append(String.format("&%s=%s", URLEncoder.encode(k, "utf-8"), param.get(k) == null ? "" : URLEncoder.encode(param.get(k), "utf-8")));
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}
		paramBody.append("&" + apiValidateTokenVo.toString());
		System.out.println(paramBody.toString());
		HttpRequestUtilBean httpRequestUtilBean;
		try {
			System.out.println(fullUrl);
			httpRequestUtilBean = HttpRequestUtil.publicPost(fullUrl, paramBody.substring(1), true);
			System.out.println(httpRequestUtilBean.getCode());
			System.out.println(httpRequestUtilBean.getContent());
			System.out.println("请求成功!");
		} catch (IOException e) {
			e.printStackTrace();
			throw new ApiInvokerException(e);
		}
		return httpRequestUtilBean;
	}

}
