//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.cxqm.xiaoerke.common.web;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.data.XmlAttribute;
import com.ckfinder.connector.data.XmlElementData;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import com.ckfinder.connector.utils.ImageUtils;
import com.ckfinder.connector.utils.NaturalOrderComparator;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;
import javax.servlet.http.HttpServletRequest;

import com.cxqm.xiaoerke.common.filter.CKFAliyunBukert;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.modules.sys.security.SystemAuthorizingRealm;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;

public class CKFAliyunGetFilesCommand extends XMLCommand {
	private static final float BYTES = 1024.0F;
	private List<OSSObjectTool.OSSFile> files;
	private String fullCurrentPath;
	private String showThumbs;

	protected boolean checkIfCurrFolderExists(HttpServletRequest request) throws ConnectorException {
		return true;
	}

	public CKFAliyunGetFilesCommand() {
	}

	public void initParams(HttpServletRequest request, IConfiguration configuration, Object... params) throws ConnectorException {
		super.initParams(request, configuration, new Object[0]);
		this.showThumbs = request.getParameter("showThumbs");
	}

	protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
		if(errorNum == 0) {
			this.createFilesData(rootElement);
		}

	}

	protected int getDataForXml() {
		SystemAuthorizingRealm.Principal principal = (SystemAuthorizingRealm.Principal) UserUtils.getPrincipal();
		Map<String, ResourceType> types = this.configuration.getTypes();
		String typeName = ((ResourceType) types.get(this.type)).getName();

		String buket_key = CKFAliyunBukert.getBuketKey();
		String userId = CKFAliyunBukert.getUserId();
		System.out.println(buket_key == null || buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : buket_key);
		System.out.println("/"+ userId == null || userId.trim().equals("") ? principal.getId() : userId +"/" + typeName + this.currentFolder);
		this.files = OSSObjectTool.getChildFiles(buket_key == null || buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : buket_key, "/"+ userId == null || userId.trim().equals("") ? principal.getId() : userId +"/" + typeName + this.currentFolder);
//		File dir = new File(this.fullCurrentPath);
//		this.files = FileUtils.findChildrensList(dir, false);
//		Collections.sort(this.files, new NaturalOrderComparator());
		return 0;
	}

	private void filterListByHiddenAndNotAllowed() {

	}
	private void createFilesData(Element rootElement) {
		Element element = this.creator.getDocument().createElement("Files");
		Iterator i$ = this.files.iterator();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
		while(i$.hasNext()) {
			OSSObjectTool.OSSFile file = (OSSObjectTool.OSSFile)i$.next();
				XmlElementData elementData = new XmlElementData("File");
				XmlAttribute attribute = new XmlAttribute("name", file.getFileName());
				elementData.getAttributes().add(attribute);
				attribute = new XmlAttribute("date", sdf.format(file.getLastModified()));
				elementData.getAttributes().add(attribute);
				attribute = new XmlAttribute("size", file.getSize()==null?"0":(file.getSize()/1024)+"");
				elementData.getAttributes().add(attribute);
//				if(ImageUtils.isImage(file) && this.isAddThumbsAttr()) {
//					String attr = this.createThumbAttr(file);
//					if(!attr.equals("")) {
//						attribute = new XmlAttribute("thumb", attr);
//						elementData.getAttributes().add(attribute);
//					}
//				}

				elementData.addToDocument(this.creator.getDocument(), element);
		}

		rootElement.appendChild(element);
	}

	private String createThumbAttr(File file) {
		File thumbFile = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder, file.getName());
		return thumbFile.exists()?file.getName():(this.isShowThumbs()?"?".concat(file.getName()):"");
	}

	private String getSize(File file) {
		return file.length() > 0L && (float)file.length() < 1024.0F?"1":String.valueOf(Math.round((float)file.length() / 1024.0F));
	}

	private boolean isAddThumbsAttr() {
		return this.configuration.getThumbsEnabled() && (this.configuration.getThumbsDirectAccess() || this.isShowThumbs());
	}

	private boolean isShowThumbs() {
		return this.showThumbs != null && this.showThumbs.toString().equals("1");
	}

}
