/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.persistence;

import com.cxqm.xiaoerke.common.persistence.BaseEntity;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public abstract class DataEntity<T>
extends BaseEntity<T> {
    private static final long serialVersionUID = 1L;
    protected String remarks;
    protected User createBy;
    protected Date createDate;
    protected User updateBy;
    protected Date updateDate;
    protected String delFlag;

    public DataEntity() {
        this.delFlag = "0";
    }

    public DataEntity(String id) {
        super(id);
    }

    @Override
    public void preInsert() {
        User user;
        if (!this.isNewRecord) {
            this.setId(IdGen.uuid());
        }
        if (StringUtils.isNotBlank((CharSequence)(user = UserUtils.getUser()).getId())) {
            this.updateBy = user;
            this.createBy = user;
        }
        this.createDate = this.updateDate = new Date();
    }

    @Override
    public void preUpdate() {
        User user = UserUtils.getUser();
        if (StringUtils.isNotBlank((CharSequence)user.getId())) {
            this.updateBy = user;
        }
        this.updateDate = new Date();
    }

    @Length(min=0, max=255)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @JsonIgnore
    public User getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(User createBy) {
        this.createBy = createBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @JsonIgnore
    public User getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(User updateBy) {
        this.updateBy = updateBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @JsonIgnore
    @Length(min=1, max=1)
    public String getDelFlag() {
        return this.delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }
}

