/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.utils.DateUtils;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImgUtils {
    private static String zhPattern = "[\u4e00-\u9fa5]";

    public static void composePic(String headUrl, String codeUrl, String outSrc, int width, int height, int width1, int height1) {
        String fileSrc = "http://xiaoerke-article-pic.oss-cn-beijing.aliyuncs.com/olympicBaby_inviteBaseImg.png";
        try {
            URL url = new URL(fileSrc);
            HttpURLConnection httpUrl = (HttpURLConnection)url.openConnection();
            BufferedImage bg_src = ImageIO.read(httpUrl.getInputStream());
            Image logo_src = ImgUtils.getRoundImage(headUrl);
            Image code_src = ImgUtils.cutImage(codeUrl, 25, 25, 380, 380);
            int bg_width = ((Image)bg_src).getWidth(null);
            int bg_height = ((Image)bg_src).getHeight(null);
            BufferedImage tag = new BufferedImage(bg_width, bg_height, 1);
            Graphics2D g2d = tag.createGraphics();
            g2d.drawImage(bg_src, 0, 0, bg_width, bg_height, null);
            g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
            g2d.drawImage(logo_src, width, height, 126, 126, null);
            g2d.drawImage(code_src, width1, height1, 215, 215, null);
            g2d.setComposite(AlphaComposite.getInstance(3));
            FileOutputStream out = new FileOutputStream(outSrc);
            ImageIO.write((RenderedImage)tag, "png", out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image cutImage(String src, int x, int y, int w, int h) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("jpg");
        ImageReader reader = iterator.next();
        URL url = new URL(src);
        HttpURLConnection httpUrl = (HttpURLConnection)url.openConnection();
        InputStream in = httpUrl.getInputStream();
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        Rectangle rect = new Rectangle(x, y, w, h);
        param.setSourceRegion(rect);
        BufferedImage bi = reader.read(0, param);
        return bi;
    }

    public static Image getRoundImage(String headUrl) throws Exception {
        BufferedImage logo_src;
        URL url1 = new URL(headUrl);
        HttpURLConnection httpUrl1 = (HttpURLConnection)url1.openConnection();
        BufferedImage bi1 = logo_src = ImageIO.read(httpUrl1.getInputStream());
        BufferedImage bi2 = new BufferedImage(bi1.getWidth(), bi1.getHeight(), 1);
        Graphics2D g2 = bi2.createGraphics();
        bi2 = g2.getDeviceConfiguration().createCompatibleImage(bi1.getWidth(), bi1.getHeight(), 3);
        g2.dispose();
        g2 = bi2.createGraphics();
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, bi1.getWidth(), bi1.getHeight());
        g2.setBackground(Color.red);
        g2.draw(new Rectangle(bi2.getWidth(), bi2.getHeight()));
        g2.setClip(shape);
        g2.drawImage((Image)bi1, 0, 0, null);
        g2.dispose();
        return bi2;
    }

    public static Boolean existHttpPath(String httpPath) {
        URL httpurl = null;
        try {
            httpurl = new URL(httpPath);
            URLConnection rulConnection = httpurl.openConnection();
            rulConnection.getInputStream();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void uploadImage(String id, String path) {
        try {
            File file = new File(URLDecoder.decode(path, "utf-8"));
            FileInputStream inputStream = new FileInputStream(file);
            long length = file.length();
            OSSObjectTool.uploadFileInputStream(id, length, inputStream, OSSObjectTool.BUCKET_ARTICLE_PIC);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String createStringMark(String babyName, String fileSrc, String picCoordinate) {
        String[] coordinateList;
        Integer fontSize = 0;
        fontSize = babyName.length() < 3 ? Integer.valueOf(160) : (babyName.length() < 4 ? Integer.valueOf(146) : Integer.valueOf(110));
        for (String coordinate : coordinateList = picCoordinate.split(";")) {
            String[] coordinateInfo = coordinate.split(",");
            Integer x = Integer.parseInt(coordinateInfo[0]);
            Integer y = Integer.parseInt(coordinateInfo[1]);
            String dataTime = DateUtils.DateToStr(new Date(), "yyyyMMddHHmmss");
            File file = new File(System.getProperty("user.dir").replace("bin", "uploadImg"));
            if (!file.exists() && !file.isDirectory()) {
                System.out.println("//\u4e0d\u5b58\u5728");
                file.mkdir();
            } else {
                System.out.println("//\u76ee\u5f55\u5b58\u5728");
            }
            String outPath = System.getProperty("user.dir").replace("bin", "uploadImg") + "/" + dataTime + babyName + ".png";
            URL url = null;
            try {
                url = new URL(ImgUtils.encode(fileSrc, "UTF-8"));
                HttpURLConnection httpUrl = (HttpURLConnection)url.openConnection();
                BufferedImage theImg = ImageIO.read(httpUrl.getInputStream());
                int width = ((Image)theImg).getWidth(null) == -1 ? 200 : ((Image)theImg).getWidth(null);
                int height = ((Image)theImg).getHeight(null) == -1 ? 200 : ((Image)theImg).getHeight(null);
                System.out.println(width);
                System.out.println(height);
                System.out.println(theImg);
                BufferedImage bimage = new BufferedImage(width, height, 1);
                Graphics2D g = bimage.createGraphics();
                g.setColor(Color.white);
                g.setBackground(Color.red);
                g.drawImage((Image)theImg, 0, 0, null);
                g.setFont(new Font("\u6587\u6cc9\u9a7f\u7b49\u5bbd\u6b63\u9ed1", 1, fontSize));
                g.drawString(babyName, (int)x, y + 146);
                g.dispose();
                FileOutputStream out = new FileOutputStream(outPath);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bimage);
                param.setQuality(100.0f, true);
                encoder.encode(bimage, param);
                out.close();
                ImgUtils.uploadImage(dataTime + babyName + ".png", outPath);
                File imgFile = new File(outPath);
                if (imgFile.exists()) {
                    imgFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fileSrc = "http://xiaoerke-article-pic.oss-cn-beijing.aliyuncs.com/" + dataTime + babyName + ".png";
        }
        return fileSrc;
    }

    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        Pattern p = Pattern.compile(zhPattern);
        Matcher m = p.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
        }
        m.appendTail(b);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream downloadFile(String remoteFilePath) {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        try {
            urlfile = new URL(remoteFilePath);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            bis = new BufferedInputStream(httpUrl.getInputStream());
            bos = new ByteArrayOutputStream();
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
            bos.flush();
            bis.close();
            httpUrl.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new ByteArrayInputStream(bos.toByteArray());
        }
    }

    public static Image returnImageByUrl(InputStream in) throws IOException {
        BufferedImage backImage = null;
        backImage = ImageIO.read(in);
        int alphaType = 2;
        return backImage;
    }

    public static Image returnImageByUrl(String url) throws IOException {
        InputStream in = ImgUtils.downloadFile(url);
        return ImgUtils.returnImageByUrl(in);
    }

    public static byte[] getImageBinary(String url) {
        File f = new File(url);
        try {
            BufferedImage bi = ImageIO.read(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage compositeImage(String url, String path, int startX, int startY, int codeWidth, int codeHeight) {
        try {
            Image headImage = ImgUtils.returnImageByUrl(url);
            return ImgUtils.compositeImage(headImage, path, startX, startY, codeWidth, codeHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage compositeImage(Image headImage, String path, int startX, int startY, int codeWidth, int codeHeight) {
        try {
            BufferedImage backImage = null;
            ByteArrayInputStream in = new ByteArrayInputStream(ImgUtils.getImageBinary(path));
            backImage = ImageIO.read(in);
            int alphaType = 2;
            BufferedImage back = new BufferedImage(((Image)backImage).getWidth(null), ((Image)backImage).getHeight(null), alphaType);
            Graphics2D g = back.createGraphics();
            g.drawImage((Image)backImage, 0, 0, null);
            g.drawImage(headImage, startX, startY, codeWidth, codeHeight, null);
            g.dispose();
            return back;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

