/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Properties;

public class OrderProperties
extends Properties {
    private static final long serialVersionUID = -762117852594617585L;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private PropertiesContext context = new PropertiesContext();

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public PropertiesContext getContext() {
        return this.context;
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        while (true) {
            String line;
            String intactLine = line = in.readLine();
            if (line == null) {
                return;
            }
            if (line.length() > 0) {
                int keyStart;
                int len = line.length();
                for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                if (keyStart == len) continue;
                char firstChar = line.charAt(keyStart);
                if (firstChar != '#' && firstChar != '!') {
                    int valueIndex;
                    int separatorIndex;
                    while (this.continueLine(line)) {
                        int startIndex;
                        String nextLine = in.readLine();
                        intactLine = intactLine + "\n" + nextLine;
                        if (nextLine == null) {
                            nextLine = "";
                        }
                        String loppedLine = line.substring(0, len - 1);
                        for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                        }
                        nextLine = nextLine.substring(startIndex, nextLine.length());
                        line = loppedLine + nextLine;
                        len = line.length();
                    }
                    for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                        char currentChar = line.charAt(separatorIndex);
                        if (currentChar == '\\') {
                            ++separatorIndex;
                            continue;
                        }
                        if (keyValueSeparators.indexOf(currentChar) != -1) break;
                    }
                    for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
                    }
                    if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                        ++valueIndex;
                    }
                    while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                        ++valueIndex;
                    }
                    String key = line.substring(keyStart, separatorIndex);
                    String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
                    key = this.loadConvert(key);
                    value = this.loadConvert(value);
                    this.put(key, value, intactLine);
                    continue;
                }
                this.context.addCommentLine(intactLine);
                continue;
            }
            this.context.addCommentLine(intactLine);
        }
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = theString.charAt(x++)) == '\\') {
                if ((aChar = theString.charAt(x++)) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 't') {
                    outBuffer.append('\t');
                    continue;
                }
                if (aChar == 'r') {
                    outBuffer.append('\r');
                    continue;
                }
                if (aChar == 'n') {
                    outBuffer.append('\n');
                    continue;
                }
                if (aChar == 'f') {
                    outBuffer.append('\f');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    @Override
    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            OrderProperties.writeln(awriter, "#" + header);
        }
        List entrys = this.context.getCommentOrEntrys();
        for (Object obj : entrys) {
            if (obj.toString() == null) continue;
            OrderProperties.writeln(awriter, obj.toString());
        }
        awriter.flush();
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(OrderProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(OrderProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(OrderProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(OrderProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.context.putOrUpdate(key.toString(), value.toString());
        return super.put(key, value);
    }

    public synchronized Object put(Object key, Object value, String line) {
        this.context.putOrUpdate(key.toString(), value.toString(), line);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.context.remove(key.toString());
        return super.remove(key);
    }

    public void addComment(String comment) {
        if (comment != null) {
            this.context.addCommentLine("#" + comment);
        }
    }

    class PropertiesContext {
        private List<Object> commentOrEntrys = Lists.newArrayList();

        PropertiesContext() {
        }

        public List getCommentOrEntrys() {
            return this.commentOrEntrys;
        }

        public void addCommentLine(String line) {
            this.commentOrEntrys.add(line);
        }

        public void putOrUpdate(PropertyEntry pe) {
            this.remove(pe.getKey());
            this.commentOrEntrys.add(pe);
        }

        public void putOrUpdate(String key, String value, String line) {
            PropertyEntry pe = new PropertyEntry(key, value, line);
            this.remove(key);
            this.commentOrEntrys.add(pe);
        }

        public void putOrUpdate(String key, String value) {
            PropertyEntry pe = new PropertyEntry(key, value);
            int index = this.remove(key);
            this.commentOrEntrys.add(index, pe);
        }

        public int remove(String key) {
            for (int index = 0; index < this.commentOrEntrys.size(); ++index) {
                Object obj = this.commentOrEntrys.get(index);
                if (!(obj instanceof PropertyEntry) || Objects.equal((Object)obj, null) || !key.equals(((PropertyEntry)obj).getKey())) continue;
                this.commentOrEntrys.remove(obj);
                return index;
            }
            return this.commentOrEntrys.size();
        }

        class PropertyEntry {
            private String key;
            private String value;
            private String line;

            public PropertyEntry(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public PropertyEntry(String key, String value, String line) {
                this(key, value);
                this.line = line;
            }

            public String getLine() {
                return this.line;
            }

            public void setLine(String line) {
                this.line = line;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String toString() {
                if (this.line != null) {
                    return this.line;
                }
                if (this.key != null && this.value != null) {
                    String k = OrderProperties.this.saveConvert(this.key, true);
                    String v = OrderProperties.this.saveConvert(this.value, false);
                    return k + "=" + v;
                }
                return null;
            }
        }
    }
}

