/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.utils.ImgUtils;
import com.cxqm.xiaoerke.common.utils.MatrixToImageWriter;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QRCodeFactory {
    public BufferedImage setMatrixLogo(BufferedImage matrixImage, String logUri) throws IOException {
        if (logUri == null) {
            return matrixImage;
        }
        Graphics2D g2 = matrixImage.createGraphics();
        int matrixWidth = matrixImage.getWidth();
        int matrixHeigh = matrixImage.getHeight();
        BufferedImage logo = ImageIO.read(new File(logUri));
        g2.drawImage(logo, matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, null);
        BasicStroke stroke = new BasicStroke(5.0f, 1, 1);
        g2.setStroke(stroke);
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, 20.0f, 20.0f);
        g2.setColor(Color.white);
        g2.draw(round);
        BasicStroke stroke2 = new BasicStroke(1.0f, 1, 1);
        g2.setStroke(stroke2);
        RoundRectangle2D.Float round2 = new RoundRectangle2D.Float(matrixWidth / 5 * 2 + 2, matrixHeigh / 5 * 2 + 2, matrixWidth / 5 - 4, matrixHeigh / 5 - 4, 20.0f, 20.0f);
        g2.setColor(new Color(128, 128, 128));
        g2.draw(round2);
        g2.dispose();
        matrixImage.flush();
        return matrixImage;
    }

    public byte[] getQrImage(String content, String format, String logUri, int ... size) throws IOException, WriterException {
        int width = 430;
        int height = 430;
        if (size.length == 2) {
            width = size[0];
            height = size[1];
        } else if (size.length == 1) {
            width = height = size[0];
        }
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream(bitMatrix, format, bos, logUri);
        return bos.toByteArray();
    }

    public void CreatQrImage(String content, String format, String outFileUri, String logUri, int ... size) throws IOException, WriterException {
        int width = 430;
        int height = 430;
        if (size.length == 2) {
            width = size[0];
            height = size[1];
        } else if (size.length == 1) {
            width = height = size[0];
        }
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        File outputFile = new File(outFileUri);
        System.out.println("\u8f93\u51fa\u6587\u4ef6\u8def\u5f84\u4e3a" + outputFile.getPath());
        MatrixToImageWriter.writeToFile(bitMatrix, format, outputFile, logUri);
    }

    public byte[] generateHaibaoQrCodeByUrl(String content, String logoUrl, String haibaoPath, int startX, int startY, int width, int height) throws IOException, WriterException {
        int[] size = new int[]{width, height};
        String format = "jpg";
        byte[] qrImage = new QRCodeFactory().getQrImage(content, format, null, size);
        ByteArrayInputStream bis = new ByteArrayInputStream(qrImage);
        Image image = ImgUtils.returnImageByUrl(bis);
        BufferedImage bufferedImage = ImgUtils.compositeImage(image, haibaoPath, startX, startY, width, height);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", os);
        return os.toByteArray();
    }
}

