/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.ckfinder.connector.ServletContextFactory;
import com.ckfinder.connector.configuration.Configuration;
import com.ckfinder.connector.configuration.ConfigurationFactory;
import com.ckfinder.connector.configuration.Events;
import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.BeforeExecuteCommandEventArgs;
import com.ckfinder.connector.data.EventArgs;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.Command;
import com.ckfinder.connector.handlers.command.CopyFilesCommand;
import com.ckfinder.connector.handlers.command.CreateFolderCommand;
import com.ckfinder.connector.handlers.command.DeleteFolderCommand;
import com.ckfinder.connector.handlers.command.DownloadFileCommand;
import com.ckfinder.connector.handlers.command.ErrorCommand;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.LoadCookiesCommand;
import com.ckfinder.connector.handlers.command.MoveFilesCommand;
import com.ckfinder.connector.handlers.command.RenameFolderCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.handlers.command.XMLErrorCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.cxqm.xiaoerke.common.filter.CKFAliyunBukert;
import com.cxqm.xiaoerke.common.web.CKFAliyunDeleteFilesCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunFileUploadCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunGetFilesCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunGetFoldersCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunInitCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunQuickUploadCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunRenameFileCommand;
import com.cxqm.xiaoerke.common.web.CKFAliyunThumbnailCommand;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AliyunConnectorServlet
extends HttpServlet {
    private Exception startException;
    private static final long serialVersionUID = 2960665641425154338L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.getResponse(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.getResponse(request, response, true);
    }

    private void getResponse(HttpServletRequest request, HttpServletResponse response, boolean post) throws ServletException {
        CKFAliyunBukert.clear();
        String buketKey = request.getParameter("buketKey");
        String userId = request.getParameter("userId");
        if (buketKey != null && !"".equals(buketKey == null ? "" : buketKey.trim())) {
            CKFAliyunBukert.setBuketKey(buketKey);
        }
        if (userId != null && !"".equals(userId == null ? "" : userId.trim())) {
            CKFAliyunBukert.setUserId(userId);
        }
        if (this.startException != null && Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
            throw new ServletException((Throwable)this.startException);
        }
        String command = request.getParameter("command");
        IConfiguration configuration = null;
        try {
            configuration = ConfigurationFactory.getInstace().getConfiguration(request);
            if (configuration == null) {
                throw new Exception("Configuration wasn't initialized correctly. Check server logs.");
            }
        }
        catch (Exception var8) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                var8.printStackTrace();
            }
            throw new ServletException((Throwable)var8);
        }
        try {
            if (command == null || command.equals("")) {
                throw new ConnectorException(10, false);
            }
            configuration.setDebugMode(Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue());
            CommandHandlerEnum e = null;
            try {
                e = CommandHandlerEnum.valueOf(command.toUpperCase());
                if ((e.getCommand() instanceof IPostCommand || post) && !CommandHandlerEnum.FILEUPLOAD.equals((Object)e) && !CommandHandlerEnum.QUICKUPLOAD.equals((Object)e)) {
                    this.checkPostRequest(request);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            BeforeExecuteCommandEventArgs args = new BeforeExecuteCommandEventArgs();
            args.setCommand(command);
            args.setRequest(request);
            args.setResponse(response);
            if (configuration.getEvents() != null) {
                if (configuration.getEvents().run(Events.EventTypes.BeforeExecuteCommand, (EventArgs)args, configuration)) {
                    e = CommandHandlerEnum.valueOf(command.toUpperCase());
                    e.execute(request, response, configuration, this.getServletContext(), new Object[0]);
                }
            } else {
                e = CommandHandlerEnum.valueOf(command.toUpperCase());
                e.execute(request, response, configuration, this.getServletContext(), new Object[0]);
            }
        }
        catch (IllegalArgumentException var10) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                var10.printStackTrace();
                response.reset();
                throw new ServletException((Throwable)var10);
            }
            this.handleError(new ConnectorException(10, false), configuration, request, response, command);
        }
        catch (ConnectorException var11) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue() && var11.getException() != null) {
                var11.getException().printStackTrace();
                response.reset();
                throw new ServletException((Throwable)var11.getException());
            }
            this.handleError(var11, configuration, request, response, command);
        }
        catch (Exception var12) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                var12.printStackTrace();
                response.reset();
                throw new ServletException((Throwable)var12);
            }
            this.handleError(new ConnectorException(var12), configuration, request, response, command);
        }
    }

    private void checkPostRequest(HttpServletRequest request) throws ConnectorException {
        if (request.getParameter("CKFinderCommand") == null || !request.getParameter("CKFinderCommand").equals("true")) {
            throw new ConnectorException(109, true);
        }
    }

    private void handleError(ConnectorException e, IConfiguration configuration, HttpServletRequest request, HttpServletResponse response, String currentCommand) throws ServletException {
        try {
            if (currentCommand != null) {
                Command e1 = CommandHandlerEnum.valueOf(currentCommand.toUpperCase()).getCommand();
                if (e1 instanceof XMLCommand) {
                    CommandHandlerEnum.XMLERROR.execute(request, response, configuration, this.getServletContext(), new Object[]{e});
                } else {
                    CommandHandlerEnum.ERROR.execute(request, response, configuration, this.getServletContext(), new Object[]{e});
                }
            } else {
                CommandHandlerEnum.XMLERROR.execute(request, response, configuration, this.getServletContext(), new Object[]{e});
            }
        }
        catch (Exception var7) {
            throw new ServletException((Throwable)var7);
        }
    }

    public void init() throws ServletException {
        try {
            Field servletContextField = ServletContextFactory.class.getDeclaredField("servletContext");
            if (servletContextField != null) {
                servletContextField.setAccessible(true);
                servletContextField.set(null, this.getServletContext());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        Configuration configuration = null;
        try {
            String e = this.getServletConfig().getInitParameter("configuration");
            if (e != null) {
                Class<?> clazz = Class.forName(e);
                configuration = clazz.getConstructor(ServletConfig.class) != null ? (IConfiguration)clazz.getConstructor(ServletConfig.class).newInstance(this.getServletConfig()) : (IConfiguration)clazz.newInstance();
            } else {
                configuration = new Configuration(this.getServletConfig());
            }
        }
        catch (Exception var4) {
            configuration = new Configuration(this.getServletConfig());
        }
        try {
            ((IConfiguration)configuration).init();
            AccessControlUtil.getInstance((IConfiguration)((IConfiguration)configuration)).loadACLConfig();
        }
        catch (Exception var5) {
            if (Boolean.valueOf(this.getServletConfig().getInitParameter("debug")).booleanValue()) {
                var5.printStackTrace();
            }
            this.startException = var5;
            configuration = null;
        }
        ConfigurationFactory.getInstace().setConfiguration((IConfiguration)configuration);
    }

    private static enum CommandHandlerEnum {
        INIT((Command)new CKFAliyunInitCommand()),
        GETFOLDERS((Command)new CKFAliyunGetFoldersCommand()),
        GETFILES((Command)new CKFAliyunGetFilesCommand()),
        LOADCOOKIES((Command)new LoadCookiesCommand()),
        THUMBNAIL(new CKFAliyunThumbnailCommand()),
        DOWNLOADFILE((Command)new DownloadFileCommand()),
        CREATEFOLDER((Command)new CreateFolderCommand()),
        RENAMEFILE((Command)new CKFAliyunRenameFileCommand()),
        RENAMEFOLDER((Command)new RenameFolderCommand()),
        DELETEFOLDER((Command)new DeleteFolderCommand()),
        COPYFILES((Command)new CopyFilesCommand()),
        MOVEFILES((Command)new MoveFilesCommand()),
        DELETEFILES((Command)new CKFAliyunDeleteFilesCommand()),
        FILEUPLOAD(new CKFAliyunFileUploadCommand()),
        QUICKUPLOAD(new CKFAliyunQuickUploadCommand()),
        XMLERROR((Command)new XMLErrorCommand()),
        ERROR((Command)new ErrorCommand());

        private Command command;

        private CommandHandlerEnum(Command command1) {
            this.command = command1;
        }

        private void execute(HttpServletRequest request, HttpServletResponse response, IConfiguration configuration, ServletContext sc, Object ... params) throws ConnectorException {
            Command com = null;
            String userId = request.getParameter("userId");
            if (userId == null || !"".equals(userId == null ? "" : userId.trim())) {
                // empty if block
            }
            try {
                com = (Command)this.command.getClass().newInstance();
            }
            catch (IllegalAccessException var8) {
                throw new ConnectorException(10);
            }
            catch (InstantiationException var9) {
                throw new ConnectorException(10);
            }
            if (com == null) {
                throw new ConnectorException(10);
            }
            com.runCommand(request, response, configuration, params);
        }

        public Command getCommand() {
            return this.command;
        }
    }
}

