/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.ckfinder.connector.configuration.Events;
import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.EventArgs;
import com.ckfinder.connector.data.InitCommandEventArgs;
import com.ckfinder.connector.data.PluginInfo;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class CKFAliyunInitCommand
extends XMLCommand {
    private static final int[] LICENSE_CHARS = new int[]{11, 0, 8, 12, 26, 2, 3, 25, 1};
    private static final int LICENSE_CHAR_NR = 5;
    private static final int HASH = 255;
    private static final int LICENSE_KEY_LENGTH = 34;
    private String type;

    protected int getDataForXml() {
        return 0;
    }

    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (errorNum == 0) {
            block3: {
                this.createConnectorData(rootElement);
                try {
                    this.createResouceTypesData(rootElement);
                }
                catch (Exception var4) {
                    if (!this.configuration.isDebugMode()) break block3;
                    throw new ConnectorException(var4);
                }
            }
            this.createPluginsData(rootElement);
        }
    }

    private void createConnectorData(Element rootElement) {
        Element element = this.creator.getDocument().createElement("ConnectorInfo");
        element.setAttribute("enabled", String.valueOf(this.configuration.enabled()));
        element.setAttribute("s", this.getLicenseName());
        element.setAttribute("c", this.createLicenseKey(this.configuration.getLicenseKey()));
        element.setAttribute("thumbsEnabled", String.valueOf(this.configuration.getThumbsEnabled()));
        element.setAttribute("uploadCheckImages", this.configuration.checkSizeAfterScaling() ? "false" : "true");
        if (this.configuration.getThumbsEnabled()) {
            element.setAttribute("thumbsUrl", this.configuration.getThumbsURL());
            element.setAttribute("thumbsDirectAccess", String.valueOf(this.configuration.getThumbsDirectAccess()));
            element.setAttribute("thumbsWidth", String.valueOf(this.configuration.getMaxThumbWidth()));
            element.setAttribute("thumbsHeight", String.valueOf(this.configuration.getMaxThumbHeight()));
        }
        element.setAttribute("imgWidth", String.valueOf(this.configuration.getImgWidth()));
        element.setAttribute("imgHeight", String.valueOf(this.configuration.getImgHeight()));
        if (this.configuration.getPlugins().size() > 0) {
            element.setAttribute("plugins", this.getPlugins());
        }
        rootElement.appendChild(element);
    }

    private String getPlugins() {
        StringBuffer sb = new StringBuffer();
        boolean first = false;
        for (PluginInfo item : this.configuration.getPlugins()) {
            if (!item.isEnabled()) continue;
            if (first) {
                sb.append(",");
            }
            sb.append(item.getName());
            first = true;
        }
        return sb.toString();
    }

    private String getLicenseName() {
        int index;
        if (this.validateLicenseKey(this.configuration.getLicenseKey()) && ((index = "123456789ABCDEFGHJKLMNPQRSTUVWXYZ".indexOf(this.configuration.getLicenseKey().charAt(0)) % 5) == 1 || index == 4)) {
            return this.configuration.getLicenseName();
        }
        return "";
    }

    private String createLicenseKey(String licenseKey) {
        if (!this.validateLicenseKey(licenseKey)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i : LICENSE_CHARS) {
            sb.append(licenseKey.charAt(i));
        }
        return sb.toString();
    }

    private boolean validateLicenseKey(String licenseKey) {
        return licenseKey != null && licenseKey.length() == 34;
    }

    public void createPluginsData(Element rootElement) throws ConnectorException {
        Element element = this.creator.getDocument().createElement("PluginsInfo");
        rootElement.appendChild(element);
        InitCommandEventArgs args = new InitCommandEventArgs();
        args.setXml(this.creator);
        args.setRootElement(rootElement);
        if (this.configuration.getEvents() != null) {
            this.configuration.getEvents().run(Events.EventTypes.InitCommand, (EventArgs)args, this.configuration);
        }
    }

    private void createResouceTypesData(Element rootElement) throws Exception {
        Element element = this.creator.getDocument().createElement("ResourceTypes");
        rootElement.appendChild(element);
        List<String> types = null;
        if (((XMLCommand)this).type != null && !((XMLCommand)this).type.equals("")) {
            types = new ArrayList<String>();
            types.add(((XMLCommand)this).type);
        } else {
            types = this.getTypes();
        }
        Iterator<String> i$ = types.iterator();
        while (i$.hasNext()) {
            String key = i$.next();
            ResourceType resourceType = (ResourceType)this.configuration.getTypes().get(key);
            if (this.type != null && !this.type.equals(key) || resourceType == null || !AccessControlUtil.getInstance((IConfiguration)this.configuration).checkFolderACL(key, "/", this.userRole, 1)) continue;
            Element childElement = this.creator.getDocument().createElement("ResourceType");
            childElement.setAttribute("name", resourceType.getName());
            childElement.setAttribute("acl", String.valueOf(AccessControlUtil.getInstance((IConfiguration)this.configuration).checkACLForRole(key, "/", this.userRole)));
            childElement.setAttribute("hash", this.randomHash(resourceType.getPath()));
            childElement.setAttribute("allowedExtensions", resourceType.getAllowedExtensions());
            childElement.setAttribute("deniedExtensions", resourceType.getDeniedExtensions());
            childElement.setAttribute("url", resourceType.getUrl() + "/");
            Long maxSize = resourceType.getMaxSize();
            childElement.setAttribute("maxSize", maxSize != null && maxSize > 0L ? maxSize.toString() : "0");
            childElement.setAttribute("hasChildren", Boolean.valueOf(true).toString());
            element.appendChild(childElement);
        }
        return;
    }

    private List<String> getTypes() {
        return this.configuration.getDefaultResourceTypes().size() > 0 ? this.configuration.getDefaultResourceTypes() : this.configuration.getResourceTypesOrder();
    }

    private String randomHash(String folder) throws Exception {
        try {
            MessageDigest e = MessageDigest.getInstance("MD5");
            e.reset();
            try {
                e.update(folder.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException var6) {
                if (this.configuration.isDebugMode()) {
                    throw var6;
                }
                e.update(folder.getBytes());
            }
            byte[] messageDigest = e.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException var7) {
            if (this.configuration.isDebugMode()) {
                throw var7;
            }
            return "";
        }
    }

    protected boolean mustAddCurrentFolderNode() {
        return false;
    }

    protected void getCurrentFolderParam(HttpServletRequest request) {
        this.currentFolder = null;
    }
}

