package com.cxqm.xiaoerke.common.web;

/**
 * Created by yanghb on 17/3/9.
 */
//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import com.cxqm.xiaoerke.common.filter.CKFAliyunBukert;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.modules.sys.security.SystemAuthorizingRealm;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Map;


public class CKFAliyunRenameFileCommand extends XMLCommand implements IPostCommand {
	private String fileName;
	private String newFileName;
	private boolean renamed;
	private boolean addRenameNode;

	public CKFAliyunRenameFileCommand() {
	}

	protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
		if(this.addRenameNode) {
			this.createRenamedFileNode(rootElement);
		}

	}
	protected boolean checkIfCurrFolderExists(HttpServletRequest request) throws ConnectorException{
		return true;
	}
	private void createRenamedFileNode(Element rootElement) {
		Element element = this.creator.getDocument().createElement("RenamedFile");
		element.setAttribute("name", this.fileName);
		if(this.renamed) {
			element.setAttribute("newName", this.newFileName);
		}

		rootElement.appendChild(element);
	}

	protected int getDataForXml() {
		if(!AccessControlUtil.getInstance(this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 64)) {
			return 103;
		} else {
			if(this.configuration.forceASCII()) {
				this.newFileName = FileUtils.convertToASCII(this.newFileName);
			}

			if(this.fileName != null && !this.fileName.equals("") && this.newFileName != null && !this.newFileName.equals("")) {
				this.addRenameNode = true;
			}

			int checkFileExt = FileUtils.checkFileExtension(this.newFileName, (ResourceType)this.configuration.getTypes().get(this.type), this.configuration, true);
			if(checkFileExt == 1) {
				return 105;
			} else {
				if(checkFileExt == 2) {
					this.newFileName = FileUtils.renameFileWithBadExt(this.newFileName);
				}

				if(FileUtils.checkFileName(this.fileName) && !FileUtils.checkIfFileIsHidden(this.fileName, this.configuration)) {
					if(FileUtils.checkFileName(this.newFileName, this.configuration) && !FileUtils.checkIfFileIsHidden(this.newFileName, this.configuration)) {
						if(FileUtils.checkFileExtension(this.fileName, (ResourceType)this.configuration.getTypes().get(this.type), this.configuration, false) == 1) {
							return 109;
						} else {

							String buket_key = CKFAliyunBukert.getBuketKey();
							String userId = CKFAliyunBukert.getUserId();

							String dirPath = ((ResourceType)this.configuration.getTypes().get(this.type)).getPath() + this.currentFolder;
							File file = new File(dirPath, this.fileName);
							File newFile = new File(dirPath, this.newFileName);
							File dir = new File(dirPath);
							SystemAuthorizingRealm.Principal principal = (SystemAuthorizingRealm.Principal) UserUtils.getPrincipal();
							Map<String, ResourceType> types = this.configuration.getTypes();
							String typeName = ((ResourceType) types.get(this.type)).getName();
							if(!OSSObjectTool.isExists(buket_key == null || buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : buket_key, (userId == null || userId.trim().equals("") ? principal.getId() : userId) +"/" + typeName + this.currentFolder + this.fileName)) {
								return 117;
							} else if(OSSObjectTool.isExists(buket_key == null || buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : buket_key, (userId == null || userId.trim().equals("") ? principal.getId() : userId) +"/" + typeName + this.currentFolder + this.newFileName)) {
								return 115;
							} else {
								this.renamed = OSSObjectTool.renameFile(buket_key == null || buket_key.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : buket_key, ((userId == null || userId.trim().equals("") ? principal.getId() : userId) +"/" + typeName + this.currentFolder + this.fileName),((userId == null || userId.trim().equals("") ? principal.getId() : userId) + "/" + typeName + this.currentFolder + this.newFileName));
								if(this.renamed) {
									this.renameThumb();
									return 0;
								} else {
									return 104;
								}
							}

								//	OSSObjectTool.renameFile(OSSObjectTool.BUCKET_BACKEND_PIC,);

						}
					} else {
						return 102;
					}
				} else {
					return 109;
				}
			}
		}
	}

	private void renameThumb() {
//		File thumbFile = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder, this.fileName);
//		File newThumbFile = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder, this.newFileName);
//		OSSObjectTool.renameFile(OSSObjectTool.BUCKET_BACKEND_PIC,);
	}

	public void initParams(HttpServletRequest request, IConfiguration configuration, Object... params) throws ConnectorException {
		super.initParams(request, configuration, new Object[0]);
		this.fileName = this.getParameter(request, "fileName");
		this.newFileName = this.getParameter(request, "newFileName");
	}
}
