/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cxqm.xiaoerke.modules.sys.entity;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import com.cxqm.xiaoerke.common.bean.ICookieEntity;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.persistence.DataEntity;
import com.cxqm.xiaoerke.common.supcan.annotation.treelist.cols.SupCol;
import com.cxqm.xiaoerke.common.utils.Collections3;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import org.springframework.data.annotation.Transient;

/**
 * 用户Entity
 * @author ThinkGem
 * @version 2013-12-05
 */
public class User extends DataEntity<User> implements ICookieEntity {

	private static final long serialVersionUID = 1L;
	public static final String USER_TYPE_USER = "user";
	public static final String USER_TYPE_DOCTOR = "doctor";
	public static final String USER_TYPE_DISTRIBUTOR = "distributor";
	public static final String USER_TYPE_CONSULTDOCTOR = "consultDoctor";
	public static final String USER_TYPE_DOCTOR_HELPER = "doctorHelper";	// 医助 add by sunzs@2016-12-19
	
	private Office company;	// 归属公司
	private Office office;	// 归属部门
	private String loginName;// 登录名
	private String password;// 密码
	private String no;		// 工号
	private String name;	// 姓名
	private String email;	// 邮箱
	private String phone;	// 电话
	private String mobile;	// 手机
	private String userType;// 用户类型
	private String loginIp;	// 最后登陆IP
	private Date loginDate;	// 最后登陆日期
	private String loginFlag;	// 是否允许登陆
	private String photo;	// 头像
	private String buckter;

	private Date birthDate;// 出生日期 年月 日为01 例如 1995-02-01

	private String oldLoginName;// 原登录名
	private String newPassword;	// 新密码
	
	private String oldLoginIp;	// 上次登陆IP
	private Date oldLoginDate;	// 上次登陆日期

	private Role role;	// 根据角色查询用户条件
	
	private List<Role> roleList = Lists.newArrayList(); // 拥有角色列表

	private String openid;//openid

	private String marketer;

	private Integer sex;

	private String unionId;

	private String idPicFront;

	private String idPicFrontBucket;

	private String idPicBack;

	private String idPicBackBucket;

	private String dataFrom;

	private String detailedAddress;

	private String doctorOpenid;

	private String doctorHeplerOpenid;

	private List<String> ids;

	private List<String> names;

	private List<String> mobiles;

	private Integer height;

	private Integer weight;

	public List<String> getIds() {
		return ids;
	}

	public void setIds(List<String> ids) {
		this.ids = ids;
	}

	public List<String> getNames() {
		return names;
	}

	public void setNames(List<String> names) {
		this.names = names;
	}

	public List<String> getMobiles() {
		return mobiles;
	}

	public void setMobiles(List<String> mobiles) {
		this.mobiles = mobiles;
	}


	public Integer getSex() {
		return sex;
	}

	public void setSex(Integer sex) {
		this.sex = sex;
	}

	public String getUnionId() {
		return unionId;
	}

	public void setUnionId(String unionId) {
		this.unionId = unionId;
	}

	public String getIdPicFront() {
		return idPicFront;
	}

	public void setIdPicFront(String idPicFront) {
		this.idPicFront = idPicFront;
	}

	public String getIdPicFrontBucket() {
		return idPicFrontBucket;
	}

	public void setIdPicFrontBucket(String idPicFrontBucket) {
		this.idPicFrontBucket = idPicFrontBucket;
	}

	public String getIdPicBack() {
		return idPicBack;
	}

	public void setIdPicBack(String idPicBack) {
		this.idPicBack = idPicBack;
	}

	public String getIdPicBackBucket() {
		return idPicBackBucket;
	}

	public void setIdPicBackBucket(String idPicBackBucket) {
		this.idPicBackBucket = idPicBackBucket;
	}

	public String getDataFrom() {
		return dataFrom;
	}

	public void setDataFrom(String dataFrom) {
		this.dataFrom = dataFrom;
	}

	private String realName;

	private String idCard;

	private String region;

	private String updateType;		//两种修改方法  基本信息

	private String interimPhoto;	//临时字段

	private String idPicFrontTran;	//临时字段 身份证正面图片地址展示

	private String idPicBackTran;	//临时字段 身份证反面图片地址展示

	public User() {
		super();
		this.loginFlag = Global.YES;
	}
	
	public User(String id){
		super(id);
	}

	public User(String id, String loginName){
		super(id);
		this.loginName = loginName;
	}

	public User(Role role){
		super();
		this.role = role;
	}
	
	public String getPhoto() {
		return photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}

	public String getLoginFlag() {
		return loginFlag;
	}

	public void setLoginFlag(String loginFlag) {
		this.loginFlag = loginFlag;
	}

	@SupCol(isUnique="true", isHide="true")
	public String getId() {
		return id;
	}

	@JsonIgnore
	@NotNull(message="归属公司不能为空")
	public Office getCompany() {
		return company;
	}

	public void setCompany(Office company) {
		this.company = company;
	}

	@JsonIgnore
	@NotNull(message="归属部门不能为空")
	public Office getOffice() {
		return office;
	}

	public void setOffice(Office office) {
		this.office = office;
	}

	@Length(min=1, max=100, message="登录名长度必须介于 1 和 100 之间")
	public String getLoginName() {
		return loginName;
	}

	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	@JsonIgnore
	@Length(min=1, max=100, message="密码长度必须介于 1 和 100 之间")
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	@Length(min=1, max=100, message="姓名长度必须介于 1 和 100 之间")
	public String getName() {
		return name;
	}
	
	@Length(min=1, max=100, message="工号长度必须介于 1 和 100 之间")
	public String getNo() {
		return no;
	}

	public void setNo(String no) {
		this.no = no;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Email(message="邮箱格式不正确")
	@Length(min=0, max=200, message="邮箱长度必须介于 1 和 200 之间")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}
	
	@Length(min=0, max=200, message="电话长度必须介于 1 和 200 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	@Length(min=0, max=200, message="手机长度必须介于 1 和 200 之间")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getRemarks() {
		return remarks;
	}
	
	@Length(min=0, max=100, message="用户类型长度必须介于 1 和 100 之间")
	public String getUserType() {
		return userType;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public String getLoginIp() {
		return loginIp;
	}

	public void setLoginIp(String loginIp) {
		this.loginIp = loginIp;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getLoginDate() {
		return loginDate;
	}

	public void setLoginDate(Date loginDate) {
		this.loginDate = loginDate;
	}

	public String getOldLoginName() {
		return oldLoginName;
	}

	public void setOldLoginName(String oldLoginName) {
		this.oldLoginName = oldLoginName;
	}

	public String getNewPassword() {
		return newPassword;
	}

	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}

	public String getOldLoginIp() {
		if (oldLoginIp == null){
			return loginIp;
		}
		return oldLoginIp;
	}

	public void setOldLoginIp(String oldLoginIp) {
		this.oldLoginIp = oldLoginIp;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getOldLoginDate() {
		if (oldLoginDate == null){
			return loginDate;
		}
		return oldLoginDate;
	}

	public void setOldLoginDate(Date oldLoginDate) {
		this.oldLoginDate = oldLoginDate;
	}

	public Role getRole() {
		return role;
	}

	public void setRole(Role role) {
		this.role = role;
	}

	@JsonIgnore
	public List<Role> getRoleList() {
		return roleList;
	}
	
	public void setRoleList(List<Role> roleList) {
		this.roleList = roleList;
	}

	@JsonIgnore
	public List<String> getRoleIdList() {
		List<String> roleIdList = Lists.newArrayList();
		for (Role role : roleList) {
			roleIdList.add(role.getId());
		}
		return roleIdList;
	}

	public void setRoleIdList(List<String> roleIdList) {
		roleList = Lists.newArrayList();
		for (String roleId : roleIdList) {
			Role role = new Role();
			role.setId(roleId);
			roleList.add(role);
		}
	}
	
	/**
	 * 用户拥有的角色名称字符串, 多个角色名称用','分隔.
	 */
	public String getRoleNames() {
		return Collections3.extractToString(roleList, "name", ",");
	}
	
	public boolean isAdmin(){
		return isAdmin(this.id);
	}
	
	public static boolean isAdmin(String id){
		return id != null && "1".equals(id);
	}
	
	@Override
	public String toString() {
		return id;
	}

	@JsonIgnore
	@Length(min=1, max=500, message="openid")
	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getMarketer() {
		return marketer;
	}

	public void setMarketer(String marketer) {
		this.marketer = marketer;
	}

	public String getBuckter() {
		return buckter;
	}

	public void setBuckter(String buckter) {
		this.buckter = buckter;
	}

	public String getFullPhoto() {
		if (this.photo == null || this.buckter == null) {
			return null;
		}
		return OSSObjectTool.getUrl(this.photo, this.buckter);
	}

	public String getIdPicFrontPhoto() {
		if (this.idPicFront == null || this.idPicFrontBucket == null) {
			return null;
		}
		return OSSObjectTool.getUrl(this.idPicFront, this.idPicFrontBucket);
	}

	public String getIdPicBackPhoto() {
		if (this.idPicBack == null || this.idPicBackBucket == null) {
			return null;
		}
		return OSSObjectTool.getUrl(this.idPicBack, this.idPicBackBucket);
	}

	public String getRealName() {
		return realName;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}

	public String getIdCard() {
		return idCard;
	}

	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public String getUpdateType() {
		return updateType;
	}

	public void setUpdateType(String updateType) {
		this.updateType = updateType;
	}

	public String getInterimPhoto() {
		return interimPhoto;
	}

	public void setInterimPhoto(String interimPhoto) {
		this.interimPhoto = interimPhoto;
	}

	public String getDetailedAddress() {
		return detailedAddress;
	}

	public void setDetailedAddress(String detailedAddress) {
		this.detailedAddress = detailedAddress;
	}

	public String getIdPicFrontTran() {
		return idPicFrontTran;
	}

	public void setIdPicFrontTran(String idPicFrontTran) {
		this.idPicFrontTran = idPicFrontTran;
	}

	public String getIdPicBackTran() {
		return idPicBackTran;
	}

	public void setIdPicBackTran(String idPicBackTran) {
		this.idPicBackTran = idPicBackTran;
	}

	@Override
	public void setFullPhoto(String fullPhoto) {

	}
	public String getDoctorOpenid() {
		return doctorOpenid;
	}

	public void setDoctorOpenid(String doctorOpenid) {
		this.doctorOpenid = doctorOpenid;
	}

	public String getDoctorHeplerOpenid() {
		return doctorHeplerOpenid;
	}

	public void setDoctorHeplerOpenid(String doctorHeplerOpenid) {
		this.doctorHeplerOpenid = doctorHeplerOpenid;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public Integer getAge(){

		if(this.birthDate == null){
			return null;
		}

		Calendar from  =  Calendar.getInstance();
		from.setTime(this.birthDate);

		Calendar  to  =  Calendar.getInstance();
		to.setTime(new Date());

		int fromYear = from.get(Calendar.YEAR);
		int fromMonth = from.get(Calendar.MONTH);

		int toYear = to.get(Calendar.YEAR);
		int toMonth = to.get(Calendar.MONTH);

		Integer year = toYear - fromYear;

		return toMonth >= fromMonth ? year : year - 1;
	}

	public Integer getHeight() {
		return height;
	}

	public void setHeight(Integer height) {
		this.height = height;
	}

	public Integer getWeight() {
		return weight;
	}

	public void setWeight(Integer weight) {
		this.weight = weight;
	}
}