/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.utils.ResponseMapBuilder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;

public class JsonpUtils {
    public static String getResultForJsonp(String callback, ControllerDelegate delegate) {
        Map<String, Object> resultMap = null;
        try {
            resultMap = delegate.delegate();
        }
        catch (BusinessException e) {
            resultMap = ResponseMapBuilder.newBuilder().putBusinessException(e).getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap = ResponseMapBuilder.newBuilder().put("resultCode", "9999").put("resultMsg", e.getMessage() == null ? "\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38" : e.getMessage()).getResult();
        }
        return JsonpUtils.getByMap(callback, resultMap);
    }

    public static String getResultForJsonp(HttpServletRequest request, ControllerDelegate delegate) {
        String callback = request.getParameter("callback");
        return JsonpUtils.getResultForJsonp(callback, delegate);
    }

    public static String getByMap(String callback, Map<String, Object> result) {
        String strRes = JSONObject.fromObject(result).toString();
        strRes = callback + "(" + strRes + ")";
        return strRes;
    }

    public static interface ControllerDelegate {
        public Map delegate() throws Exception;
    }
}

