package com.cxqm.xiaoerke.common.filter;

import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;

import java.util.HashMap;

/**
 * Created by sunzb on 2017/12/8.
 */
public class DHMUserInfo {

    private static ThreadLocal<HashMap<String, Object>> threadLocals = new ThreadLocal<HashMap<String, Object>>();


    public static final String CURRENT_DHUSER = "CURRENT_DHUSER";
    public static final String CURRENT_WEIXIN_DHUSER = "CURRENT_WEIXIN_DHUSER";

    /**
     * 取得线程变量值
     *
     * @param name
     *            线程变量名
     * @return 线程变量值
     */
    public static Object getValue(String name) {
        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap<String, Object>());
        }
        return threadLocals.get().get(name);
    }

    /**
     * 设置线程变量值
     *
     * @param name
     *            线程变量名
     * @param value
     *            线程变量值
     */
    public static void setValue(String name, Object value) {
        //清空另一个线程用户配置线程
        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap<String, Object>());
        }
        threadLocals.get().put(name, value);
    }

    public static void setDHUserInfoValue(User user){
        DHMUserInfo.setValue(DHMUserInfo.CURRENT_DHUSER,user);
    }

    public static User getDHUserInfoValue(){
        return (User)DHMUserInfo.getValue(DHMUserInfo.CURRENT_DHUSER);
    }

    public static void setWeiXinDHUserInfoValue(WechatUserInfo info){
        DHMUserInfo.setValue(DHMUserInfo.CURRENT_WEIXIN_DHUSER,info);
    }

    public static WechatUserInfo getWeiXinDHUserInfoValue(){
        return (WechatUserInfo)DHMUserInfo.getValue(DHMUserInfo.CURRENT_WEIXIN_DHUSER);
    }

    public static void clearWeiXinDHUserInfoValue(){
        DHMUserInfo.setValue(DHMUserInfo.CURRENT_WEIXIN_DHUSER,"");
    }

    public static void removeValue(String name) {
        if (threadLocals.get() == null) {
            return;
        }
        threadLocals.get().remove(name);
    }

    public static void clear() {
        if (threadLocals.get() != null) {
            threadLocals.get().clear();
        }
    }

}
