/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.utils.IdGen;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.springframework.web.multipart.MultipartFile;

public class OSSObjectTool {
    private static OSSClient ossClient = null;
    public static String BUCKET_BASE_HOST = null;
    public static String BUCKET_DOCTOR_PIC = null;
    public static String BUCKET_ARTICLE_PIC = null;
    public static String BUCKET_CONSULT_PIC = null;
    public static String BUCKET_COMMON_PIC = null;
    public static String BUCKET_CASE_PIC = null;
    public static String BUCKET_BACKEND_PIC = null;
    public static String BUCKET_YMFBINGLI_PIC = null;

    public static String uploadFileInputStream(String key, Long length, InputStream in, String bucket) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(length.longValue());
        new HashMap();
        ossClient.putObject(bucket, key, in, objectMeta);
        return key;
    }

    public static String uploadFileByUrl(String bucket, String key, String url) throws IOException {
        InputStream inputStream = new URL(url).openStream();
        ossClient.putObject(bucket, key, inputStream);
        return key;
    }

    public static String routeImage(String bucket, String key, Integer route) throws IOException {
        String finalKey = OSSObjectTool.getTouteName(key, route);
        String finalUrl = OSSObjectTool.getUrl(finalKey, bucket);
        OSSObjectTool.uploadFileByUrl(bucket, key, finalUrl);
        return key;
    }

    public static String uploadFileByMultipartFile(String key, MultipartFile file, String bucket) throws IOException {
        if (file == null) {
            return null;
        }
        String ext = OSSObjectTool.getExtname(file);
        long length = file.getSize();
        String resultKey = OSSObjectTool.uploadFileInputStream(key == null ? IdGen.uuid() + ext : key, length, file.getInputStream(), bucket);
        file.getInputStream().close();
        return resultKey;
    }

    public static String getExtname(MultipartFile file) {
        String contentType = file.getContentType();
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        String ext = "";
        try {
            int lastPointIndex;
            MimeType mimeType = allTypes.forName(contentType);
            ext = mimeType.getExtension();
            if ((ext == null || ext.trim().length() == 0) && (lastPointIndex = file.getOriginalFilename().lastIndexOf(46)) > 0) {
                ext = file.getOriginalFilename().substring(lastPointIndex);
            }
        }
        catch (MimeTypeException e) {
            ext = ".jpg";
        }
        return ext;
    }

    public static String getUrl(String key, String bucket) {
        return String.format("http://%s.%s/%s", bucket, BUCKET_BASE_HOST, key);
    }

    public static String getDoctorPicBaseUrl() {
        return "http://xiaoerke-doctor-pic.oss-cn-beijing.aliyuncs.com/";
    }

    public static String getConsultMediaBaseUrl() {
        return "http://xiaoerke-common-pic.oss-cn-beijing.aliyuncs.com/";
    }

    public static Map<String, String> getObject(String bucketName, String key) throws OSSException, ClientException, FileNotFoundException {
        return null;
    }

    public static void main(String[] args) throws Exception {
        String newFolder = "abc/def";
        boolean found = ossClient.doesObjectExist("junhaoyun-backend", newFolder);
        ossClient.putObject("junhaoyun-backend", newFolder, (InputStream)new ByteArrayInputStream(new byte[0]));
        System.out.println(found);
    }

    public static List<String> getChildFolders(String bucket, String currentFolder) {
        ArrayList<String> folders = new ArrayList<String>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket);
        listObjectsRequest.setDelimiter("/");
        if (currentFolder.startsWith("/")) {
            listObjectsRequest.setPrefix(currentFolder.substring(1));
        } else {
            listObjectsRequest.setPrefix(currentFolder);
        }
        ObjectListing listing = ossClient.listObjects(listObjectsRequest);
        for (String commonPrefix : listing.getCommonPrefixes()) {
            folders.add(commonPrefix.replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"));
        }
        return folders;
    }

    public static List<OSSFile> getChildFiles(String bucket, String currentFolder) {
        ArrayList<OSSFile> files = new ArrayList<OSSFile>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket);
        listObjectsRequest.setDelimiter("/");
        listObjectsRequest.setPrefix(currentFolder.substring(1));
        ObjectListing listing = ossClient.listObjects(listObjectsRequest);
        for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
            if (currentFolder.substring(1).equals(objectSummary.getKey()) && objectSummary.getSize() == 0L) continue;
            Object size = null;
            files.add(new OSSFile(objectSummary.getKey().replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"), objectSummary.getLastModified(), objectSummary.getSize()));
        }
        return files;
    }

    public static Boolean createFolder(String bucket, String newFolder) {
        boolean found = ossClient.doesObjectExist(bucket, newFolder);
        if (!found) {
            ossClient.putObject(bucket, newFolder, (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return true;
    }

    public static Boolean uploadFile(String bucket, String key, InputStream inputStream) {
        ossClient.putObject(bucket, key, inputStream);
        return true;
    }

    public static Boolean renameFile(String bucket, String fromKey, String toKey) {
        CopyObjectResult result = ossClient.copyObject(bucket, fromKey, bucket, toKey);
        OSSObjectTool.delFile(bucket, fromKey);
        return true;
    }

    public static Boolean isExists(String bucket, String key) {
        return ossClient.doesObjectExist(bucket, key);
    }

    public static Boolean delFile(String bucket, String key) {
        if (OSSObjectTool.isExists(bucket, key).booleanValue()) {
            ossClient.deleteObject(bucket, key);
        }
        return true;
    }

    public static String getTouteName(String fileName, Integer angle) {
        if (fileName == null) {
            return null;
        }
        if (angle == null) {
            return fileName;
        }
        return fileName + "?x-oss-process=image/resize,m_lfit,w_4096,h_4096,limit_1/auto-orient,0/rotate," + angle;
    }

    static {
        String accesskey = Global.getConfig("aliyun.accesskey");
        String secret = Global.getConfig("aliyun.secret");
        String host = Global.getConfig("oss.host");
        BUCKET_DOCTOR_PIC = Global.getConfig("oss.bucket.doctor.pic");
        BUCKET_ARTICLE_PIC = Global.getConfig("oss.bucket.article.pic");
        BUCKET_CONSULT_PIC = Global.getConfig("oss.bucket.consult.pic");
        BUCKET_COMMON_PIC = Global.getConfig("oss.bucket.common.pic");
        BUCKET_CASE_PIC = Global.getConfig("oss.bucket.case.pic");
        BUCKET_BASE_HOST = Global.getConfig("oss.bucket.basehost");
        BUCKET_BACKEND_PIC = Global.getConfig("oss.bucket.backend.pic");
        BUCKET_YMFBINGLI_PIC = Global.getConfig("oss.bucket.ymfbingli.pic");
        ossClient = new OSSClient(host, accesskey, secret);
    }

    public static class OSSFile {
        private String fileName;
        private Date lastModified;
        private Long size;

        public OSSFile() {
        }

        public OSSFile(String fileName, Date lastModified, Long size) {
            this.fileName = fileName;
            this.lastModified = lastModified;
            this.size = size;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }
}

