/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.utils;

import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.sys.entity.Area;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.security.SystemAuthorizingRealm;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtilsShiroImpl;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtilsSpringSecurityImpl;
import java.util.List;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class UserUtils {
    private static String applicationName = SpringContextHolder.getApplicationContext().getApplicationName();
    private static boolean isBackend = applicationName.indexOf("backend") != -1;
    public static final String USER_CACHE = "userCache";
    public static final String USER_CACHE_ID_ = "id_";
    public static final String USER_CACHE_LOGIN_NAME_ = "ln";
    public static final String USER_CACHE_LIST_BY_OFFICE_ID_ = "oid_";
    public static final String CACHE_ROLE_LIST = "roleList";
    public static final String CACHE_MENU_LIST = "menuList";
    public static final String CACHE_AREA_LIST = "areaList";
    public static final String CACHE_OFFICE_LIST = "officeList";
    public static final String CACHE_OFFICE_ALL_LIST = "officeAllList";

    public static User get(String id) {
        if (isBackend) {
            return UserUtilsShiroImpl.get(id);
        }
        return UserUtilsSpringSecurityImpl.get(id);
    }

    public static User getByLoginName(String loginName) {
        if (isBackend) {
            return UserUtilsShiroImpl.getByLoginName(loginName);
        }
        return UserUtilsSpringSecurityImpl.getByLoginName(loginName);
    }

    public static User getByLoginName(String loginName, boolean withRole) {
        if (isBackend) {
            return UserUtilsShiroImpl.getByLoginName(loginName, withRole);
        }
        return UserUtilsSpringSecurityImpl.getByLoginName(loginName);
    }

    public static void clearCache() {
        if (isBackend) {
            UserUtilsShiroImpl.clearCache();
        } else {
            UserUtilsSpringSecurityImpl.clearCache();
        }
    }

    public static void clearCache(User user) {
        if (isBackend) {
            UserUtilsShiroImpl.clearCache(user);
        }
    }

    public static User getUser() {
        if (isBackend) {
            return UserUtilsShiroImpl.getUser();
        }
        return UserUtilsSpringSecurityImpl.getUser();
    }

    public static List<Role> getRoleList() {
        if (isBackend) {
            return UserUtilsShiroImpl.getRoleList();
        }
        return UserUtilsSpringSecurityImpl.getRoleList();
    }

    public static List<Menu> getMenuList() {
        if (isBackend) {
            return UserUtilsShiroImpl.getMenuList();
        }
        return UserUtilsSpringSecurityImpl.getMenuList();
    }

    public static boolean getModifyPermissions(String userId, String roleEnName, String statusName) {
        boolean statusCode = false;
        List<Role> roleList = null;
        roleList = isBackend ? UserUtilsShiroImpl.getSpecifiedRoleList(userId) : UserUtilsSpringSecurityImpl.getSpecifiedRoleList(userId);
        for (Role role : roleList) {
            if (!role.getEnname().endsWith(roleEnName)) continue;
            List<Menu> menuList = UserUtilsShiroImpl.getSpecifiedMenuList(roleEnName);
            for (Menu menu : menuList) {
                if (!menu.getName().equals(statusName)) continue;
                statusCode = true;
            }
        }
        return statusCode;
    }

    public static List<Area> getAreaList() {
        if (isBackend) {
            return UserUtilsShiroImpl.getAreaList();
        }
        return UserUtilsSpringSecurityImpl.getAreaList();
    }

    public static List<Office> getOfficeList() {
        if (isBackend) {
            return UserUtilsShiroImpl.getOfficeList();
        }
        return UserUtilsSpringSecurityImpl.getOfficeList();
    }

    public static List<Office> getOfficeAllList() {
        if (isBackend) {
            return UserUtilsShiroImpl.getOfficeAllList();
        }
        return UserUtilsSpringSecurityImpl.getOfficeAllList();
    }

    public static Subject getSubject() {
        return UserUtilsShiroImpl.getSubject();
    }

    public static SystemAuthorizingRealm.Principal getPrincipal() {
        return UserUtilsShiroImpl.getPrincipal();
    }

    public static Session getSession() {
        return UserUtilsShiroImpl.getSession();
    }

    public static Object getCache(String key) {
        if (isBackend) {
            return UserUtilsShiroImpl.getCache(key);
        }
        return UserUtilsSpringSecurityImpl.getCache(key);
    }

    public static Object getCache(String key, Object defaultValue) {
        if (isBackend) {
            return UserUtilsShiroImpl.getCache(key, defaultValue);
        }
        return UserUtilsSpringSecurityImpl.getCache(key, defaultValue);
    }

    public static void putCache(String key, Object value) {
        if (isBackend) {
            UserUtilsShiroImpl.putCache(key, value);
        } else {
            UserUtilsSpringSecurityImpl.putCache(key, value);
        }
    }

    public static void removeCache(String key) {
        if (isBackend) {
            UserUtilsShiroImpl.removeCache(key);
        } else {
            UserUtilsSpringSecurityImpl.removeCache(key);
        }
    }
}

