/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.utils;

import com.cxqm.xiaoerke.common.service.BaseService;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.sys.dao.AreaDao;
import com.cxqm.xiaoerke.modules.sys.dao.MenuDao;
import com.cxqm.xiaoerke.modules.sys.dao.OfficeDao;
import com.cxqm.xiaoerke.modules.sys.dao.RoleDao;
import com.cxqm.xiaoerke.modules.sys.dao.UserDao;
import com.cxqm.xiaoerke.modules.sys.entity.Area;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.SystemService;
import com.cxqm.xiaoerke.modules.sys.utils.SecurityUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UserUtilsSpringSecurityImpl {
    private static SystemService systemService = SpringContextHolder.getBean(SystemService.class);
    private static RoleDao roleDao = SpringContextHolder.getBean(RoleDao.class);
    private static MenuDao menuDao = SpringContextHolder.getBean(MenuDao.class);
    private static AreaDao areaDao = SpringContextHolder.getBean(AreaDao.class);
    private static OfficeDao officeDao = SpringContextHolder.getBean(OfficeDao.class);
    private static UserDao userDao = SpringContextHolder.getBean(UserDao.class);
    public static final String USER_CACHE = "userCache";
    public static final String USER_CACHE_ID_ = "id_";
    public static final String USER_CACHE_LOGIN_NAME_ = "ln";
    public static final String CACHE_USER = "user";
    public static final String CACHE_ROLE_LIST = "roleList";
    public static final String CACHE_MENU_LIST = "menuList";
    public static final String CACHE_AREA_LIST = "areaList";
    public static final String CACHE_OFFICE_LIST = "officeList";
    public static final String CACHE_OFFICE_ALL_LIST = "officeAllList";

    public static User get(String id) {
        User user = (User)CacheUtils.get(USER_CACHE, USER_CACHE_ID_ + id);
        if (user == null && (user = (User)((Object)userDao.get(id))) == null) {
            return null;
        }
        return user;
    }

    public static User getByLoginName(String loginName) {
        User user = userDao.getByLoginName(new User(null, loginName));
        return user;
    }

    public static String getUserId() {
        User u = UserUtilsSpringSecurityImpl.getUser();
        return u == null ? null : u.getId();
    }

    public static User getUser() {
        Authentication authentication;
        User user = (User)UserUtilsSpringSecurityImpl.getCache(CACHE_USER);
        if (user == null && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            Object principal = authentication.getPrincipal();
            String loginName = null;
            if (principal instanceof org.springframework.security.core.userdetails.User) {
                loginName = ((org.springframework.security.core.userdetails.User)principal).getUsername();
            } else if (principal instanceof String) {
                loginName = principal.toString();
            }
            if (loginName != null) {
                user = systemService.getUserByLoginName(loginName);
                UserUtilsSpringSecurityImpl.putCache(CACHE_USER, user);
            }
        }
        if (user == null) {
            user = new User();
        }
        return user;
    }

    public static User getUser(String userId) {
        return systemService.getUser(userId);
    }

    public static String getUserName(String userId) {
        User user = systemService.getUser(userId);
        if (user == null || user.getName() == null) {
            return "";
        }
        return user.getName();
    }

    public static Object getCache(String key) {
        return UserUtilsSpringSecurityImpl.getCache(key, null);
    }

    public static Object getCache(String key, Object defaultValue) {
        HttpSession session;
        HttpServletRequest request;
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null && (request = ((ServletRequestAttributes)attributes).getRequest()) != null && (session = request.getSession()) != null) {
            return session.getAttribute(key);
        }
        return defaultValue;
    }

    public static void putCache(String key, Object value) {
        HttpSession session;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (request != null && (session = request.getSession()) != null) {
            session.setAttribute(key, value);
        }
    }

    public static void removeCache(String key) {
        UserUtilsSpringSecurityImpl.getCacheMap().remove(key);
    }

    public static Map<String, Object> getCacheMap() {
        SecurityUtils.Subject subject = SecurityUtils.getSubject();
        SecurityUtils.Principal principal = subject.getPrincipal();
        return principal != null ? principal.getCacheMap() : new HashMap<String, Object>();
    }

    public static void clearCache() {
        UserUtilsSpringSecurityImpl.removeCache(CACHE_ROLE_LIST);
        UserUtilsSpringSecurityImpl.removeCache(CACHE_MENU_LIST);
        UserUtilsSpringSecurityImpl.removeCache(CACHE_AREA_LIST);
        UserUtilsSpringSecurityImpl.removeCache(CACHE_OFFICE_LIST);
        UserUtilsSpringSecurityImpl.removeCache(CACHE_OFFICE_ALL_LIST);
        UserUtilsSpringSecurityImpl.removeCache(CACHE_USER);
    }

    public static List<Role> getRoleList() {
        List<Role> roleList = (List<Role>)UserUtilsSpringSecurityImpl.getCache(CACHE_ROLE_LIST);
        if (roleList == null) {
            User user = UserUtilsSpringSecurityImpl.getUser();
            if (user.isAdmin()) {
                roleList = roleDao.findAllList(new Role());
            } else {
                Role role = new Role();
                role.getSqlMap().put("dsf", BaseService.dataScopeFilter(user.getCurrentUser(), "o", "u"));
                roleList = roleDao.findList(role);
            }
            UserUtilsSpringSecurityImpl.putCache(CACHE_ROLE_LIST, roleList);
        }
        return roleList;
    }

    public static List<Role> getSpecifiedRoleList(String userId) {
        List<Role> roleList = (List<Role>)UserUtilsSpringSecurityImpl.getCache(CACHE_ROLE_LIST);
        if (roleList == null) {
            User user = UserUtilsSpringSecurityImpl.get(userId);
            if (user.isAdmin()) {
                roleList = roleDao.findAllList(new Role());
            } else {
                Role role = new Role();
                role.getSqlMap().put("dsf", BaseService.dataScopeFilter(user.getCurrentUser(), "o", "u"));
                roleList = roleDao.findList(role);
            }
            UserUtilsSpringSecurityImpl.putCache(CACHE_ROLE_LIST, roleList);
        }
        return roleList;
    }

    public static List<Menu> getMenuList() {
        List<Menu> menuList = (List<Menu>)UserUtilsSpringSecurityImpl.getCache(CACHE_MENU_LIST);
        if (menuList == null) {
            User user = UserUtilsSpringSecurityImpl.getUser();
            if (user.isAdmin()) {
                menuList = menuDao.findAllList(new Menu());
            } else {
                Menu m = new Menu();
                m.setUserId(user.getId());
                menuList = menuDao.findByUserId(m);
            }
            UserUtilsSpringSecurityImpl.putCache(CACHE_MENU_LIST, menuList);
        }
        return menuList;
    }

    public static List<Area> getAreaList() {
        List<Area> areaList = (List<Area>)UserUtilsSpringSecurityImpl.getCache(CACHE_AREA_LIST);
        if (areaList == null) {
            areaList = areaDao.findAllList(new Area());
            UserUtilsSpringSecurityImpl.putCache(CACHE_AREA_LIST, areaList);
        }
        return areaList;
    }

    public static List<Office> getOfficeList() {
        List<Office> officeList = (List<Office>)UserUtilsSpringSecurityImpl.getCache(CACHE_OFFICE_LIST);
        if (officeList == null) {
            User user = UserUtilsSpringSecurityImpl.getUser();
            if (user.isAdmin()) {
                officeList = officeDao.findAllList(new Office());
            } else {
                Office office = new Office();
                office.getSqlMap().put("dsf", BaseService.dataScopeFilter(user, "a", ""));
                officeList = officeDao.findList(office);
            }
            UserUtilsSpringSecurityImpl.putCache(CACHE_OFFICE_LIST, officeList);
        }
        return officeList;
    }

    public static List<Office> getOfficeAllList() {
        List<Office> officeList = (List<Office>)UserUtilsSpringSecurityImpl.getCache(CACHE_OFFICE_ALL_LIST);
        if (officeList == null) {
            officeList = officeDao.findAllList(new Office());
        }
        return officeList;
    }
}

