/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.persistence;

import com.cxqm.xiaoerke.common.persistence.Order;
import com.cxqm.xiaoerke.common.persistence.Page;
import java.util.List;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;

public class MysqlDialect {
    protected MappedStatement mappedStatement;
    protected Page pageBounds;
    protected Object parameterObject;
    protected BoundSql boundSql;
    private String pageSQL;
    private String countSQL;

    public MysqlDialect(MappedStatement mappedStatement, Object parameterObject, Page pageBounds) {
        this.mappedStatement = mappedStatement;
        this.parameterObject = parameterObject;
        this.pageBounds = pageBounds;
        this.init();
    }

    protected void init() {
        String sql;
        this.boundSql = this.mappedStatement.getBoundSql(this.parameterObject);
        StringBuffer bufferSql = new StringBuffer(this.boundSql.getSql().trim());
        if (bufferSql.lastIndexOf(";") == bufferSql.length() - 1) {
            bufferSql.deleteCharAt(bufferSql.length() - 1);
        }
        this.pageSQL = sql = bufferSql.toString();
        if (this.pageBounds.getOrders() != null && !this.pageBounds.getOrders().isEmpty()) {
            this.pageSQL = this.getSortString(sql, this.pageBounds.getOrders());
        }
        if (this.pageBounds.getOffset() != 0 || this.pageBounds.getLimit() != Integer.MAX_VALUE) {
            this.pageSQL = this.getLimitString(this.pageSQL, this.pageBounds.getOffset(), this.pageBounds.getLimit());
        }
        this.countSQL = this.getCountString(sql);
    }

    public String getPageSQL() {
        return this.pageSQL;
    }

    public String getCountSQL() {
        return this.countSQL;
    }

    protected String getLimitString(String sql, int offset, int limit) {
        StringBuffer buffer = new StringBuffer(sql.length() + 20).append(sql);
        if (offset > 0) {
            buffer.append(" limit ").append(offset).append(",").append(limit);
        } else {
            buffer.append(" limit ").append(limit);
        }
        return buffer.toString();
    }

    protected String getCountString(String sql) {
        return "select count(1) from (" + sql + ") tmp_count";
    }

    protected String getSortString(String sql, List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return sql;
        }
        StringBuffer buffer = new StringBuffer("select * from (").append(sql).append(") temp_order order by ");
        for (Order order : orders) {
            if (order == null) continue;
            buffer.append(order.toString()).append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        return buffer.toString();
    }
}

