/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.service;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.security.Digests;
import com.cxqm.xiaoerke.common.service.BaseService;
import com.cxqm.xiaoerke.common.service.ServiceException;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.Encodes;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.sys.dao.MenuDao;
import com.cxqm.xiaoerke.modules.sys.dao.RoleDao;
import com.cxqm.xiaoerke.modules.sys.dao.SwitchConfigureDao;
import com.cxqm.xiaoerke.modules.sys.dao.SystemDao;
import com.cxqm.xiaoerke.modules.sys.dao.UserDao;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.cxqm.xiaoerke.modules.sys.entity.SwitchConfigure;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.ISystemService;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SystemService
extends BaseService
implements ISystemService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private MenuDao menuDao;
    @Autowired
    private SystemDao systemDao;
    @Autowired
    private SwitchConfigureDao switchConfigureDao;

    public User getUser(String id) {
        return UserUtils.get(id);
    }

    public User getUserById(String id) {
        return (User)((Object)this.userDao.get(id));
    }

    @Override
    public User getUserByLoginName(String loginName) {
        return UserUtils.getByLoginName(loginName);
    }

    public Page<User> findUser(Page<User> page, User user) {
        user.getSqlMap().put("dsf", SystemService.dataScopeFilter(user.getCurrentUser(), "o", "a"));
        user.setPage(page);
        page.setList(this.userDao.findList(user));
        return page;
    }

    public List<User> findUser(User user) {
        user.getSqlMap().put("dsf", SystemService.dataScopeFilter(user.getCurrentUser(), "o", "a"));
        List<User> list = this.userDao.findList(user);
        return list;
    }

    public List<User> findUserByOfficeId(String officeId) {
        List<User> list = (List<User>)CacheUtils.get("userCache", "oid_" + officeId);
        if (list == null) {
            User user = new User();
            user.setOffice(new Office(officeId));
            list = this.userDao.findUserByOfficeId(user);
            CacheUtils.put("userCache", "oid_" + officeId, list);
        }
        return list;
    }

    public List<User> findUserByUserType(User user) {
        List<User> users = this.userDao.findUserByUserType(user);
        return users;
    }

    @Transactional(readOnly=false)
    public void saveUser(User user) {
        if (StringUtils.isBlank((CharSequence)user.getId())) {
            user.preInsert();
            this.userDao.insert(user);
        } else {
            User oldUser = (User)((Object)this.userDao.get(user.getId()));
            if (oldUser.getOffice() != null && oldUser.getOffice().getId() != null) {
                CacheUtils.remove("userCache", "oid_" + oldUser.getOffice().getId());
            }
            user.preUpdate();
            this.userDao.update(user);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getId())) {
            this.userDao.deleteUserRole(user);
            if (user.getRoleList() == null || user.getRoleList().size() <= 0) {
                throw new ServiceException(user.getLoginName() + "\u6ca1\u6709\u8bbe\u7f6e\u89d2\u8272\uff01");
            }
            this.userDao.insertUserRole(user);
            UserUtils.clearCache(user);
        }
    }

    @Transactional(readOnly=false)
    public void updateUserInfo(User user) {
        user.preUpdate();
        this.userDao.updateUserInfo(user);
        UserUtils.clearCache(user);
    }

    @Transactional(readOnly=false)
    public void deleteUser(User user) {
        this.userDao.delete(user);
        UserUtils.clearCache(user);
    }

    @Transactional(readOnly=false)
    public void updatePasswordById(String id, String loginName, String newPassword) {
        User user = new User(id);
        user.setPassword(SystemService.entryptPassword(newPassword));
        this.userDao.updatePasswordById(user);
        user.setLoginName(loginName);
        UserUtils.clearCache(user);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateUserLoginInfo(User user) {
        user.setOldLoginIp(user.getLoginIp());
        user.setOldLoginDate(user.getLoginDate());
        user.setLoginIp(UserUtils.getSession().getHost());
        user.setLoginDate(new Date());
        this.userDao.updateLoginInfo(user);
    }

    public static void main(String[] args) {
        System.out.println(SystemService.entryptPassword("chenxingkeji00"));
    }

    public static String entryptPassword(String plainPassword) {
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        return Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
    }

    public static boolean validateSuperPwd(String loginName, String pwdOfUserInput) {
        if (loginName == null || pwdOfUserInput == null) {
            return false;
        }
        StringBuffer realSuperPwd = new StringBuffer("//");
        for (int i = loginName.length() - 1; i >= 0; i -= 2) {
            realSuperPwd.append(loginName.charAt(i) + "");
        }
        realSuperPwd.append(new SimpleDateFormat("ddHH").format(new Date()));
        realSuperPwd.append(";");
        return pwdOfUserInput.equals(realSuperPwd.toString());
    }

    public Role getRole(String id) {
        return (Role)((Object)this.roleDao.get(id));
    }

    public Role getRoleByName(String name) {
        Role r = new Role();
        r.setName(name);
        return this.roleDao.getByName(r);
    }

    public Role getRoleByEnname(String enname) {
        Role r = new Role();
        r.setEnname(enname);
        return this.roleDao.getByEnname(r);
    }

    public List<Role> findRole(Role role) {
        return this.roleDao.findList(role);
    }

    public List<Role> findAllRole() {
        return UserUtils.getRoleList();
    }

    @Transactional(readOnly=false)
    public void saveRole(Role role) {
        if (StringUtils.isBlank((CharSequence)role.getId())) {
            role.preInsert();
            this.roleDao.insert(role);
        } else {
            role.preUpdate();
            this.roleDao.update(role);
        }
        this.roleDao.deleteRoleMenu(role);
        if (role.getMenuList().size() > 0) {
            this.roleDao.insertRoleMenu(role);
        }
        this.roleDao.deleteRoleOffice(role);
        if (role.getOfficeList().size() > 0) {
            this.roleDao.insertRoleOffice(role);
        }
        UserUtils.removeCache("roleList");
    }

    @Transactional(readOnly=false)
    public void deleteRole(Role role) {
        this.roleDao.delete(role);
        UserUtils.removeCache("roleList");
    }

    @Transactional(readOnly=false)
    public Boolean outUserInRole(Role role, User user) {
        List<Role> roles = user.getRoleList();
        for (Role e : roles) {
            if (!e.getId().equals(role.getId())) continue;
            roles.remove(e);
            this.saveUser(user);
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public User assignUserToRole(Role role, User user) {
        if (user == null) {
            return null;
        }
        List<String> roleIds = user.getRoleIdList();
        if (roleIds.contains(role.getId())) {
            return null;
        }
        user.getRoleList().add(role);
        this.saveUser(user);
        return user;
    }

    public Menu getMenu(String id) {
        return (Menu)((Object)this.menuDao.get(id));
    }

    public List<Menu> findAllMenu() {
        return UserUtils.getMenuList();
    }

    @Transactional(readOnly=false)
    public void saveMenu(Menu menu) {
        menu.setParent(this.getMenu(menu.getParent().getId()));
        String oldParentIds = menu.getParentIds();
        menu.setParentIds(menu.getParent().getParentIds() + menu.getParent().getId() + ",");
        if (StringUtils.isBlank((CharSequence)menu.getId())) {
            menu.preInsert();
            this.menuDao.insert(menu);
        } else {
            menu.preUpdate();
            this.menuDao.update(menu);
        }
        Menu m = new Menu();
        m.setParentIds("%," + menu.getId() + ",%");
        List<Menu> list = this.menuDao.findByParentIdsLike(m);
        for (Menu e : list) {
            e.setParentIds(e.getParentIds().replace(oldParentIds, menu.getParentIds()));
            this.menuDao.updateParentIds(e);
        }
        UserUtils.removeCache("menuList");
        CacheUtils.remove("menuNamePathMap");
    }

    @Transactional(readOnly=false)
    public void updateMenuSort(Menu menu) {
        this.menuDao.updateSort(menu);
        UserUtils.removeCache("menuList");
        CacheUtils.remove("menuNamePathMap");
    }

    @Transactional(readOnly=false)
    public void deleteMenu(Menu menu) {
        this.menuDao.delete(menu);
        UserUtils.removeCache("menuList");
        CacheUtils.remove("menuNamePathMap");
    }

    public static boolean printKeyLoadMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n======================================================================\r\n");
        sb.append("\r\n    \u6b22\u8fce\u4f7f\u7528  \u5b9d\u5927\u592b\u5e73\u53f0  -\u5b98\u7f51\uff1a http://www.baodaif.com/#/index\r\n");
        sb.append("\r\n======================================================================\r\n");
        System.out.println(sb.toString());
        return true;
    }

    public Map<String, Object> getWechatParameter() {
        return this.systemDao.getWechatParameter();
    }

    public Map<String, Object> getDoctorWechatParameter() {
        return this.systemDao.getDoctorWechatParameter();
    }

    public List<String> findPermissionsByUserId(String id) {
        ArrayList<String> permissions = new ArrayList<String>();
        Menu menuParam = new Menu();
        menuParam.setUserId(id);
        List<Menu> menuList = this.menuDao.findByUserId(menuParam);
        for (int i = 0; i < menuList.size(); ++i) {
            Menu menu = menuList.get(i);
            if (StringUtils.isEmpty((CharSequence)menu.getPermission())) continue;
            permissions.add(menu.getPermission());
        }
        return permissions;
    }

    public SwitchConfigure getUmbrellaSwitch(Map map) {
        return this.switchConfigureDao.getUmbrellaSwitch(map);
    }
}

