package com.cxqm.xiaoerke.common.utils;

/*

SELECT
     CONCAT(
          'add(prod, "',
          a.TABLE_NAME,
          '*',
          a.COLUMN_NAME,
          '*',
          a.COLUMN_TYPE,
          '*',
          a.IS_NULLABLE,
          '*',
          a.COLUMN_KEY,
          '*',
          a.ORDINAL_POSITION,
          '*',
          IFNULL(REPLACE(a.COLUMN_DEFAULT, '\\', '\\\\'), '[NULL]'),
          '*',
          a.EXTRA,
          '");'
     )
FROM
     information_schema.`COLUMNS` a
WHERE
     TABLE_SCHEMA = 'hyzsdb'
ORDER BY
     TABLE_NAME ASC,
     COLUMN_NAME ASC;

 */
import java.util.*;

/**
 * Created by sunzsh on 2017/3/31.
 *
 */
public class DBCompareUtil {

	public static List<DBTable> test = new ArrayList<DBTable>();
	public static List<DBTable> prod = new ArrayList<DBTable>();

	public static Set<String> newTables = new LinkedHashSet<String>();
	public static Set<String> newColumns = new LinkedHashSet<String>();
	public static Set<String> deleteTables = new LinkedHashSet<String>();
	public static Set<String> deleteColumns = new LinkedHashSet<String>();
	public static Set<String> changeColumns = new LinkedHashSet<String>();


	public static void main(String[] args) {
		fillTest();
		fillProd();
		compare(test, prod);
	}

	// add(test, "account_info*id*varchar(64)*NO*PRI*1*[NULL]*");
	public static void fillTest() {
		
	}

	// add(prod, "account_binding*id*varchar(64)*NO*PRI*1*[NULL]*");
	public static void fillProd() {

	}

	public static void compare(List<DBTable> _test, List<DBTable> _prod) {
		findChangeOfTable(test, prod, newTables, deleteTables);
		findNewOrDeleteColumn(test, prod, newColumns, deleteColumns);
		findChangeColumn(test, prod, changeColumns);

		System.out.println("新增的表：");
		for (String newTable : newTables) {
			System.out.println(newTable);
		}
		System.out.println("-----------------------------------------------");

		System.out.println("删除的表：");
		for (String deleteTable : deleteTables) {
			System.out.println(deleteTable);
		}
		System.out.println("-----------------------------------------------");

		System.out.println("新增的字段：");
		for (String newColumn : newColumns) {
			System.out.println(newColumn);
		}
		System.out.println("-----------------------------------------------");

		System.out.println("删除的字段：");
		for (String deleteColumn : deleteColumns) {
			System.out.println(deleteColumn);
		}
		System.out.println("-----------------------------------------------");

		System.out.println("变化的字段：");
		for (String changeColumn : changeColumns) {
			System.out.println(changeColumn);
		}
		System.out.println("-----------------------------------------------");
	}

	public static void findChangeColumn(List<DBTable> _test, List<DBTable> _prod, Set<String> _changeColumns) {
		// 遍历测试数据库的字段
		for (DBTable tableInTest : _test) {
			DBTable tableInProd = findDBTableInList(_prod, tableInTest.name);
			for (int i = 0; i < tableInTest.columns.size(); i++) {
				DBColumn columnInTest = tableInTest.columns.get(i);
				DBColumn columnInProd = findDBColumnInList(tableInProd.columns, columnInTest.name);
				if (!columnInProd.equals(columnInTest)) {
					changeColumns.add(tableInProd.name + "." + columnInProd.name);
				}
			}
		}
	}

	public static void findNewOrDeleteColumn(List<DBTable> _test, List<DBTable> _prod, Set<String> _newColumns, Set<String> _deleteColumns) {
		// 遍历测试数据库的字段
		for (DBTable tableInTest : _test) {
			DBTable tableInProd = findDBTableInList(_prod, tableInTest.name);
			for (int i = 0; i < tableInTest.columns.size(); i++) {
				DBColumn columnInTest = tableInTest.columns.get(i);
				DBColumn columnInProd = findDBColumnInList(tableInProd.columns, columnInTest.name);
				if (columnInProd == null) {
					// 在正是环境中，没有找到该字段
					_newColumns.add(tableInTest.name + "." + columnInTest.name);
					tableInTest.columns.remove(i--);
				}
			}
		}

		// 遍历正式数据库的字段
		for (DBTable tableInProd : _prod) {
			DBTable tableInTest = findDBTableInList(_test, tableInProd.name);
			for (int i = 0; i < tableInProd.columns.size(); i++) {
				DBColumn columnInProd = tableInProd.columns.get(i);
				DBColumn columnInTest = findDBColumnInList(tableInTest.columns, columnInProd.name);
				if (columnInTest == null) {
					// 在测试环境中，没有找到该字段
					_deleteColumns.add(tableInProd.name + "." + columnInProd.name);
					tableInProd.columns.remove(i--);
				}
			}
		}
	}

	public static void findChangeOfTable(List<DBTable> _test, List<DBTable> _prod, Set<String> _newTables, Set<String> _deleteTables) {
		// 遍历测试数据库表
		for (int i = 0; i < _test.size(); i++) {
			DBTable tableOfTest = _test.get(i);
			DBTable dbTableInList = findDBTableInList(_prod, tableOfTest.name);
			if (dbTableInList == null) {
				// 在线上数据库中没找到这张表
				_newTables.add(tableOfTest.name);
				_test.remove(i--);
			}
		}
		// 遍历线上数据库表
		for (int i = 0; i < _prod.size(); i++) {
			DBTable tableOfProd = _prod.get(i);
			DBTable dbTableInList = findDBTableInList(_test, tableOfProd.name);
			if (dbTableInList == null) {
				// 在测试数据库中没找到这张表
				_deleteTables.add(tableOfProd.name);
				_prod.remove(i--);
			}
		}
	}

	public static void add(List<DBTable> db, String item) {
		String[] split = item.split("\\*");
		String tableName = split[0];
		String columnName = split[1];
		String type = split[2];
		String nullable = split[3];
		String key = split[4];
		String order = split[5];
		String defaultValue = split.length < 7 ? null : (split[6].equals("[NULL]")?null:split[6]);
		String extra = split.length < 8 ? null : split[7];

		DBTable table = findDBTableInList(db, tableName);
		if (table == null) {
			table = new DBTable(tableName);
			db.add(table);
		}
		table.addColumn(columnName, type, nullable, key, order, defaultValue, extra);
	}

	public static DBTable findDBTableInList(List<DBTable> tables, String tableName) {
		for (DBTable table : tables) {
			if (table.name.equals(tableName)) {
				return table;
			}
		}
		return null;
	}
	public static DBColumn findDBColumnInList(List<DBColumn> columns, String columnName) {
		for (DBColumn column : columns) {
			if (column.name.equals(columnName)) {
				return column;
			}
		}
		return null;
	}

	public static class DBTable{
		private String name;
		private List<DBColumn> columns;

		public DBTable() {
			columns = new ArrayList<DBColumn>();
		}

		public DBTable(String name) {
			this();
			this.name = name;
		}

		public void addColumn(String columnName, String type, String nullable, String key, String order, String defaultValue, String extra) {
			columns.add(new DBColumn(columnName, type, nullable, key, order, defaultValue, extra));
		}

	}

	public static class DBColumn {
		private String name;
		private String type;
		private Boolean nullable;
		private String key;
		private String order;
		private String defaultValue;
		private String extra;

		public DBColumn() {
		}

		public DBColumn(String name, String type, String nullable, String key, String order, String defaultValue, String extra) {
			this(name, type, "YES".equals(nullable), key, order, defaultValue, extra);
		}

		public DBColumn(String name, String type, Boolean nullable, String key, String order, String defaultValue, String extra) {
			this.name = name;
			this.type = type;
			this.nullable = nullable;
			this.key = key;
			this.order = order;
			this.defaultValue = defaultValue;
			this.extra = extra;
		}


		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || getClass() != o.getClass()) return false;

			DBColumn dbColumn = (DBColumn) o;

			if (name != null ? !name.equals(dbColumn.name) : dbColumn.name != null) return false;
			if (type != null ? !type.equals(dbColumn.type) : dbColumn.type != null) return false;
			if (nullable != null ? !nullable.equals(dbColumn.nullable) : dbColumn.nullable != null) return false;
			if (key != null ? !key.equals(dbColumn.key) : dbColumn.key != null) return false;
			if (order != null ? !order.equals(dbColumn.order) : dbColumn.order != null) return false;
			if (defaultValue != null ? !defaultValue.equals(dbColumn.defaultValue) : dbColumn.defaultValue != null)
				return false;
			return !(extra != null ? !extra.equals(dbColumn.extra) : dbColumn.extra != null);

		}

		@Override
		public int hashCode() {
			int result = name != null ? name.hashCode() : 0;
			result = 31 * result + (type != null ? type.hashCode() : 0);
			result = 31 * result + (nullable != null ? nullable.hashCode() : 0);
			result = 31 * result + (key != null ? key.hashCode() : 0);
			result = 31 * result + (order != null ? order.hashCode() : 0);
			result = 31 * result + (defaultValue != null ? defaultValue.hashCode() : 0);
			result = 31 * result + (extra != null ? extra.hashCode() : 0);
			return result;
		}
	}
}

