/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.utils;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.Exceptions;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.sys.dao.LogDao;
import com.cxqm.xiaoerke.modules.sys.dao.MenuDao;
import com.cxqm.xiaoerke.modules.sys.entity.Log;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.MongoLog;
import com.cxqm.xiaoerke.modules.sys.service.LogMongoDBServiceImpl;
import com.cxqm.xiaoerke.modules.sys.service.MongoDBService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.method.HandlerMethod;

public class LogUtils {
    public static final String CACHE_MENU_NAME_PATH_MAP = "menuNamePathMap";
    private static MongoDBService<MongoLog> mongoDBService = SpringContextHolder.getBean(LogMongoDBServiceImpl.class);
    private static LogDao logDao = SpringContextHolder.getBean(LogDao.class);
    private static MenuDao menuDao = SpringContextHolder.getBean(MenuDao.class);
    private static String mongoEnabled = Global.getConfig("mongo.enabled");
    private static ExecutorService threadExecutor = Executors.newCachedThreadPool();

    public static void saveLog(HttpServletRequest request, String title) {
        LogUtils.saveLog(request, null, null, title);
    }

    public static void saveLog(HttpServletRequest request, Object handler, Exception ex, String title) {
        Log log = new Log();
        log.setTitle(title);
        log.setType(ex == null ? "1" : "2");
        log.setRemoteAddr(StringUtils.getRemoteAddr(request));
        log.setUserAgent(request.getHeader("user-agent"));
        log.setRequestUri(request.getRequestURI());
        log.setParams(request.getParameterMap());
        log.setMethod(request.getMethod());
        log.setCreateDate(new Date());
        log.setOpenId((String)request.getSession().getAttribute("openId"));
        SaveLogThread thread = new SaveLogThread(log, handler, ex);
        threadExecutor.execute(thread);
    }

    public static void saveLog(String title) {
        Log log = new Log();
        log.setType("2");
        log.setTitle(title);
        SaveLogThread thread = new SaveLogThread(log, null, null);
        threadExecutor.execute(thread);
    }

    public static void saveLogVo(Log log) {
        log.setType("1");
        SaveLogThread thread = new SaveLogThread(log, null, null);
        threadExecutor.execute(thread);
    }

    public static void saveLog(HttpServletRequest request, String title, String parameters) {
        Log log = new Log();
        log.setType("2");
        log.setTitle(title);
        log.setParameters(parameters);
        log.setRemoteAddr(StringUtils.getRemoteAddr(request));
        log.setUserAgent(request.getHeader("user-agent"));
        log.setRequestUri(request.getRequestURI());
        log.setParams(request.getParameterMap());
        log.setMethod(request.getMethod());
        log.setOpenId((String)request.getSession().getAttribute("openId"));
        SaveLogThread thread = new SaveLogThread(log, null, null);
        threadExecutor.execute(thread);
    }

    public static void saveLog(String title, String parameters) {
        Log log = new Log();
        log.setType("2");
        log.setTitle(title);
        log.setParameters(parameters);
        log.setOpenId(parameters);
        SaveLogThread thread = new SaveLogThread(log, null, null);
        threadExecutor.execute(thread);
    }

    public static String getMenuNamePath(String requestUri, String permission) {
        String menuNamePath;
        String href = StringUtils.substringAfter((String)requestUri, (String)Global.getAdminPath());
        Map menuMap = (Map)CacheUtils.get(CACHE_MENU_NAME_PATH_MAP);
        if (menuMap == null) {
            menuMap = Maps.newHashMap();
            List<Menu> menuList = menuDao.findAllList(new Menu());
            for (Menu menu : menuList) {
                String namePath = "";
                if (menu.getParentIds() != null) {
                    String[] namePathList = Lists.newArrayList();
                    String[] stringArray = StringUtils.split((String)menu.getParentIds(), (String)",");
                    int n = stringArray.length;
                    block1: for (int i = 0; i < n; ++i) {
                        String id = stringArray[i];
                        if (Menu.getRootId().equals(id)) continue;
                        for (Menu m : menuList) {
                            if (!m.getId().equals(id)) continue;
                            namePathList.add(m.getName());
                            continue block1;
                        }
                    }
                    namePathList.add(menu.getName());
                    namePath = StringUtils.join((Iterable)namePathList, (String)"-");
                }
                if (StringUtils.isNotBlank((CharSequence)menu.getHref())) {
                    menuMap.put(menu.getHref(), namePath);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)menu.getPermission())) continue;
                for (String p : StringUtils.split((String)menu.getPermission())) {
                    menuMap.put(p, namePath);
                }
            }
            CacheUtils.put(CACHE_MENU_NAME_PATH_MAP, menuMap);
        }
        if ((menuNamePath = (String)menuMap.get(href)) == null) {
            Object p;
            String[] stringArray = StringUtils.split((String)permission);
            int n = stringArray.length;
            for (int i = 0; i < n && !StringUtils.isNotBlank((CharSequence)(menuNamePath = (String)menuMap.get(p = stringArray[i]))); ++i) {
            }
            if (menuNamePath == null) {
                return "";
            }
        }
        return menuNamePath;
    }

    public static class SaveLogThread
    extends Thread {
        private Log log;
        private Object handler;
        private Exception ex;

        public SaveLogThread(Log log, Object handler, Exception ex) {
            super(SaveLogThread.class.getSimpleName());
            this.log = log;
            this.handler = handler;
            this.ex = ex;
        }

        @Override
        public void run() {
            if (StringUtils.isBlank((CharSequence)this.log.getTitle())) {
                String permission = "";
                if (this.handler instanceof HandlerMethod) {
                    Method m = ((HandlerMethod)this.handler).getMethod();
                    RequiresPermissions rp = m.getAnnotation(RequiresPermissions.class);
                    permission = rp != null ? StringUtils.join((Object[])rp.value(), (String)",") : "";
                }
                this.log.setTitle(LogUtils.getMenuNamePath(this.log.getRequestUri(), permission));
            }
            this.log.setException(Exceptions.getStackTraceAsString(this.ex));
            if (StringUtils.isBlank((CharSequence)this.log.getTitle()) && StringUtils.isBlank((CharSequence)this.log.getException())) {
                return;
            }
            this.log.preInsert();
            if ("true".equalsIgnoreCase(mongoEnabled)) {
                MongoLog mongoLog = LogMongoDBServiceImpl.buildMongoLog(this.log);
                mongoDBService.insert(mongoLog);
            }
        }
    }
}

