package com.cxqm.xiaoerke.common.web;

import com.cxqm.xiaoerke.common.bean.BaseErrors;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.filter.LoadProjectPath;
import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.utils.NeedNotLogin;
import com.cxqm.xiaoerke.common.utils.ShortUrlWithoutLogin;
import com.cxqm.xiaoerke.common.utils.WeixinUtil;
import com.cxqm.xiaoerke.modules.sys.service.SysPropertyServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Enumeration;

/**
 * Created by sunzb on 16/12/19.
 */
public class LoginValidateInterceptor extends HandlerInterceptorAdapter {
	private String redirectUrl;
	private String loginUrl;
	private ILoginValidater loginValidater;

	private String baseUrl;
	public String getBaseUrl() {
		return baseUrl;
	}
	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

	public String getRedirectUrl() {
		return redirectUrl;
	}
	public void setRedirectUrl(String redirectUrl) {
		this.redirectUrl = redirectUrl;
	}
	public ILoginValidater getLoginValidater() {
		return loginValidater;
	}
	public void setLoginValidater(ILoginValidater loginValidater) {
		this.loginValidater = loginValidater;
	}
	public String getLoginUrl() {
		return loginUrl;
	}
	public void setLoginUrl(String loginUrl) {
		this.loginUrl = loginUrl;
	}

	// 控制器是否需要登录才能访问
	private boolean controllerNeedLogin(Object handler) {
		HandlerMethod handlerMethod = handler instanceof HandlerMethod ? ((HandlerMethod) handler) : null;
		if (handlerMethod == null) {
			return true;
		}
		Method mTmp = ((HandlerMethod) handler).getMethod();
		Method method;
		try {
			method = ((HandlerMethod) handler).getBeanType().getMethod(mTmp.getName(), mTmp.getParameterTypes());
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
			return false;
		}
		NeedNotLogin annotation = method.getAnnotation(NeedNotLogin.class);
		if (annotation != null) {
			return false;
		}
		return true;
	}

	// 控制器是否为ajax请求
	private boolean controllerAjax(Object handler) {
		HandlerMethod handlerMethod = handler instanceof HandlerMethod ? ((HandlerMethod) handler) : null;
		if (handlerMethod == null) {
			return true;
		}
		Method mTmp = ((HandlerMethod) handler).getMethod();
		Method method = null;
		try {
			method = ((HandlerMethod) handler).getBeanType().getMethod(mTmp.getName(), mTmp.getParameterTypes());
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
			return false;
		}
		ResponseBody annotation = method.getAnnotation(ResponseBody.class);
		if (annotation != null) {
			return false;
		}
		return true;
	}

	private ShortUrlWithoutLogin controllerShortUrl(Object handler) {
		HandlerMethod handlerMethod = handler instanceof HandlerMethod ? ((HandlerMethod) handler) : null;
		if (handlerMethod == null) {
			return null;
		}
		Method mTmp = ((HandlerMethod) handler).getMethod();
		Method method = null;
		try {
			method = ((HandlerMethod) handler).getBeanType().getMethod(mTmp.getName(), mTmp.getParameterTypes());
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
			return null;
		}
		ShortUrlWithoutLogin annotation = method.getAnnotation(ShortUrlWithoutLogin.class);
		if (annotation != null) {
			return annotation;
		}
		return null;
	}

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		// 控制器是否需要登录才能访问
		boolean controllerNeedLogin = controllerNeedLogin(handler);
		if (!controllerNeedLogin) {
			return true;
		}
		// 是否支持短地址生成
		ShortUrlWithoutLogin shortUrl = controllerShortUrl(handler);
		if (shortUrl != null) {
			// 新浪短地址
			String xRemoteApiInvoker = request.getHeader("x-remote-api-invoker");
			String userAgent = request.getHeader("user-agent");
			if (xRemoteApiInvoker != null && xRemoteApiInvoker.equals("openapi") || userAgent == null) {
				response.setContentType("text/html; charset=utf-8");
				PrintWriter out = response.getWriter();
				out.println("<!DOCTYPE html>");
				out.println(String.format("<html><head><title>%s</title></head><body></body></html>", shortUrl.title()));
				response.flushBuffer();
				return false;
			}
		}

		//判断用户是否登录
		if (loginValidater.getCurrentUser() != null) {
			return true;
		}

		// 控制器是否为ajax请求
		boolean controllerAjax = controllerAjax(handler);
		if (!controllerAjax) {
			throw new BusinessException(BaseErrors.USER_NOTE_LOGIN);
		}

		String from = request.getRequestURI() + (request.getQueryString()==null?"":("?"+request.getQueryString()));
		String contextPath = request.getContextPath();
		if (contextPath != null && contextPath.trim().length() > 0) {
			from = from.replaceAll("^" + contextPath, "");
		}
		if (getBaseUrl() != null) {
			from = LoadProjectPath.getUrlByScheme(request, getBaseUrl()) + from;
		}
		return backLogin(request,response,from);
	}

	public boolean backLogin(HttpServletRequest request,HttpServletResponse response,String from) throws Exception{
		//判断是否为微信浏览器，如果参数中包含ignore_wechat=1，则强制认为不是微信（用于测试环境时，无法使用微信授权登录，手动在请求中加一个ignore_wechat
		if (WeixinUtil.isWeiXin(request, "ignore_wechat")) {
			//微信浏览器
			//获取微信用户授权code 回调到getOpenId action
			String redirectUrl = LoadProjectPath.getUrlByScheme(request, this.getRedirectUrl()) + "?from=" + from+"&status="+WeixinUtil.NOT_JUMP_STATUS;
			String redirectUrlEncode = URLEncoder.encode(redirectUrl, "utf-8");
			String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + loginValidater.getAppId() + "&redirect_uri=" + redirectUrlEncode + "&response_type=code&scope=snsapi_userinfo#wechat_redirect";
			response.sendRedirect(url);
			return false;
		} else {
			String url = loginUrl == null ? "/" : LoadProjectPath.getUrlByScheme(request, loginUrl);
			String ignore_wechat = request.getParameter("ignore_wechat");
			response.sendRedirect(url + (url.indexOf('?') > 0 ? "&" : "?") + "from=" + URLEncoder.encode(from, "utf-8") + (ignore_wechat!=null&&ignore_wechat.equals("1")?"&ignore_wechat=1":""));
			return false;
		}
	}

}
