/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.supcan;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.supcan.annotation.treelist.SupTreeList;
import com.cxqm.xiaoerke.common.supcan.annotation.treelist.cols.SupCol;
import com.cxqm.xiaoerke.common.supcan.annotation.treelist.cols.SupGroup;
import com.cxqm.xiaoerke.common.supcan.treelist.TreeList;
import com.cxqm.xiaoerke.common.supcan.treelist.cols.Col;
import com.cxqm.xiaoerke.common.supcan.treelist.cols.Group;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.common.web.BaseController;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/supcan"})
public class SupcanController
extends BaseController {
    private static final String SUPCAN_CACHE = "supcanCache";

    @RequestMapping(value={"treeList/{typeAlias}.xml"})
    @ResponseBody
    public TreeList treeList(@PathVariable(value="typeAlias") String typeAlias) {
        Class clazz;
        Object object;
        boolean useCache;
        boolean bl = useCache = Global.getConfig("supcan.useCache") == "true";
        if (useCache && (object = CacheUtils.get(SUPCAN_CACHE, typeAlias)) != null) {
            return (TreeList)object;
        }
        try {
            SqlSessionFactory sqlSessionFactory = SpringContextHolder.getBean(SqlSessionFactory.class);
            clazz = sqlSessionFactory.getConfiguration().getTypeAliasRegistry().resolveAlias(typeAlias);
        }
        catch (Exception e) {
            return null;
        }
        SupTreeList supTreeList = clazz.getAnnotation(SupTreeList.class);
        if (supTreeList == null) {
            return null;
        }
        TreeList treeList = new TreeList(supTreeList);
        HashMap groupMap = Maps.newHashMap();
        if (supTreeList != null && supTreeList.groups() != null) {
            for (SupGroup supGroup : supTreeList.groups()) {
                groupMap.put(supGroup.id(), new Group(supGroup));
            }
        }
        List<Object> cols = treeList.getCols();
        for (Method m : clazz.getMethods()) {
            SupCol supCol = m.getAnnotation(SupCol.class);
            if (supCol == null) continue;
            Col col = new Col(supCol);
            if (StringUtils.isBlank((CharSequence)col.getName())) {
                col.setName(StringUtils.uncapitalize((String)StringUtils.substring((String)m.getName(), (int)3)));
            }
            if (StringUtils.isBlank((CharSequence)supCol.groupId())) {
                cols.add(col);
                continue;
            }
            Group group = (Group)groupMap.get(supCol.groupId());
            if (group == null) continue;
            group.getCols().add(col);
        }
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int sort1 = 0;
                int sort2 = 0;
                if (o1 instanceof Group) {
                    sort1 = ((Group)o1).getSort();
                } else if (o1 instanceof Col) {
                    sort1 = ((Col)o1).getSort();
                }
                if (o2 instanceof Group) {
                    sort2 = ((Group)o2).getSort();
                } else if (o2 instanceof Col) {
                    sort2 = ((Col)o2).getSort();
                }
                return new Integer(sort1).compareTo(new Integer(sort2));
            }
        };
        this.listToTree(cols, groupMap, null, comparator);
        Collections.sort(cols, comparator);
        if (useCache) {
            CacheUtils.put(SUPCAN_CACHE, typeAlias, treeList);
        }
        return treeList;
    }

    private void listToTree(List<Object> colList, Map<String, Group> groupMap, String parentId, Comparator<Object> comparator) {
        for (Map.Entry<String, Group> e : groupMap.entrySet()) {
            Group g = e.getValue();
            if (!StringUtils.equals((CharSequence)parentId, (CharSequence)g.getParentId())) continue;
            colList.add(g);
            for (Map.Entry<String, Group> ec : groupMap.entrySet()) {
                Group gc = ec.getValue();
                if (g.getId() == null || !g.getId().equals(gc.getParentId())) continue;
                ArrayList childrenList = Lists.newArrayList();
                this.listToTree(childrenList, groupMap, gc.getParentId(), comparator);
                g.getCols().addAll(childrenList);
                break;
            }
            Collections.sort(g.getCols(), comparator);
        }
    }

    @RequestMapping(value={"treeList/test/test.xml"})
    @ResponseBody
    public TreeList treeListTest() {
        TreeList treeList = new TreeList();
        List<Object> cols = treeList.getCols();
        cols.add(new Col("id", "\u7f16\u53f7"));
        cols.add(new Col("office", "\u5f52\u5c5e\u90e8\u95e8"));
        cols.add(new Col("loginName", "\u767b\u5f55\u540d"));
        cols.add(new Col("name", "\u540d\u79f0"));
        cols.add(new Col("remarks", "\u5907\u6ce8"));
        Group group = new Group("\u65f6\u95f4");
        List<Object> groupCol = group.getCols();
        groupCol.add(new Col("createDate", "\u521b\u5efa\u65f6\u95f4"));
        groupCol.add(new Col("updateDate", "\u66f4\u65b0\u65f6\u95f4"));
        Group group2 = new Group("\u65f6\u95f42");
        List<Object> group2Col = group2.getCols();
        group2Col.add(new Col("createDate2", "\u521b\u5efa\u65f6\u95f42"));
        group2Col.add(new Col("updateDate2", "\u66f4\u65b0\u65f6\u95f42"));
        groupCol.add(group2);
        cols.add(group);
        return treeList;
    }
}

