/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.utils.StringUtils;

public class EmojiFilter {
    public static boolean containsEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!EmojiFilter.isEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        if (!EmojiFilter.containsEmoji(source)) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!EmojiFilter.isEmojiCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(source.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return source;
        }
        if (buf.length() == len) {
            buf = null;
            return source;
        }
        return buf.toString();
    }

    public static String coverEmoji(String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            return source.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "*");
        }
        return source;
    }
}

