/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.ckfinder.connector.configuration.Events;
import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.AfterFileUploadEventArgs;
import com.ckfinder.connector.data.EventArgs;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.errors.ErrorUtils;
import com.ckfinder.connector.handlers.command.Command;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import com.ckfinder.connector.utils.ImageUtils;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.modules.sys.security.SystemAuthorizingRealm;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CKFAliyunFileUploadCommand
extends Command
implements IPostCommand {
    protected String fileName = "";
    protected String newFileName = "";
    protected String ckEditorFuncNum;
    protected String responseType;
    protected String ckFinderFuncNum;
    private String langCode;
    protected boolean uploaded;
    protected int errorCode = 0;
    private static final char[] UNSAFE_FILE_NAME_CHARS = new char[]{':', '*', '?', '|', '/'};

    public CKFAliyunFileUploadCommand() {
        this.type = "";
        this.uploaded = false;
    }

    public void execute(OutputStream out) throws ConnectorException {
        if (this.configuration.isDebugMode() && this.exception != null) {
            throw new ConnectorException(this.errorCode, this.exception);
        }
        try {
            String e = this.errorCode == 0 ? "" : ErrorUtils.getInstance().getErrorMsgByLangAndCode(this.langCode, this.errorCode, this.configuration);
            e = e.replaceAll("%1", this.newFileName);
            String path = "";
            if (!this.uploaded) {
                this.newFileName = "";
                this.currentFolder = "";
            } else {
                path = ((ResourceType)this.configuration.getTypes().get(this.type)).getUrl() + this.currentFolder;
            }
            if (this.responseType != null && this.responseType.equals("txt")) {
                out.write((this.newFileName + "|" + e).getBytes("UTF-8"));
            } else {
                out.write("<script type=\"text/javascript\">".getBytes("UTF-8"));
                if (this.checkFuncNum()) {
                    this.handleOnUploadCompleteCallFuncResponse(out, e, path);
                } else {
                    this.handleOnUploadCompleteResponse(out, e);
                }
                out.write("</script>".getBytes("UTF-8"));
            }
        }
        catch (IOException var4) {
            throw new ConnectorException(104, (Exception)var4);
        }
    }

    protected boolean checkFuncNum() {
        return this.ckFinderFuncNum != null;
    }

    protected void handleOnUploadCompleteCallFuncResponse(OutputStream out, String errorMsg, String path) throws IOException {
        this.ckFinderFuncNum = this.ckFinderFuncNum.replaceAll("[^\\d]", "");
        out.write(("window.parent.CKFinder.tools.callFunction(" + this.ckFinderFuncNum + ", '" + path + FileUtils.backupWithBackSlash((String)this.newFileName, (String)"'") + "', '" + errorMsg + "');").getBytes("UTF-8"));
    }

    protected void handleOnUploadCompleteResponse(OutputStream out, String errorMsg) throws IOException {
        out.write("window.parent.OnUploadCompleted(".getBytes("UTF-8"));
        out.write(("'" + FileUtils.backupWithBackSlash((String)this.newFileName, (String)"'") + "'").getBytes("UTF-8"));
        out.write((", '" + (this.errorCode != 0 ? errorMsg : "") + "'").getBytes("UTF-8"));
        out.write(");".getBytes("UTF-8"));
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, params);
        this.ckFinderFuncNum = request.getParameter("CKFinderFuncNum");
        this.ckEditorFuncNum = request.getParameter("CKEditorFuncNum");
        this.responseType = request.getParameter("response_type");
        this.langCode = request.getParameter("langCode");
        if (this.errorCode == 0) {
            this.uploaded = this.uploadFile(request);
        }
    }

    private boolean uploadFile(HttpServletRequest request) {
        if (!AccessControlUtil.getInstance((IConfiguration)this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 32)) {
            this.errorCode = 103;
            return false;
        }
        return this.fileUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileUpload(HttpServletRequest request) {
        try {
            DiskFileItemFactory e = new DiskFileItemFactory();
            ServletFileUpload uploadHandler = new ServletFileUpload((FileItemFactory)e);
            List items = uploadHandler.parseRequest(request);
            Iterator i$ = items.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return false;
                }
                FileItem item = (FileItem)i$.next();
                if (item.isFormField()) continue;
                String path = ((ResourceType)this.configuration.getTypes().get(this.type)).getPath() + this.currentFolder;
                this.fileName = this.getFileItemName(item);
                try {
                    if (!this.validateUploadItem(item, path)) continue;
                    SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
                    Map types = this.configuration.getTypes();
                    String typeName = ((ResourceType)types.get(this.type)).getName();
                    OSSObjectTool.uploadFile(OSSObjectTool.BUCKET_BACKEND_PIC, principal.getId() + "/" + typeName + this.currentFolder + this.fileName, item.getInputStream());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    item.delete();
                    continue;
                }
                break;
            }
        }
        catch (FileUploadBase.InvalidContentTypeException var18) {
            if (this.configuration.isDebugMode()) {
                this.exception = var18;
            }
            this.errorCode = 204;
            return false;
        }
        catch (FileUploadBase.IOFileUploadException var19) {
            if (this.configuration.isDebugMode()) {
                this.exception = var19;
            }
            this.errorCode = 104;
            return false;
        }
        catch (FileUploadBase.SizeLimitExceededException var20) {
            this.errorCode = 203;
            return false;
        }
        catch (FileUploadBase.FileSizeLimitExceededException var21) {
            this.errorCode = 203;
            return false;
        }
        catch (Exception var23) {
            if (this.configuration.isDebugMode()) {
                this.exception = var23;
            }
            this.errorCode = 104;
            return false;
        }
    }

    private boolean saveTemporaryFile(String path, FileItem item) throws Exception {
        File file = new File(path, this.newFileName);
        AfterFileUploadEventArgs args = new AfterFileUploadEventArgs();
        args.setCurrentFolder(this.currentFolder);
        args.setFile(file);
        args.setFileContent(item.get());
        if (!ImageUtils.isImage((File)file)) {
            item.write(file);
            if (this.configuration.getEvents() != null) {
                this.configuration.getEvents().run(Events.EventTypes.AfterFileUpload, (EventArgs)args, this.configuration);
            }
            return true;
        }
        if (ImageUtils.checkImageSize((InputStream)item.getInputStream(), (IConfiguration)this.configuration)) {
            ImageUtils.createTmpThumb((InputStream)item.getInputStream(), (File)file, (String)this.getFileItemName(item), (IConfiguration)this.configuration);
            if (this.configuration.getEvents() != null) {
                this.configuration.getEvents().run(Events.EventTypes.AfterFileUpload, (EventArgs)args, this.configuration);
            }
            return true;
        }
        if (this.configuration.checkSizeAfterScaling()) {
            ImageUtils.createTmpThumb((InputStream)item.getInputStream(), (File)file, (String)this.getFileItemName(item), (IConfiguration)this.configuration);
            if (FileUtils.checkFileSize((ResourceType)((ResourceType)this.configuration.getTypes().get(this.type)), (long)file.length())) {
                if (this.configuration.getEvents() != null) {
                    this.configuration.getEvents().run(Events.EventTypes.AfterFileUpload, (EventArgs)args, this.configuration);
                }
                return true;
            }
            file.delete();
            this.errorCode = 203;
            return false;
        }
        return false;
    }

    private String getFinalFileName(String path, String name) {
        File file = new File(path, name);
        int number = 0;
        while (file.exists()) {
            StringBuilder sb = new StringBuilder();
            sb.append(FileUtils.getFileNameWithoutExtension((String)name));
            sb.append("(" + ++number + ").");
            sb.append(FileUtils.getFileExtension((String)name));
            this.newFileName = sb.toString();
            file = new File(path, this.newFileName);
            this.errorCode = 201;
        }
        return this.newFileName;
    }

    private boolean validateUploadItem(FileItem item, String path) {
        if (item.getName() != null && item.getName().length() > 0) {
            this.newFileName = this.fileName = this.getFileItemName(item);
            for (char c : UNSAFE_FILE_NAME_CHARS) {
                this.newFileName = this.newFileName.replace(c, '_');
            }
            if (this.configuration.isDisallowUnsafeCharacters()) {
                this.newFileName = this.newFileName.replace(';', '_');
            }
            if (this.configuration.forceASCII()) {
                this.newFileName = FileUtils.convertToASCII((String)this.newFileName);
            }
            if (!this.newFileName.equals(this.fileName)) {
                this.errorCode = 207;
            }
            if (FileUtils.checkIfDirIsHidden((String)this.currentFolder, (IConfiguration)this.configuration)) {
                this.errorCode = 109;
                return false;
            }
            if (FileUtils.checkFileName((String)this.newFileName) && !FileUtils.checkIfFileIsHidden((String)this.newFileName, (IConfiguration)this.configuration)) {
                int var9 = FileUtils.checkFileExtension((String)this.newFileName, (ResourceType)((ResourceType)this.configuration.getTypes().get(this.type)), (IConfiguration)this.configuration, (boolean)true);
                if (var9 == 1) {
                    this.errorCode = 105;
                    return false;
                }
                if (var9 == 2) {
                    this.newFileName = FileUtils.renameFileWithBadExt((String)this.newFileName);
                }
                try {
                    File var10 = new File(path, this.getFinalFileName(path, this.newFileName));
                    if (FileUtils.checkFileSize((ResourceType)((ResourceType)this.configuration.getTypes().get(this.type)), (long)item.getSize()) || this.configuration.checkSizeAfterScaling() && ImageUtils.isImage((File)var10)) {
                        if (this.configuration.getSecureImageUploads() && ImageUtils.isImage((File)var10) && !ImageUtils.checkImageFile((FileItem)item)) {
                            this.errorCode = 204;
                            return false;
                        }
                        if (!FileUtils.checkIfFileIsHtmlFile((String)var10.getName(), (IConfiguration)this.configuration) && FileUtils.detectHtml((FileItem)item)) {
                            this.errorCode = 206;
                            return false;
                        }
                        return true;
                    }
                    this.errorCode = 203;
                    return false;
                }
                catch (SecurityException var7) {
                    if (this.configuration.isDebugMode()) {
                        this.exception = var7;
                    }
                    this.errorCode = 104;
                    return false;
                }
                catch (IOException var8) {
                    if (this.configuration.isDebugMode()) {
                        this.exception = var8;
                    }
                    this.errorCode = 104;
                    return false;
                }
            }
            this.errorCode = 102;
            return false;
        }
        this.errorCode = 202;
        return false;
    }

    public void setResponseHeader(HttpServletResponse response, ServletContext sc) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
    }

    private String getFileItemName(FileItem item) {
        Pattern p = Pattern.compile("[^\\\\/]+$");
        Matcher m = p.matcher(item.getName());
        return m.find() ? m.group(0) : "";
    }

    protected boolean checkParam(String reqParam) throws ConnectorException {
        if (reqParam != null && !reqParam.equals("")) {
            if (Pattern.compile("(/\\.|\\p{Cntrl}|//|\\\\|[:*?<>\"\\|])").matcher(reqParam).find()) {
                this.errorCode = 102;
                return false;
            }
            return true;
        }
        return true;
    }

    protected boolean checkHidden() throws ConnectorException {
        if (FileUtils.checkIfDirIsHidden((String)this.currentFolder, (IConfiguration)this.configuration)) {
            this.errorCode = 109;
            return true;
        }
        return false;
    }

    protected boolean checkConnector(HttpServletRequest request) throws ConnectorException {
        if (this.configuration.enabled() && this.configuration.checkAuthentication(request)) {
            return true;
        }
        this.errorCode = 500;
        return false;
    }

    protected boolean checkIfCurrFolderExists(HttpServletRequest request) throws ConnectorException {
        return true;
    }
}

