/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.security;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.security.shiro.session.SessionDAO;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.Encodes;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.interceptor.SystemServiceLog;
import com.cxqm.xiaoerke.modules.sys.security.UsernamePasswordToken;
import com.cxqm.xiaoerke.modules.sys.service.ISystemService;
import com.cxqm.xiaoerke.modules.sys.service.SystemService;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAuthorizingRealm
extends AuthorizingRealm {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ISystemService systemService;
    private SessionDAO sessionDAO;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        User user;
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        int activeSessionSize = this.getSessionDao().getActiveSessions(false).size();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("login submit, active session size: {}, username: {}", (Object)activeSessionSize, (Object)token.getUsername());
        }
        if ((user = this.getSystemService().getUserByLoginName(token.getUsername())) != null) {
            if ("0".equals(user.getLoginFlag())) {
                throw new AuthenticationException("msg:\u8be5\u5df2\u5e10\u53f7\u7981\u6b62\u767b\u5f55.");
            }
            byte[] salt = Encodes.decodeHex(user.getPassword().substring(0, 16));
            return new SimpleAuthenticationInfo((Object)new Principal(user, token.isMobileLogin()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])salt), this.getName());
        }
        return null;
    }

    public Session getSession() {
        return UserUtils.getSession();
    }

    public Subject getSubject() {
        return UserUtils.getSubject();
    }

    public List<Menu> getMenuList() {
        return UserUtils.getMenuList();
    }

    @SystemServiceLog(description="00000000")
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        User user;
        Collection<Session> sessions;
        Principal principal = (Principal)this.getAvailablePrincipal(principals);
        if (!"true".equals(Global.getConfig("user.multiAccountLogin")) && (sessions = this.getSessionDao().getActiveSessions(true, principal, this.getSession())).size() > 0) {
            if (this.getSubject().isAuthenticated()) {
                for (Session session : sessions) {
                    this.getSessionDao().delete(session);
                }
            } else {
                this.getSubject().logout();
                throw new AuthenticationException("msg:\u8d26\u53f7\u5df2\u5728\u5176\u5b83\u5730\u65b9\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002");
            }
        }
        if ((user = this.getSystemService().getUserByLoginName(principal.getLoginName())) != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            List<Menu> list = this.getMenuList();
            for (Menu menu : list) {
                if (!StringUtils.isNotBlank((CharSequence)menu.getPermission())) continue;
                for (String permission : StringUtils.split((String)menu.getPermission(), (String)",")) {
                    info.addStringPermission(permission);
                }
            }
            info.addStringPermission("user");
            for (Role role : user.getRoleList()) {
                info.addRole(role.getEnname());
            }
            this.getSystemService().updateUserLoginInfo(user);
            return info;
        }
        return null;
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        this.authorizationValidate(permission);
        super.checkPermission(permission, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermitted(permissions, info);
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.authorizationValidate(permission);
        return super.isPermitted(principals, permission);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermittedAll(permissions, info);
    }

    private void authorizationValidate(Permission permission) {
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        matcher.setHashIterations(1024);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    public ISystemService getSystemService() {
        if (this.systemService == null) {
            this.systemService = SpringContextHolder.getBean(SystemService.class);
        }
        return this.systemService;
    }

    public SessionDAO getSessionDao() {
        if (this.sessionDAO == null) {
            this.sessionDAO = SpringContextHolder.getBean(SessionDAO.class);
        }
        return this.sessionDAO;
    }

    public static boolean isValidateCodeLogin(String useruame, boolean isFail, boolean clean) {
        Integer loginFailNum;
        Map loginFailMap = (Map)CacheUtils.get("loginFailMap");
        if (loginFailMap == null) {
            loginFailMap = Maps.newHashMap();
            CacheUtils.put("loginFailMap", loginFailMap);
        }
        if ((loginFailNum = (Integer)loginFailMap.get(useruame)) == null) {
            loginFailNum = 0;
        }
        if (isFail) {
            Integer n = loginFailNum;
            Integer n2 = loginFailNum = Integer.valueOf(loginFailNum + 1);
            loginFailMap.put(useruame, loginFailNum);
        }
        if (clean) {
            loginFailMap.remove(useruame);
        }
        return loginFailNum >= 3;
    }

    public class Principal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String loginName;
        private String name;
        private boolean mobileLogin;

        public Principal(User user, boolean mobileLogin) {
            this.id = user.getId();
            this.loginName = user.getLoginName();
            this.name = user.getName();
            this.mobileLogin = mobileLogin;
        }

        public String getId() {
            return this.id;
        }

        public String getLoginName() {
            return this.loginName;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMobileLogin() {
            return this.mobileLogin;
        }

        public String getSessionid() {
            try {
                return (String)((Object)SystemAuthorizingRealm.this.getSession().getId());
            }
            catch (Exception e) {
                return "";
            }
        }

        public String toString() {
            return this.id;
        }
    }
}

