/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.service;

import com.cxqm.xiaoerke.common.service.CrudService;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.sys.dao.DictDao;
import com.cxqm.xiaoerke.modules.sys.entity.Dict;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class DictService
extends CrudService<DictDao, Dict> {
    public List<String> findTypeList() {
        return ((DictDao)this.dao).findTypeList(new Dict());
    }

    @Override
    public List<Dict> findList(Dict dict) {
        return ((DictDao)this.dao).findList(dict);
    }

    public Dict findDictByTypeValue(String type, String value) {
        if (type == null || type.trim().equals("")) {
            return null;
        }
        if (value == null || value.trim().equals("")) {
            return null;
        }
        Dict dict = new Dict();
        dict.setType(type);
        dict.setValue(value);
        List<Dict> list = this.findList(dict);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void saveOrDeleteDescription(String seoDescription) {
        Dict description = this.findDictByTypeValue("seo", "seoDescription");
        if (description != null && description.getLabel() != null) {
            this.delete(description);
        }
        description = new Dict();
        description.setType("seo");
        description.setValue("seoDescription");
        description.setLabel(seoDescription);
        description.setDescription(seoDescription);
        description.setSort(10);
        description.setCreateBy(UserUtils.getUser());
        description.setUpdateBy(UserUtils.getUser());
        this.save(description);
    }

    public void saveOrDeleteKeywords(String seoKeywords) {
        Dict keywords = this.findDictByTypeValue("seo", "seoKeywords");
        if (keywords != null && keywords.getLabel() != null) {
            this.delete(keywords);
        }
        keywords = new Dict();
        keywords.setType("seo");
        keywords.setValue("seoKeywords");
        keywords.setLabel(seoKeywords);
        keywords.setDescription(seoKeywords);
        keywords.setSort(10);
        keywords.setCreateBy(UserUtils.getUser());
        keywords.setUpdateBy(UserUtils.getUser());
        this.save(keywords);
    }

    public void saveOrDeleteTitle(String title) {
        Dict keywords = this.findDictByTypeValue("seo", "seoTitle");
        if (keywords != null && keywords.getLabel() != null) {
            this.delete(keywords);
        }
        keywords = new Dict();
        keywords.setType("seo");
        keywords.setValue("seoTitle");
        keywords.setLabel(title);
        keywords.setDescription(title);
        keywords.setSort(10);
        keywords.setCreateBy(UserUtils.getUser());
        keywords.setUpdateBy(UserUtils.getUser());
        this.save(keywords);
    }

    public void addDict(String type, String value, String label, String description) {
        Dict dict = new Dict();
        dict.setValue(value == null ? "" : value);
        dict.setType(type == null ? "" : type);
        dict.setLabel(label == null ? "" : label);
        dict.setDescription(description == null ? "" : description);
        dict.setId(IdGen.vestaId());
        this.save(dict);
    }

    @Override
    public void save(Dict dict) {
        super.save(dict);
        CacheUtils.remove("dictMap");
    }

    @Override
    public void delete(Dict dict) {
        super.delete(dict);
        CacheUtils.remove("dictMap");
    }
}

