package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.GetUserObjectTypeInterface;
import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.modules.sys.entity.SysPropertyVoWithBLOBsVo;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.cxqm.xiaoerke.modules.sys.service.SysPropertyServiceImpl;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

/**
 * Created by sunzb on 16/12/21.
 */
public class WeixinUtil { //请求微信接口获取微信信息 以及 用户信息的工具类
	public static Logger logger = LoggerFactory.getLogger(WeixinUtil.class);
	/**
	 * 判断是否需要跳转登陆页 不跳转登录页
	 */
	public final static Integer NOT_JUMP_STATUS=0;
	/**
	 * 判断是否需要跳转登陆页 跳转登录页
	 */
	public final static Integer JUMP_STATUS=1;
	/**
	 * 根据appid secret code 获取网页授权信息(包括openId等信息)
	 * @return
	 */
	public final static String  GET_OPENID_BY_CODE = "https://api.weixin.qq.com/sns/oauth2/access_token?";
	/**
	 * 根据appid secret code 获取网页授权信息(包括openId等信息)
	 * @return
	 */
	public final static String  GET_INFO_BY_TOKEN_OPENID="https://api.weixin.qq.com/sns/userinfo?";

	/**
	 * 根据appid secret code 获取网页授权信息(包括openId等信息)
	 * @return
	 */
	public final static String  GET_CGI_BIN_BY_TOKEN_OPENID="https://api.weixin.qq.com/cgi-bin/user/info?";

	/**
	 * 获取微信用户openid
	 * @param appid 公众号appid
	 * @param secret 公众号secret
	 * @param code 微信回调返回的code
	 * @return
	 */
	public static WechatBean getOpenIdByCode(String appid, String secret,String code){
		//微信获取用户信息地址
		String httpReq = GET_OPENID_BY_CODE + "appid=" + appid + "&secret=" + secret+"&code="+code+"&grant_type=authorization_code";
		//根据地址 请求微信接口 获取用户信息字符串
		String json = HttpRequestUtil.getConnectionResult(httpReq, "GET", "");

		WechatBean wechat = null;
		try {
			//将用户信息字符串转换为 微信用户信息对象
			wechat = JsonUtil.getObjFromJsonStr(json, WechatBean.class);
		} catch (Exception e) {
			logger.error("转换WechatBean失败", e);
		}
		if (wechat == null || wechat.getOpenid() == null) {
			logger.error(String.format("oauth认证失败[%s,%s,%s]：%s", appid, secret, code, json));
		}
		return wechat;
	}

	/**
	 * 获取微信用户信息
	 * @param wechat 微信用户信息对象
	 * @return
	 */
	public static WechatUserInfo getInfoByAccessTokenOpenId(WechatBean wechat){
		//微信获取用户信息地址
		String httpReq = GET_INFO_BY_TOKEN_OPENID + "access_token=" + wechat.getAccess_token() + "&openid=" + wechat.getOpenid()+"&lang=zh_CN";
		//根据地址 请求微信接口 获取用户信息字符串
		String json= HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
		WechatUserInfo info = null;
		try {
			//将用户信息字符串转换为 微信用户信息对象
			info = JsonUtil.getObjFromJsonStr(json, WechatUserInfo.class);
		} catch (Exception e) {
			logger.error("转换WechatUserInfo失败", e);
		}
		if (info == null || info.getNickname() == null) {
			logger.error(String.format("oauth拉去用户信息1失败[%s,%s]：%s", wechat.getAccess_token(), wechat.getOpenid(), json));
		}
		return info;
	}

	/**
	 * 获取微信用户信息
	 * @param wechat 微信用户信息对象
	 * @return
	 */
	public static WechatUserInfo getCgiBinByAccessTokenOpenId(WechatBean wechat){
		//微信获取用户信息地址
		String httpReq = GET_CGI_BIN_BY_TOKEN_OPENID + "access_token=" + wechat.getAccess_token() + "&openid=" + wechat.getOpenid()+"&lang=zh_CN";
		//根据地址 请求微信接口 获取用户信息字符串
		String json= HttpRequestUtil.getConnectionResult(httpReq, "GET", "");

		WechatUserInfo info = null;
		try {
			//将用户信息字符串转换为 微信用户信息对象
			info = JsonUtil.getObjFromJsonStr(json, WechatUserInfo.class);
		} catch (Exception e) {
			logger.error("转换WechatUserInfo失败", e);
		}
		if (info == null || info.getNickname() == null) {
			logger.error(String.format("oauth拉去用户信息2失败[%s,%s]：%s", wechat.getAccess_token(), wechat.getOpenid(), json));
		}
		return info;
	}

	/**
	 * 判断是否为微信浏览器访问
	 * @param request
	 * @return
	 */
	public static boolean isWeiXin(HttpServletRequest request) {
		return isWeiXin(request, null);
	}

	/**
	 * 判断是否为微信浏览器访问
	 * @param request
	 * @param ignoreWechatParamName
	 * @return
	 */
	public static boolean isWeiXin(HttpServletRequest request, String ignoreWechatParamName){
		//从头部信息中 取得客户使用的操作系统及版本
		String uaOri = request.getHeader("user-agent");
		//如果信息为空 请求有误
		if (uaOri == null) {
			return false;
		}
		//将信息转换为小写
		String ua = uaOri.toLowerCase();
		//判断是否为微信浏览器
		if (ua.indexOf("micromessenger") > 0) {// 是微信浏览器
			//忽视的条件 如果为空直接返回true
			if (ignoreWechatParamName == null || ignoreWechatParamName.trim().length() == 0) {
				return true;
			}
			//忽视的条件 如果等于直接返回false
			String ignore_wechat = request.getParameter(ignoreWechatParamName);
			if (ignore_wechat != null && ignore_wechat.equals("1")) {
				return false;
			}
			return true;
		}else{
			return false;
		}
	}

	/**
	 * 取浏览器中存取的用户信息cookie 支持旧版本
	 * @param request
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws InstantiationException
	 */
	public static User getUserFromCookie(HttpServletRequest request) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {

		//取浏览器中存取的用户信息cookie
		return getUserFromCookie(request,WCurrentUserUtil.COOKIE_USERINFO_KEY,WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY,WCurrentUserUtil.COOKIE_VERSION_KEY,WCurrentUserUtil.COOKIEPK,WCurrentUserUtil.COOKIE_VERSION,User.class);
	}

	/**
	 * 取浏览器中存取的用户信息cookie 传入接口
	 * @param request
	 * @param userInfoKey 用户信息key
	 * @param userInfoTokenKey 用户信息加密key
	 * @param vserionKey 版本号key
	 * @param cookiePK 加密串key
	 * @param cookieVersion 版本号值
	 * @param userInterface 泛型接口 封装数据的方法 返回对象类
	 * @param <T> 泛型
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws InstantiationException
	 */
	public static <T> T getUserFromCookie(HttpServletRequest request,String userInfoKey,String userInfoTokenKey,String vserionKey,String cookiePK,Integer cookieVersion,GetUserObjectTypeInterface userInterface) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {

		//取浏览器中存取的用户信息cookie
		return getUserFromCookie(request,WCurrentUserUtil.COOKIE_USERINFO_KEY,WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY,WCurrentUserUtil.COOKIE_VERSION_KEY,WCurrentUserUtil.COOKIEPK,WCurrentUserUtil.COOKIE_VERSION,userInterface,null);
	}

	/**
	 * 取浏览器中存取的用户信息cookie 传入泛型
	 * @param request
	 * @param userInfoKey 用户信息key
	 * @param userInfoTokenKey 用户信息加密key
	 * @param vserionKey 版本号key
	 * @param cookiePK 加密串key
	 * @param cookieVersion 版本号值
	 * @param t 泛型 要返回对象类
	 * @param <T>
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws InstantiationException
	 */
	public static <T> T getUserFromCookie(HttpServletRequest request,String userInfoKey,String userInfoTokenKey,String vserionKey,String cookiePK,Integer cookieVersion,Class<T> t) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {

		//取浏览器中存取的用户信息cookie
		return getUserFromCookie(request,WCurrentUserUtil.COOKIE_USERINFO_KEY,WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY,WCurrentUserUtil.COOKIE_VERSION_KEY,WCurrentUserUtil.COOKIEPK,WCurrentUserUtil.COOKIE_VERSION,null,t);
	}

	/**
	 * 取浏览器中存取的用户信息cookie
	 * @param request
	 * @param userInfoKey 用户信息key
	 * @param userInfoTokenKey 用户信息加密key
	 * @param vserionKey 版本号key
	 * @param cookiePK 加密串key
	 * @param cookieVersion 版本号值
	 * @param userInterface 泛型接口 封装数据的方法 返回对象类
	 * @param t 泛型 要返回对象类
	 * @param <T> 泛型
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws InstantiationException
	 */
	private static <T> T getUserFromCookie(HttpServletRequest request,String userInfoKey,String userInfoTokenKey,String vserionKey,String cookiePK,Integer cookieVersion,GetUserObjectTypeInterface userInterface,Class<T> t) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {

		//设置编码格式 utf-8  取cookies时不会乱码
		request.setCharacterEncoding("utf-8");
		//获取这次请求的所有cookies
		Cookie[] cookies = request.getCookies();

		//用户信息对象
		T userEntity = null;
		//解码后的用户信息cookie
		String userCookie = null;
		//解码后的用户信息加密cookie
		String userHiddenCookie = null;
		//解码后的版本号
		Integer versionCookie = null;

		//判断本次请求cookies数组是否为空
		if(cookies != null && cookies.length > 0){
			//从cookie数组中取出 用户cookie 用户加密cookie 版本号
			for (Cookie cookie : cookies) {
				//取得用户信息cookie
				if (userInfoKey.equals(cookie.getName())) {
					userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
				//取得用户信息加密cookie
				if(userInfoTokenKey.equals(cookie.getName())) {
					userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
				//取得版本号
				if(vserionKey.equals(cookie.getName())){
					versionCookie = Integer.valueOf(cookie.getValue());
				}
			}

			//判断用户信息cookie是否为空
			if(userCookie != null){

				//加密用户信息cookie
				String userCookieStr = String.valueOf(userCookie);
				String tokenOri = userCookieStr + cookiePK;
				String token = MD5UtilNew.getMD5String(tokenOri);

				//判断加密后的用户信息 cookie 和 从本次请求中cookies数组中取得的加密用户信息 cookie 是否相等 并且版本号是否一致
				if(token.equals(userHiddenCookie) && versionCookie == cookieVersion){
					//将用户信息cookie重新封装成用户信息对象
					JSONObject json = JSONObject.fromObject(userCookieStr);
					//获取从json中取值封装后的范型对象
					userEntity = getPackagingUserCookie(json,t,userInterface);
				}
			}
		}

		return userEntity;
	}

	/**
	 * 判断使用哪种封装方法然后返回泛型对象
	 * @param json 要封装的数据
	 * @param t 泛型 要返回对象类
	 * @param userInterface 泛型接口 封装数据的方法 返回对象类
	 * @param <T> 泛型
	 * @return
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws InstantiationException
	 */
	private static <T> T getPackagingUserCookie(JSONObject json,Class<T> t,GetUserObjectTypeInterface userInterface) throws IllegalAccessException, NoSuchFieldException, InstantiationException {

		//如果传入的接口为空 则使用泛型转换封装方法
		if(userInterface == null){
			return WCurrentUserUtil.getPackagingUserCookie(json,t);
		}

		//泛型接口 封装方法
		return (T)userInterface.getUser(json);
	}

	/**
	 * 取浏览器中存取的微信用户信息cookie
	 * @param request
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	public static WechatUserInfo getWechatDHUserInfoFromCookie(HttpServletRequest request) throws UnsupportedEncodingException {

		//设置编码格式 utf-8  取cookies时不会乱码
		request.setCharacterEncoding("utf-8");
		//获取这次请求的所有cookies
		Cookie[] cookies = request.getCookies();

		//用户微信信息对象
		WechatUserInfo userEntity = null;
		//解码后的用户微信信息cookie
		String weixinCookie = null;
		//解码后的加密用户微信信息cookie
		String userHiddenCookie = null;

		//判断本次请求cookies数组是否为空
		if(cookies != null){
			//从cookie数组中取出 用户微信信息cookie 用户加密微信信息cookie 版本号
			for (Cookie cookie : cookies) {
				//用户微信信息cookie
				if(WCurrentUserUtil.COOKIE_WEIXIN_USERINFO_KEY.equals(cookie.getName())){
					weixinCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
				//加密用户微信信息cookie
				if(WCurrentUserUtil.COOKIE_USERINFO_WEIXIN_TOKEN_KEY.equals(cookie.getName())) {
					userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
			}

			//判断用户微信信息cookie是否为空
			if(weixinCookie != null){

				//加密用户微信信息cookie
				String userCookieStr = String.valueOf(weixinCookie);
				String tokenOri = userCookieStr + WCurrentUserUtil.COOKIEPK;
				String token = MD5UtilNew.getMD5String(tokenOri);

				//判断加密后的用户微信信息 cookie 和 从本次请求中cookies数组中取得的加密用户微信信息 cookie 是否相等
				if(token.equals(userHiddenCookie)){
					JSONObject u = JSONObject.fromObject(weixinCookie);
					userEntity = (WechatUserInfo) JSONObject.toBean(u, WechatUserInfo.class);
				}
			}
		}
		return userEntity;
	}
}
