/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cxqm.xiaoerke.common.config;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

import com.ckfinder.connector.ServletContextFactory;
import com.cxqm.xiaoerke.common.filter.LoadProjectPath;
import com.cxqm.xiaoerke.common.utils.PropertiesLoader;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.google.common.collect.Maps;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局配置类
 * @author ThinkGem
 * @version 2014-06-25
 */
public class Global {
	
	public static int RECOMMENDED_FEE = 10;
	/**
	 * 当前对象实例
	 */
	private static Global global = new Global();
	
	/**
	 * 保存全局属性值
	 */
	private static Map<String, String> map = Maps.newHashMap();
	
	/**
	 * 属性文件加载对象
	 */
	public static PropertiesLoader propertiesLoader = new PropertiesLoader("system.properties");
	
	/**
	 * 获取当前对象实例
	 */
	public static Global getInstance() {
		return global;
	}
	
	/**
	 * 获取配置
	 * @see ${fns:getConfig('adminPath')}
	 */
	public static String getConfig(String key) {
		String value = map.get(key);
		if (value == null){
			value = propertiesLoader.getProperty(key);
			map.put(key, value != null ? value : StringUtils.EMPTY);
		}
		return value;
	}

	private static Boolean isDebug;
	public static boolean isDebug() {
		if (isDebug == null) {
			String isDebugStr = getConfig("isDebug");
			if (isDebug == null) {
				isDebug = false;
			}
			isDebug = "1".equals(isDebugStr);
		}
		return isDebug;
	}


	public static String getHTTPUrlConfig(String key) {
		String url = getConfig(key);

		return LoadProjectPath.getHTTPUrlByScheme(url);
	}

	public static String getUrlConfig(String key, HttpServletRequest request) {
		String url = getConfig(key);
		return LoadProjectPath.getUrlByScheme(request, url);
	}

	public static Integer getIntegerConfig(String key, Integer defaultValue) {
		String str = Global.getConfig(key);
		Integer result = null;
		try {
			result = Integer.parseInt(str);
		} catch (NumberFormatException e) {
			result = defaultValue;
		}
		return result;
	}
	
	/////////////////////////////////////////////////////////
	
	/**
	 * 获取管理端根路径
	 */
	public static String getAdminPath() {
		return getConfig("adminPath");
	}
	
	/**
	 * 获取前端根路径
	 */
	public static String getFrontPath() {
		return getConfig("frontPath");
	}
	
	/**
	 * 获取URL后缀
	 */
	public static String getUrlSuffix() {
		return getConfig("urlSuffix");
	}
	
	/**
	 * 是否是演示模式，演示模式下不能修改用户、角色、密码、菜单、授权
	 */
	public static Boolean isDemoMode() {
		String dm = getConfig("demoMode");
		return "true".equals(dm) || "1".equals(dm);
	}
	
	/////////////////////////////////////////////////////////
	
	// 显示/隐藏
	public static final String SHOW = "1";
	public static final String HIDE = "0";

	// 是/否
	public static final String YES = "1";
	public static final String NO = "0";
	
	// 对/错
	public static final String TRUE = "true";
	public static final String FALSE = "false";

	public static final String USERFILES_BASE_URL = "/userfiles/";

	/**
	 * 页面获取常量
	 * @see ${fns:getConst('YES')}
	 */
	public static Object getConst(String field) {
		try {
			return Global.class.getField(field).get(null);
		} catch (Exception e) {
			// 异常代表无配置，这里什么也不做
		}
		return null;
	}

	/**
	 * 获取上传文件的根目录
	 * @return
	 */
	public static String getUserfilesBaseDir() {
		String dir = getConfig("userfiles.basedir");
		if (StringUtils.isBlank(dir)){
			try {
				dir = "../webapps/backend";
			} catch (Exception e) {
				return "";
			}
		}
		if(!dir.endsWith("/")) {
			dir += "/";
		}
//		System.out.println("userfiles.basedir: " + dir);
		return dir;
	}

	public static Integer getMeetingExpiredSecond() {
		return Global.getIntegerConfig("haoyun.overtime_meeting",1800);
	}

}
