/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cxqm.xiaoerke.modules.sys.service;

import java.util.Date;
import java.util.List;

import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.WCurrentUserUtil;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cxqm.xiaoerke.common.service.CrudService;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.modules.sys.dao.DictDao;
import com.cxqm.xiaoerke.modules.sys.entity.Dict;
import com.cxqm.xiaoerke.modules.sys.utils.DictUtils;

/**
 * 字典Service
 * @author ThinkGem
 * @version 2014-05-16
 */
@Service
@Transactional(readOnly = false)
public class DictService extends CrudService<DictDao, Dict> {
	
	/**
	 * 查询字段类型列表
	 * @return
	 */
	public List<String> findTypeList(){
		return dao.findTypeList(new Dict());
	}

	public List<Dict> findList(Dict dict){
		return dao.findList(dict);
	}

	public Dict findDictByTypeValue(String type,String value){

		if(type == null || type.trim().equals("")){
			return null;
		}

		if(value == null || value.trim().equals("")){
			return null;
		}

		Dict dict = new Dict();

		dict.setType(type);
		dict.setValue(value);

		List<Dict> list = findList(dict);

		if(list == null || list.size() == 0){
			return null;
		}

		return list.get(0);
	}

	public void saveOrDeleteDescription(String seoDescription){
		Dict description = findDictByTypeValue("seo","seoDescription");
		if(description != null && description.getLabel() != null){
			delete(description);
		}
		description = new Dict();
		description.setType("seo");
		description.setValue("seoDescription");
		description.setLabel(seoDescription);
		description.setDescription(seoDescription);
		description.setSort(10);
		description.setCreateBy(UserUtils.getUser());
		description.setUpdateBy(UserUtils.getUser());
		save(description);
	}

	public void saveOrDeleteKeywords(String seoKeywords){
		Dict keywords = findDictByTypeValue("seo","seoKeywords");
		if(keywords != null && keywords.getLabel() != null){
			delete(keywords);
		}
		keywords = new Dict();
		keywords.setType("seo");
		keywords.setValue("seoKeywords");
		keywords.setLabel(seoKeywords);
		keywords.setDescription(seoKeywords);
		keywords.setSort(10);
		keywords.setCreateBy(UserUtils.getUser());
		keywords.setUpdateBy(UserUtils.getUser());
		save(keywords);
	}

	public void saveOrDeleteTitle(String title){
		Dict keywords = findDictByTypeValue("seo","seoTitle");
		if(keywords != null && keywords.getLabel() != null){
			delete(keywords);
		}
		keywords = new Dict();
		keywords.setType("seo");
		keywords.setValue("seoTitle");
		keywords.setLabel(title);
		keywords.setDescription(title);
		keywords.setSort(10);
		keywords.setCreateBy(UserUtils.getUser());
		keywords.setUpdateBy(UserUtils.getUser());
		save(keywords);
	}

	public void addDict(String type,String value,String label,String description){
		Dict dict = new Dict();
		dict.setValue(value == null ? "" : value);
		dict.setType(type == null ? "" : type);
		dict.setLabel(label == null ? "" : label);
		dict.setDescription(description == null ? "" : description);
		dict.setId(IdGen.vestaId());
		save(dict);
	}

	@Override
	public void save(Dict dict) {
		super.save(dict);
		CacheUtils.remove(DictUtils.CACHE_DICT_MAP);
	}
	
	@Override
	public void delete(Dict dict) {
		super.delete(dict);
		CacheUtils.remove(DictUtils.CACHE_DICT_MAP);
	}

}
