package com.cxqm.xiaoerke.common.mybatis;

import com.cxqm.xiaoerke.modules.sys.entity.User;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Created by sunzsh on 2017/6/22.
 */
public class UserHandler implements TypeHandler<User> {

	@Override
	public void setParameter(PreparedStatement ps, int i, User parameter, JdbcType jdbcType) throws SQLException {
		ps.setString(i, parameter.getId());
	}

	@Override
	public User getResult(ResultSet rs, String columnName) throws SQLException {
		String id = rs.getString(columnName);
		return new User(id);
	}

	@Override
	public User getResult(ResultSet rs, int columnIndex) throws SQLException {
		String id = rs.getString(columnIndex);
		return new User(id);
	}

	@Override
	public User getResult(CallableStatement cs, int columnIndex) throws SQLException {
		String id = cs.getString(columnIndex);
		return new User(id);
	}
}
