/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.persistence;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.persistence.Order;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.session.RowBounds;

public class Page<T>
extends RowBounds
implements Serializable {
    private static final long serialVersionUID = 8377027857240893626L;
    private int pageNo = 1;
    private int pageSize = Integer.valueOf(Global.getConfig("page.pageSize"));
    private long count;
    private int first;
    private int last;
    private int prev;
    private int next;
    private boolean firstPage;
    private boolean lastPage;
    private int length = 10;
    private int slider = 1;
    private List<T> list = new ArrayList<T>();
    private String orderBy = "";
    private String funcName = "page";
    private String message = "";

    public Page(int pageNo, int pageSize) {
        this(pageNo, pageSize, 0L);
    }

    public Page(int pageNo, int pageSize, long count) {
        this(pageNo, pageSize, count, new ArrayList());
    }

    public Page(int pageNo, int pageSize, long count, List<T> list) {
        super((pageNo - 1) * pageSize, pageSize);
        this.setCount(count);
        this.setPageNo(pageNo);
        this.pageSize = pageSize;
        this.setList(list);
    }

    public Page(RowBounds rowBounds) {
        super(rowBounds.getOffset(), rowBounds.getLimit());
        this.setPageNo(rowBounds.getOffset() / rowBounds.getLimit() + 1);
        this.setPageSize(rowBounds.getLimit());
        if (rowBounds instanceof Page) {
            this.setCount(((Page)rowBounds).getCount());
        }
    }

    public Page() {
        super(0, 10);
    }

    public Page(int offset, int limit, String placeholder) {
        super(offset, limit);
    }

    public void initialize() {
        this.first = 1;
        this.last = (int)(this.count / (long)(this.pageSize < 1 ? 20 : this.pageSize) + (long)this.first - 1L);
        if (this.count % (long)this.pageSize != 0L || this.last == 0) {
            ++this.last;
        }
        if (this.last < this.first) {
            this.last = this.first;
        }
        if (this.pageNo <= 1) {
            this.pageNo = this.first;
            this.firstPage = true;
        }
        if (this.pageNo >= this.last) {
            this.pageNo = this.last;
            this.lastPage = true;
        }
        this.next = this.pageNo < this.last - 1 ? this.pageNo + 1 : this.last;
        this.prev = this.pageNo > 1 ? this.pageNo - 1 : this.first;
        if (this.pageNo < this.first) {
            this.pageNo = this.first;
        }
        if (this.pageNo > this.last) {
            this.pageNo = this.last;
        }
    }

    public String toString() {
        int i;
        int end;
        this.initialize();
        StringBuilder sb = new StringBuilder();
        if (this.pageNo == this.first) {
            sb.append("<li class=\"disabled\"><a href=\"javascript:\">&#171; \u4e0a\u4e00\u9875</a></li>\n");
        } else {
            sb.append("<li><a href=\"javascript:" + this.funcName + "(" + this.prev + "," + this.pageSize + ");\">&#171; \u4e0a\u4e00\u9875</a></li>\n");
        }
        int begin = this.pageNo - this.length / 2;
        if (begin < this.first) {
            begin = this.first;
        }
        if ((end = begin + this.length - 1) >= this.last && (begin = (end = this.last) - this.length + 1) < this.first) {
            begin = this.first;
        }
        if (begin > this.first) {
            i = 0;
            for (i = this.first; i < this.first + this.slider && i < begin; ++i) {
                sb.append("<li><a href=\"javascript:" + this.funcName + "(" + i + "," + this.pageSize + ");\">" + (i + 1 - this.first) + "</a></li>\n");
            }
            if (i < begin) {
                sb.append("<li class=\"disabled\"><a href=\"javascript:\">...</a></li>\n");
            }
        }
        for (i = begin; i <= end; ++i) {
            if (i == this.pageNo) {
                sb.append("<li class=\"active\"><a href=\"javascript:\">" + (i + 1 - this.first) + "</a></li>\n");
                continue;
            }
            sb.append("<li><a href=\"javascript:" + this.funcName + "(" + i + "," + this.pageSize + ");\">" + (i + 1 - this.first) + "</a></li>\n");
        }
        if (this.last - end > this.slider) {
            sb.append("<li class=\"disabled\"><a href=\"javascript:\">...</a></li>\n");
            end = this.last - this.slider;
        }
        for (i = end + 1; i <= this.last; ++i) {
            sb.append("<li><a href=\"javascript:" + this.funcName + "(" + i + "," + this.pageSize + ");\">" + (i + 1 - this.first) + "</a></li>\n");
        }
        if (this.pageNo == this.last) {
            sb.append("<li class=\"disabled\"><a href=\"javascript:\">\u4e0b\u4e00\u9875 &#187;</a></li>\n");
        } else {
            sb.append("<li><a href=\"javascript:" + this.funcName + "(" + this.next + "," + this.pageSize + ");\">" + "\u4e0b\u4e00\u9875 &#187;</a></li>\n");
        }
        sb.append("<li class=\"disabled controls\"><a href=\"javascript:\">\u5f53\u524d \u7b2c");
        sb.append("<input type=\"text\" value=\"" + this.pageNo + "\" onkeypress=\"if (event.keyCode==13) ");
        sb.append(this.funcName + "(this.value," + this.pageSize + ");\" onclick=\"this.select();\"/>\u9875 /\u6bcf\u9875 ");
        sb.append("<input type=\"text\" value=\"" + this.pageSize + "\" onkeypress=\"if (event.keyCode==13) ");
        sb.append(this.funcName + "(" + this.pageNo + ",this.value);\" onclick=\"this.select();\"/> \u6761\uff0c");
        sb.append("\u5171 " + this.count + " \u6761" + (this.message != null ? this.message : "") + "</a><li>\n");
        sb.insert(0, "<ul>\n").append("</ul>\n");
        sb.append("<div style=\"clear:both;\"></div>");
        return sb.toString();
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
        if ((long)this.pageSize >= count) {
            this.pageNo = 1;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 10 : (pageSize > 500 ? 500 : pageSize);
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int getTotalPage() {
        return this.getLast();
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    public int getPrev() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    public int getNext() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isDisabled() {
        return this.pageSize == -1;
    }

    public boolean isNotCount() {
        return this.count == -1L;
    }

    public int getFirstResult() {
        int firstResult = (this.getPageNo() - 1) * this.getPageSize();
        if ((long)firstResult >= this.getCount()) {
            firstResult = 0;
        }
        return firstResult;
    }

    public int getMaxResults() {
        return this.getPageSize();
    }

    public List<Order> getOrders() {
        return Collections.emptyList();
    }

    public Boolean getAsyncTotalCount() {
        return Boolean.FALSE;
    }

    public void addAll(Collection<T> elements) {
        this.list.addAll(elements);
    }

    public String getMessage() {
        return this.message;
    }
}

