/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cxqm.xiaoerke.common.utils;

import java.io.Serializable;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

import com.cxqm.xiaoerke.common.config.Global;
import com.robert.vesta.service.bean.Id;
import com.robert.vesta.service.impl.IdServiceImpl;
import com.robert.vesta.service.impl.provider.PropertyMachineIdProvider;
import com.robert.vesta.service.intf.IdService;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

/**
 * 封装各种生成唯一性ID算法的工具类.
 * @author ThinkGem
 * @version 2013-01-15
 */
@Service
@Lazy(false)
public class IdGen implements IdGenerator, SessionIdGenerator {

	private static SecureRandom random = new SecureRandom();

	private static IdService idService;
	
	/**
	 * 封装JDK自带的UUID, 通过Random数字生成, 中间无-分割.
	 */
	public static String uuid() {
		return UUID.randomUUID().toString().replaceAll("-", "");
	}

	public static IdService getIdService(){
		if (idService == null) {
			PropertyMachineIdProvider propertyMachineIdProvider = new PropertyMachineIdProvider();
			String config = Global.getConfig("vesta.machine");
			propertyMachineIdProvider.setMachineId((config == null || config.trim().length() == 0) ? 1 : Integer.parseInt(config));

			idService = new IdServiceImpl();
			((IdServiceImpl)idService).setMachineIdProvider(propertyMachineIdProvider);
			((IdServiceImpl)idService).init();
		}
		if (idService == null) {
			throw new IllegalArgumentException("初始化vestaId服务失败!");
		}
		return idService;
	}

	public static String vestaId() {
		return getIdService().genId() + "";
	}

	public static Date getDateByVestaId(String vestaId) {
		if (vestaId == null) {
			return null;
		}
		Long vestaIdLong;
		try {
			vestaIdLong = Long.parseLong(vestaId);
		} catch (NumberFormatException e) {
			e.printStackTrace();
			return null;
		}

		Id id = getIdService().expId(vestaIdLong);
		return getIdService().transTime(id.getTime());
	}


	/**
	 * 使用SecureRandom随机生成Long. 
	 */
	public static long randomLong() {
		return Math.abs(random.nextLong());
	}

	/**
	 * 基于Base62编码的SecureRandom随机生成bytes.
	 */
	public static String randomBase62(int length) {
		byte[] randomBytes = new byte[length];
		random.nextBytes(randomBytes);
		return Encodes.encodeBase62(randomBytes);
	}

	public static String orderNo(){
		SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
		String code=formatter.format(new Date())+"";
		Double d=(Math.random()*900)+100;
		int number=d.intValue();
		return code+number;
	}
	
	/**
	 * Activiti ID 生成
	 */
	@Override
	public String getNextId() {
		return IdGen.uuid();
	}

	@Override
	public Serializable generateId(Session session) {
		return IdGen.uuid();
	}
	
	public static void main(String[] args) {
		for (int i = 0; i < 20; i++) {
			System.out.println(IdGen.vestaId());
		}
		for (int i = 0; i < 20; i++) {
			System.out.println(IdGen.uuid());
		}

	}

}
