package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.GetUserObjectTypeInterface;
import com.cxqm.xiaoerke.common.bean.ICookieEntity;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.sf.json.JSONObject;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;


/**
 * Created by sunzb on 16/12/21.
 */
public class WCurrentUserUtil { //用户信息封装 以及 常用key的存放

	public static String COOKIEPK = "X1+n3$]`N8~/";
	/**
	 * 微信端cookie用户信息对应KEY
	 */
	public static String COOKIE_USERINFO_KEY = "haoyun_userInfo";
	/**
	 * 微信端cookie版本号对应KEY
	 */
	public static String COOKIE_VERSION_KEY = "haoyun_version";
	/**
	 * 微信端cookie微信呢用户信息对应KEY
	 */
	public static String COOKIE_WEIXIN_USERINFO_KEY = "haoyun_weixin_userInfo";
	/**
	 * 用户版本号
	 */
	public static Integer COOKIE_VERSION = 4;
	/**
	 * 微信用户信息cookie版本号对应KEY
	 */
	public static String COOKIE_VERSION_WEIXIN_KEY = "haoyun_weixin_version";
	/**
	 * 微信用户信息密文cookie版本号对应KEY
	 */
	public static String COOKIE_USERINFO_WEIXIN_TOKEN_KEY = "haoyun_userInfo_weixin_token";

	/**
	 * 微信用户信息版本号
	 */
	public static Integer COOKIE_WEIXIN_VERSION = 1;
	/**
	 * 微信端cookie用户信息对应KEY验证token
	 */
	public static String COOKIE_USERINFO_TOKEN_KEY = "haoyun_userInfo_token";

	/**
	 * 用户微信头像地址
	 */
	public final static String COOKIE_USERINFO_HEAD_URL_KEY = "haoyun_userInfo_head_url";

	/**
	 * 清空用户信息cookie
	 * @param request
	 * @param response
	 */
	public static void clearUserInfoCookie(HttpServletRequest request,HttpServletResponse response){

		clearUserInfoCookie(COOKIE_USERINFO_KEY,COOKIE_USERINFO_TOKEN_KEY,COOKIE_VERSION_KEY,request,response);
	}

	/**
	 * 清空用户信息cookie
	 * @param userKey 用户信息key
	 * @param userTokenKey 用户信息加密key
	 * @param versionKey 版本号key
	 * @param request
	 * @param response
	 */
	public static void clearUserInfoCookie(String userKey, String userTokenKey, String versionKey, HttpServletRequest request,HttpServletResponse response){

		//取得域名
		String s = request.getServerName();
		String[] domainArr = s.split("\\.");
		String doamin = "";
		if(domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*")){
			doamin = request.getServerName();
		}else{
			doamin = "." + domainArr[domainArr.length-2] + "." + domainArr[domainArr.length-1];
		}

		//重新生成cookie 根据key覆盖原有的cookie 然后将存活周期赋值为0 域名，地址存入 之后放response中
		coverCookieByKey(userKey,doamin,response);
		coverCookieByKey(userTokenKey,doamin,response);
		coverCookieByKey(versionKey,doamin,response);
	}

	/**
	 * 清空用户微信信息cookie
	 * @param request
	 * @param response
	 */
	public static void clearWeinXinUserInfoCookie(HttpServletRequest request,HttpServletResponse response){

		clearWeinXinUserInfoCookie(request,response,COOKIE_WEIXIN_USERINFO_KEY);
	}

	/**
	 * 清空用户微信信息cookie 根据key
	 * @param request
	 * @param response
	 * @param key
	 */
	public static void clearWeinXinUserInfoCookie(HttpServletRequest request,HttpServletResponse response,String key){

		//取得域名
		String s = request.getServerName();
		String[] domainArr = s.split("\\.");
		String doamin = "";
		if(domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*")){
			doamin = request.getServerName();
		}else{
			doamin = "." + domainArr[domainArr.length-2] + "." + domainArr[domainArr.length-1];
		}

		//重新生成cookie 根据key覆盖原有的cookie 然后将存活周期赋值为0 域名，地址存入 之后放response中
		coverCookieByKey(key,doamin,response);
	}

	/**
	 * 将用户信息存入cookie中保存
	 * @param user 用户信息
	 * @param request
	 * @param response
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static boolean setCurrentUser(User user, HttpServletRequest request,HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {

		return setCurrentUser(user,null,COOKIE_USERINFO_KEY,COOKIEPK,COOKIE_USERINFO_TOKEN_KEY,COOKIE_VERSION_KEY,COOKIE_VERSION,request,response);
	}

	/**
	 * 将用户信息存入cookie中保存
	 * @param t 用户信息
	 * @param userInterface 用户信息封装接口
	 * @param userKey 用户信息存储key
	 * @param userTokenPK 用户信息加密串存储key
	 * @param userTokenKey 用户信息加密存储key
	 * @param versionKey 版本号key
	 * @param versionValue 版本号value
	 * @param request
	 * @param response
	 * @param <T>
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static <T extends ICookieEntity> boolean setCurrentUser(T t, GetUserObjectTypeInterface userInterface, String userKey, String userTokenPK, String userTokenKey, String versionKey, Integer versionValue, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
		//取得域名
		String[] domainArr=request.getServerName().split("\\.");
		String doamin="";
		if(domainArr.length==1 || domainArr[domainArr.length - 1].matches("\\d*")){
			doamin=request.getServerName();
		}else{
			doamin="." + domainArr[domainArr.length-2]+"."+domainArr[domainArr.length-1];
		}

		//将用户对象封装为jsonobject便于存储
		JSONObject userCookie = null;
		try {
			userCookie = packagingUserCookie(t,false);
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		}

		//保存用户信息cookie
		saveCookieByKey(userKey,doamin,userCookie,response);

		//保存加密用户信息cookie
		String userCookieStr = String.valueOf(userCookie);
		String tokenOri = userCookieStr + userTokenPK;
		String token = MD5UtilNew.getMD5String(tokenOri);
		saveCookieByKey(userTokenKey,doamin,token,response);

		//保存版本号cookie
		saveCookieByKey(versionKey,doamin,versionValue,response);
		return false;
	}

	/**
	 * 将用户微信信息存入cookie中保存
	 * @param user 用户信息
	 * @param request
	 * @param response
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static boolean setCurrentWeixinUser(WechatUserInfo user,HttpServletRequest request,HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {

		setCurrentWeixinUser(user,COOKIE_WEIXIN_USERINFO_KEY,COOKIEPK,COOKIE_USERINFO_WEIXIN_TOKEN_KEY,COOKIE_VERSION_WEIXIN_KEY,COOKIE_WEIXIN_VERSION,request,response);
		return  true;
	}

	/**
	 * 将用户微信信息存入cookie中保存
	 * @param user 用户信息
	 * @param request
	 * @param response
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static boolean setCurrentWeixinUser(WechatUserInfo user,String userKey,String userPKKey,String userTokenKey,String versionKey,Integer versionValue,HttpServletRequest request,HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {

		//取得域名
		String[] domainArr = request.getServerName().split("\\.");
		String doamin = "";
		if(domainArr.length == 1){
			doamin = domainArr[0];
		}else{
			doamin = "." + domainArr[domainArr.length-2] + "." + domainArr[domainArr.length-1];
		}

		//转换微信昵称
		ObjectMapper mapper = new ObjectMapper();
		user.setNickname(EmojiFilter.coverEmoji(user.getNickname()));
		String userCookie = mapper.writeValueAsString(user);

		//保存用户微信信息cookie
		saveCookieByKey(userKey,doamin,userCookie,response);

		//保存加密用户微信信息cookie
		String userCookieStr = String.valueOf(userCookie);
		String tokenOri = userCookieStr + userPKKey;
		String token = MD5UtilNew.getMD5String(tokenOri);
		saveCookieByKey(userTokenKey,doamin,token,response);

		//保存微信版本号cookie
		saveCookieByKey(versionKey,doamin,versionValue,response);

		return true;
	}

	/**
	 * 封装用户信息jsonobject
	 * @param t 用户信息
	 * @param userInterface 封装接口
	 * @param <T>
	 * @return
	 */
	private <T extends ICookieEntity> JSONObject packagingUserCookie(T t,GetUserObjectTypeInterface userInterface){

		//如果封装接口未传，则不使用封装接口
		if(userInterface == null){
			try {
				return packagingUserCookie(t,false);
			} catch (NoSuchFieldException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InstantiationException e) {
				e.printStackTrace();
			}
		}

		return userInterface.getUserJsonObject(t);
	}

	/**
	 * 覆盖cookie 立即杀死
	 * @param key cookie的key
	 * @param doamin cookie的域名
	 * @param response
	 */
	private static void coverCookieByKey(String key,String doamin,HttpServletResponse response){
		Cookie cookie = new Cookie(key, null);
		cookie.setMaxAge(0);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
	}

	/**
	 * 保存cookie
	 * @param key cookie的key
	 * @param doamin cookie的域名
	 * @param value cookie的值
	 * @param response
	 * @throws UnsupportedEncodingException
	 */
	private static void saveCookieByKey(String key,String doamin,Object value,HttpServletResponse response) throws UnsupportedEncodingException {
		Cookie cookie = new Cookie(key,URLEncoder.encode(String.valueOf(value), "UTF-8"));
		cookie.setMaxAge(Integer.MAX_VALUE);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
	}

	/**
	 * 封装用户cookie对象
	 * @param jsonObject
	 * @param t
	 * @param <T>
	 * @return
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws NoSuchFieldException
	 */
	public static <T extends ICookieEntity> T getPackagingUserCookie(JSONObject jsonObject,Class<T> t) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
		//泛型反射 创建一个新的对象类型
		T userEntity = t.newInstance();

		userEntity.setId(jsonObject.getString("id"));
		userEntity.setMobile(jsonObject.getString("mobile"));
		userEntity.setName(jsonObject.getString("name"));
		userEntity.setPhoto(jsonObject.getString("photo"));
		userEntity.setBuckter(jsonObject.getString("buckter"));
		userEntity.setUserType(jsonObject.getString("userType"));

		return  userEntity;
	}



	/**
	 * 根据key值 获取对应的泛值对象属性
	 * @param t 泛值对象
	 * @param key 属性名称
	 * @param <T>
	 * @return
	 */
	private static <T> Field getFieldByKey(T t,String key){
		try {

			Class curClass = t.getClass();

			Field field = null;

			Class<?> clazz = curClass;

			for (;clazz != Object.class;clazz = clazz.getSuperclass()){
				try {

					field = clazz.getDeclaredField(key);
				}catch (Exception e){

				}
			}

			if(field != null){

				field.setAccessible(true);

			}
			return field;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 封装用户信息
	 * @param t
	 * @param isSuperPwd 是否使用超级密码登录
	 * @return
	 */
	public static <T extends ICookieEntity> JSONObject packagingUserCookie(T t, boolean isSuperPwd) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
		//泛型反射 创建一个新的对象类型
		T userEntity = t;

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("id",userEntity.getId());
		jsonObject.put("mobile",userEntity.getMobile());
		jsonObject.put("name",userEntity.getName());
		jsonObject.put("photo",userEntity.getPhoto());
		jsonObject.put("buckter",userEntity.getBuckter());
		jsonObject.put("header",userEntity.getFullPhoto()+"-dmax232");
		jsonObject.put("userType",userEntity.getUserType());

		if (isSuperPwd) {
			jsonObject.put("isSuperPwd", "1");
		}

		return jsonObject;
	}

	/**
	 * 封装用户信息
	 * @param user 用户信息
	 * @return
	 */
	public static JSONObject packagingUserCookie(User user){
		try {
			return packagingUserCookie(user, false);
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 将字符串转换为map
	 * @param singInfo 要转换为map的字符串
	 * @return
	 */
	public static Map stringToMap(String singInfo){
		//将map.toString后的串反转成map
		String str1 = singInfo.replaceAll("\\{|\\}", "");//singInfo是一个map  toString后的字符串。
		String str2 = str1.replaceAll(" ", "");
		String str3 = str2.replaceAll(",", "&");
		Map<String, String> map = null;
		if ((null != str3) && (!"".equals(str3.trim())))
		{
			String[] resArray = str3.split("&");
			if (0 != resArray.length)
			{
				map = new HashMap(resArray.length);
				for (String arrayStr : resArray) {
					if ((null != arrayStr) && (!"".equals(arrayStr.trim())))
					{
						int index = arrayStr.indexOf("=");
						if (-1 != index) {
							map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
						}
					}
				}
			}
		}
		return map;
	}

	/**
	 * 加密用户信息 将用户信息转为字符串然后拼接加密串进行md5加密
	 * @param user 用户信息
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static String MD5UserToken(String user)throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException{
		if(user == null || user.equals("") || user.equals("null")){

			return "";
		}

		return MD5UserToken(user,COOKIEPK);
	}

	/**
	 * 加密 字符串拼接加密串进行md5加密
	 * @param obj 用户信息
	 * @param PK 加密串
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static String MD5UserToken(String obj,String PK)throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException{
		if(obj == null || obj.equals("") || obj.equals("null")){
			return "";
		}

		//拼接加密串
		String tokenOri = obj + PK;
		//拼接后的字符串进行md5加密
		String token = MD5UtilNew.getMD5String(tokenOri);
		return URLEncoder.encode(token,"UTF-8");
	}

	/**
	 * 加密用户微信信息 将用户微信信息转为字符串然后拼接加密串进行md5加密
	 * @param wechatUserInfo 用户微信信息
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws NoSuchAlgorithmException
	 * @throws JsonProcessingException
	 */
	public static String MD5WeiXinUserToken(String wechatUserInfo)throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException{
		if(wechatUserInfo==null||wechatUserInfo.equals("")||wechatUserInfo.equals("null")){
			return "";
		}
		//拼接加密串
		String tokenOri = wechatUserInfo + COOKIEPK;
		//拼接后的字符串进行md5加密
		String token = MD5UtilNew.getMD5String(tokenOri);
		return URLEncoder.encode(token,"UTF-8");
	}



	public static boolean isSuperPwd(HttpServletRequest request) {
		try {
			request.setCharacterEncoding("utf-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		Cookie[] cookies = request.getCookies();
		User userEntity=null;
		String userCookie=null;
		String userHiddenCookie=null;
		Integer versionCookie=null;
		if(cookies!=null){
			for (Cookie cookie : cookies) {
				//明文用户信息cookie
				if (WCurrentUserUtil.COOKIE_USERINFO_KEY.equals(cookie.getName())) {
					try {
						userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}
				}
				//密文用户信息cookie
				if(WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY.equals(cookie.getName())) {
					try {
						userHiddenCookie= URLDecoder.decode(cookie.getValue(), "UTF-8");
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}
				}
				//版本号
				if(WCurrentUserUtil.COOKIE_VERSION_KEY.equals(cookie.getName())){
					versionCookie= Integer.valueOf(cookie.getValue());
				}
			}
		}
		if(userCookie!=null){
			String userCookieStr = String.valueOf(userCookie);
			String tokenOri = userCookieStr + WCurrentUserUtil.COOKIEPK;
			String token = MD5UtilNew.getMD5String(tokenOri);
			if(token.equals(userHiddenCookie)&&versionCookie==WCurrentUserUtil.COOKIE_VERSION){
				JSONObject json=JSONObject.fromObject(userCookieStr);
				if(!json.has("isSuperPwd")) {
					return false;
				}
				String isSuperPwd = json.getString("isSuperPwd");
				return isSuperPwd != null && isSuperPwd.equals("1");
			}
		}
		return false;
	}
}
