/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.AccessToken;
import com.cxqm.xiaoerke.common.bean.CustomBean;
import com.cxqm.xiaoerke.common.bean.JsApiTicket;
import com.cxqm.xiaoerke.common.bean.ShortUrlCreate;
import com.cxqm.xiaoerke.common.bean.WechatRecord;
import com.cxqm.xiaoerke.common.utils.CookieUtils;
import com.cxqm.xiaoerke.common.utils.EmojiFilter;
import com.cxqm.xiaoerke.common.utils.HttpRequestUtil;
import com.cxqm.xiaoerke.common.utils.JsonUtil;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.sys.entity.Article;
import com.cxqm.xiaoerke.modules.sys.entity.SysPropertyVoWithBLOBsVo;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.utils.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class WechatUtil {
    public static String getToken(String corpid, String sectet) throws IOException {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + corpid + "&secret=" + sectet + "";
        String content = HttpRequestUtil.get(url);
        AccessToken token = JsonUtil.getObjFromJsonStr(content, AccessToken.class);
        System.out.println("token:" + content);
        return token.getaccess_token();
    }

    public static String getJsapiTicket(String token) throws IOException {
        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + token + "&type=jsapi";
        String content = HttpRequestUtil.get(url);
        System.out.println("ticket:" + content);
        JsApiTicket ticket = JsonUtil.getObjFromJsonStr(content, JsApiTicket.class);
        return ticket.getTicket();
    }

    public static String getOauth2Url(String type, String backUrl, SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo) {
        backUrl = WechatUtil.urlEncodeUTF8(backUrl);
        if (type.equals("user")) {
            return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + sysPropertyVoWithBLOBsVo.getUserCorpid() + "&redirect_uri=" + backUrl + "&response_type=code&scope=snsapi_base&connect_redirect=1#wechat_redirect";
        }
        if (type.equals("doctor")) {
            return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + sysPropertyVoWithBLOBsVo.getDoctorCorpid() + "&redirect_uri=" + backUrl + "&response_type=code&scope=snsapi_base&connect_redirect=1#wechat_redirect";
        }
        return null;
    }

    public static String urlEncodeUTF8(String source) {
        String result = source;
        try {
            result = URLEncoder.encode(source, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getCustom(String accessToken, long endtime, Long starttime, int pageIndex, int pagesize) {
        String url = " https://api.weixin.qq.com/customservice/msgrecord/getrecord?access_token=" + accessToken;
        JSONObject json = new JSONObject();
        json.put("endtime", endtime);
        json.put("pageindex", pageIndex);
        json.put("pagesize", pagesize);
        json.put("starttime", (Object)starttime);
        String request = HttpRequestUtil.getConnectionResult(url, "POST", json.toString());
        System.out.println("request:" + request);
        return request;
    }

    public static void setWechatInfoToDb(String dateTime, String accessToken, int pageIndex, List<WechatRecord> li) {
        long startTime = (new Date().getTime() - 1800000L) / 1000L;
        long endTime = new Date().getTime() / 1000L;
        String request = WechatUtil.getCustom(accessToken, endTime, startTime, pageIndex, 30);
        JSONObject resultJson = new JSONObject(request);
        JSONArray array = resultJson.getJSONArray("recordlist");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jo = (JSONObject)array.get(i);
            String openid = (String)jo.get("openid");
            Integer opercode = (Integer)jo.get("opercode");
            Integer time = (Integer)jo.get("time");
            String worker = (String)jo.get("worker");
            String text = (String)jo.get("text");
            Long timestamp = Long.parseLong(time.toString()) * 1000L;
            Date date = new Date(timestamp);
            text = EmojiFilter.filterEmoji(text);
            Long times = Long.parseLong(time.toString()) * 1000L;
            Date dates = new Date(times);
            Timestamp tt = new Timestamp(dates.getTime());
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            WechatRecord record = new WechatRecord();
            record.setId(uuid);
            record.setOpenid(openid);
            record.setinfoTime(tt);
            record.setOpercode(opercode + "");
            record.setText(text);
            record.setWorker(worker);
            li.add(record);
        }
        if (array.length() > 0) {
            WechatUtil.setWechatInfoToDb(dateTime, accessToken, pageIndex + 1, li);
        }
    }

    public static ArrayList<CustomBean> getcustomInfo(String token) {
        String url = "https://api.weixin.qq.com/cgi-bin/customservice/getonlinekflist?access_token=" + token;
        String json = HttpRequestUtil.getConnectionResult(url, "GET", "");
        JSONObject jsonObj = new JSONObject(json);
        JSONArray subArray = jsonObj.getJSONArray("kf_online_list");
        JSONObject jsonObject = null;
        CustomBean customBean = null;
        ArrayList<CustomBean> list = new ArrayList<CustomBean>();
        for (int i = 0; i < subArray.length(); ++i) {
            customBean = new CustomBean();
            jsonObject = subArray.getJSONObject(i);
            customBean.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            customBean.setKf_account(jsonObject.getString("kf_account"));
            customBean.setStatus(String.valueOf(jsonObject.getInt("status")));
            customBean.setKf_id(jsonObject.getString("kf_id"));
            customBean.setAuto_accept(String.valueOf(jsonObject.getInt("auto_accept")));
            customBean.setAccepted_case(String.valueOf(jsonObject.getInt("accepted_case")));
            list.add(customBean);
        }
        return list;
    }

    public static WechatBean getWechatName(String token, String openid) {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + token + "&openid=" + openid + "&lang=zh_CN";
        String json = HttpRequestUtil.getConnectionResult(url, "GET", "");
        return JsonUtil.getObjFromJsonStr(json, WechatBean.class);
    }

    public static String sendMsgToWechat(String token, String openId, String content) {
        LogUtils.saveLog(content, openId);
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + token;
        String result = "failure";
        try {
            JSONObject obj;
            Integer resultStatus;
            String json = "{\"touser\":\"" + openId + "\",\"msgtype\":\"text\",\"text\":{\"content\":\"CONTENT\"}}";
            json = json.replace("CONTENT", content);
            String re = HttpRequestUtil.getConnectionResult(url, "POST", json);
            System.out.print(json + "--" + re);
            if (re.contains("access_token is invalid")) {
                result = "tokenIsInvalid";
            }
            if ((resultStatus = (Integer)(obj = new JSONObject(re)).get("errcode")) != null && resultStatus == 0) {
                result = "messageOk";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String emoji(int hexEmoji) {
        return String.valueOf(Character.toChars(hexEmoji));
    }

    public static String getOpenId(HttpSession session, HttpServletRequest request) {
        String openId = (String)session.getAttribute("openId");
        if (!StringUtils.isNotNull(openId)) {
            openId = CookieUtils.getCookie(request, "openId");
        }
        return openId;
    }

    public static String post(String strURL, String params, String type) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(type);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            out.append(params);
            out.flush();
            out.close();
            int length = connection.getContentLength();
            InputStream is = connection.getInputStream();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                String result = new String(data, "UTF-8");
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String downloadMediaFromWx(String accessToken, String mediaId, String messageType, SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo) throws IOException {
        if (StringUtils.isEmpty((CharSequence)accessToken) || StringUtils.isEmpty((CharSequence)mediaId)) {
            return "";
        }
        Long picLen = 0L;
        InputStream inputStream = null;
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=" + accessToken + "&media_id=" + mediaId;
        try {
            URL urlGet = new URL(url);
            HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
            inputStream = http.getInputStream();
            picLen = http.getContentLengthLong();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mediaName = mediaId;
        if (messageType.contains("image")) {
            mediaName = mediaName + ".jpg";
        } else if (messageType.contains("voice")) {
            String mediaNameAmr = mediaName + ".amr";
            String mediaNameMp3 = mediaName + ".mp3";
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            if (sysPropertyVoWithBLOBsVo.getAmrTomp3Func().equals("windows")) {
                FileOutputStream fos = new FileOutputStream(sysPropertyVoWithBLOBsVo.getAmrTomp3Windowspathtemp() + mediaNameAmr);
                byte[] buf = new byte[8096];
                int size = 0;
                while ((size = bis.read(buf)) != -1) {
                    fos.write(buf, 0, size);
                }
                fos.close();
                bis.close();
                WechatUtil.ToMp3(sysPropertyVoWithBLOBsVo.getAmrTomp3Windowspath(), sysPropertyVoWithBLOBsVo.getAmrTomp3Windowspathtemp() + mediaName, sysPropertyVoWithBLOBsVo);
                inputStream = new FileInputStream(new File(sysPropertyVoWithBLOBsVo.getAmrTomp3Windowspathtemp() + mediaNameMp3));
                StringUtils.deleteFile(new File(sysPropertyVoWithBLOBsVo.getAmrTomp3Windowspathtemp()));
            } else if (sysPropertyVoWithBLOBsVo.getAmrTomp3Func().equals("linux")) {
                FileOutputStream fos = new FileOutputStream(sysPropertyVoWithBLOBsVo.getAmrTomp3Linuxpath() + mediaNameAmr);
                byte[] buf = new byte[8096];
                int size = 0;
                while ((size = bis.read(buf)) != -1) {
                    fos.write(buf, 0, size);
                }
                fos.close();
                bis.close();
                WechatUtil.ToMp3(sysPropertyVoWithBLOBsVo.getAmrTomp3Windowspath(), sysPropertyVoWithBLOBsVo.getAmrTomp3Linuxpath() + mediaName, sysPropertyVoWithBLOBsVo);
                inputStream = new FileInputStream(new File(sysPropertyVoWithBLOBsVo.getAmrTomp3Linuxpath() + mediaNameMp3));
                StringUtils.deleteFile(new File(sysPropertyVoWithBLOBsVo.getAmrTomp3Linuxpath()));
            }
            mediaName = mediaNameMp3;
        } else if (messageType.contains("video")) {
            mediaName = mediaName + ".mp4";
        }
        OSSObjectTool.uploadFileInputStream(mediaName, picLen, inputStream, OSSObjectTool.BUCKET_CONSULT_PIC);
        String mediaURL = OSSObjectTool.getConsultMediaBaseUrl() + mediaName;
        return mediaURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ToMp3(String webroot, String sourcePath, SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo) {
        String targetPath = sourcePath + ".mp3";
        Runtime run = null;
        try {
            run = Runtime.getRuntime();
            long start = System.currentTimeMillis();
            String path = "";
            if (sysPropertyVoWithBLOBsVo.getAmrTomp3Func().equals("windows")) {
                path = webroot + "ffmpeg -i " + sourcePath + ".amr -acodec libmp3lame " + targetPath;
            } else if (sysPropertyVoWithBLOBsVo.getAmrTomp3Func().equals("linux")) {
                path = "ffmpeg -i " + sourcePath + ".amr -acodec libmp3lame " + targetPath;
            }
            Process p = run.exec(path);
            p.getOutputStream().close();
            p.getInputStream().close();
            p.getErrorStream().close();
            p.waitFor();
            long end = System.currentTimeMillis();
            System.out.println(sourcePath + " convert success, costs:" + (end - start) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            run.freeMemory();
        }
    }

    public static String getShortUrl(String accessToken, String longUrl) {
        String url = "https://api.weixin.qq.com/cgi-bin/shorturl?access_token=" + accessToken;
        ShortUrlCreate shortUrlCreate = new ShortUrlCreate();
        shortUrlCreate.setAction("long2short");
        shortUrlCreate.setLong_url(longUrl);
        String object = HttpRequestUtil.httpsRequest(url, "POST", net.sf.json.JSONObject.fromObject((Object)shortUrlCreate).toString());
        JSONObject resultJson = new JSONObject(object);
        String shortUrl = resultJson == null ? "" : (String)resultJson.get("short_url");
        return shortUrl;
    }

    public static void sendNoTextMsgToWechat(String token, String openId, String content, int msgType) {
        String type = null;
        type = msgType == 1 ? "image" : (msgType == 2 ? "voice" : "video");
        String sendUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + token;
        String json = "{\"touser\": \"" + openId + "\",\"msgtype\": \"" + type + "\", \"" + type + "\": {\"media_id\": \"" + content + "\"}}";
        WechatUtil.sendNoTextToWX(sendUrl, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject uploadNoTextMsgToWX(String token, String urlStr, String msgType, String fileName, InputStream inputStream) {
        String upLoadUrl = urlStr + "?access_token=" + token + "&type=" + msgType;
        String result = null;
        BufferedReader reader = null;
        try {
            URL openUrl = new URL(upLoadUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)openUrl.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            String BOUNDARY = "----------" + System.currentTimeMillis();
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"file\";filename=\"" + fileName + "\"\r\n");
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
            byte[] head = sb.toString().getBytes("utf-8");
            DataOutputStream out = new DataOutputStream(httpURLConnection.getOutputStream());
            ((OutputStream)out).write(head);
            DataInputStream in = new DataInputStream(inputStream);
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            in.close();
            byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
            ((OutputStream)out).write(foot);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            StringBuffer buffer = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            System.out.println(buffer.toString());
            if (result == null) {
                result = buffer.toString();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        JSONObject jsonObj = new JSONObject(result);
        return jsonObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadPermanentMedia(String accessToken, File file, String title, String introduction) {
        JSONObject jsonObject;
        block9: {
            JSONObject j = new JSONObject();
            j.put("title", (Object)title);
            j.put("introduction", (Object)introduction);
            String uploadMediaUrl = "http://api.weixin.qq.com/cgi-bin/material/add_material?access_token=##ACCESS_TOKEN##";
            uploadMediaUrl = uploadMediaUrl.replace("##ACCESS_TOKEN##", accessToken);
            URL url = new URL(uploadMediaUrl);
            String result = null;
            long filelength = file.length();
            String fileName = file.getName();
            String suffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
            String type = "video/mp4";
            type = "image";
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Connection", "Keep-Alive");
            con.setRequestProperty("Charset", "UTF-8");
            String BOUNDARY = "----------" + System.currentTimeMillis();
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"type\" \r\n\r\n");
            sb.append(type + "\r\n");
            if (!"".equals(title) && !"".equals(introduction)) {
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"description\" \r\n\r\n");
                sb.append(j.toString() + "\r\n");
            }
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"media\";filename=\"" + fileName + "\";filelength=\"" + filelength + "\" \r\n");
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
            System.out.println(sb.toString());
            byte[] head = sb.toString().getBytes("utf-8");
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            ((OutputStream)out).write(head);
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            in.close();
            byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
            ((OutputStream)out).write(foot);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            if (result == null) {
                result = buffer.toString();
            }
            if (!(jsonObject = new JSONObject(result)).has("media_id")) break block9;
            System.out.println("media_id:" + jsonObject.getString("media_id"));
            String string = jsonObject.getString("media_id");
            return string;
        }
        try {
            System.out.println(jsonObject.toString());
            System.out.println("json:" + jsonObject.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String sendNoTextToWX(String sendUrl, String json) {
        String reResult = null;
        try {
            URL sendWXUser = new URL(sendUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)sendWXUser.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Accept", "application/json");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            OutputStream os = httpURLConnection.getOutputStream();
            os.write(json.getBytes("UTF-8"));
            os.flush();
            os.close();
            InputStream is = httpURLConnection.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            reResult = new String(jsonBytes, "UTF-8");
            System.out.println("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c:" + reResult);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reResult;
    }

    public static void senImgMsgToWechat(String token, String openId, List<Article> articleList) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + token;
        try {
            String newStr = "";
            for (Article article : articleList) {
                newStr = newStr + "{\"title\":\"" + article.getTitle() + "\",\"description\":\"" + article.getDescription() + "\",\"url\":\"" + article.getUrl() + "\",\"picurl\":\"" + article.getPicUrl() + "\"},";
            }
            String json = "{\"touser\":\"" + openId + "\",\"msgtype\":\"news\",\"news\":{\"articles\":[" + newStr + "]}";
            String string = HttpRequestUtil.getConnectionResult(url, "POST", json.substring(0, json.length() - 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String sendTemplateMsgToUser(String token, String openId, String templateId, String content) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + token;
        String result = "failure";
        try {
            Integer resultStatus;
            String json = "{\"touser\":\"" + openId + "\",\"template_id\":\"" + templateId + "\",\"url\":\"\",\"data\":{" + content + "}}";
            String re = HttpRequestUtil.getConnectionResult(url, "POST", json);
            System.out.print(json + "--" + re);
            JSONObject jsonObject = new JSONObject(re);
            if (re.contains("access_token is invalid")) {
                result = "tokenIsInvalid";
            }
            if ((resultStatus = (Integer)jsonObject.get("errcode")) != null && resultStatus == 0) {
                result = "messageOk";
                System.out.println("------" + resultStatus);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        String token = "qUjyIaqq5GemBwRXeg5bw0MIIRycQ9RowiUJXy6zA9ONIUWW0o1rpHkppiSFvIoSTJvfO-6sCGIpv7y01dpAsCX6zyZ_8qViFI-EjeIQBi6JKSv72HnmGYLqAJt7N8TLLMDeACAQRI";
        String openid = "oogbDwCLH1_x-KLcQKqlrmUzG2ng";
        String content = "VqbZoh6NyIk5kmVZ0AVT-BMQDAenOeQyZ5GfbLrbAhE";
        WechatUtil.sendNoTextMsgToWechat(token, openid, content, 1);
    }
}

