package com.cxqm.xiaoerke.common.filter;

import com.cxqm.xiaoerke.common.config.Global;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;

/**
 * Created by sunzb on 16/12/22.
 */
public class LoadProjectPath implements ServletContextListener{

	private static String baseUrl;

	@Override
	public void contextDestroyed(ServletContextEvent arg0) {

	}

	@Override
	public void contextInitialized(ServletContextEvent event) {
		loadProjectPath(event);
	}

	public void loadProjectPath(ServletContextEvent event){
		String baseUrl = Global.getConfig("baseUrl");
		LoadProjectPath.baseUrl = baseUrl;
	}
	public static String getHTTPUrlByScheme(String url) {
		if (url == null) {
			return url;
		}

		if (url.startsWith("http://")) {
			return url;
		}

		if (url.startsWith("https://")) {
			url = url.substring(8);
		}

		return "http://" + url;
	}
	public static boolean isHttps(HttpServletRequest request) {
		if (request == null) {
			RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
			if (requestAttributes != null) {
				request = ((ServletRequestAttributes) requestAttributes).getRequest();
			}
		}

		if (request != null) {
			String proxyScheme = request.getHeader("proxy_protocol");
			if (proxyScheme != null && proxyScheme.equals("https")) {
				return true;
			}
		}
		return false;
	}


	public static String getScheme(HttpServletRequest request) {
		boolean isHttps = isHttps(request);
		return isHttps ? "https" : "http";
	}

	/**
	 * 经过nginx的https代理之后，请求头中会有一个proxy_protocol（需要在nginx中设置）
	 * @param request
	 * @param url
	 * @return
	 */
	public static String getUrlByScheme(HttpServletRequest request, String url) {
		return createUrl(isHttps(request), url);
	}

	public static String createUrl(boolean useHttps, String url) {
		if (url == null) {
			url = "";
		} else {
			if (url.startsWith("http://")) {
				url = url.substring(7);
			}
			if (url.startsWith("https://")) {
				url = url.substring(8);
			}
		}

		return (useHttps?"https":"http") + "://" + url;
	}

	public static String getBaseurl(HttpServletRequest request) {
		return getUrlByScheme(request, LoadProjectPath.baseUrl);
	}

	public static String getBaseurl(boolean useHttps) {
		return createUrl(useHttps, LoadProjectPath.baseUrl);
	}
}
