package com.cxqm.xiaoerke.common.web;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.utils.ResponseMapBuilder;
import net.sf.json.JSONObject;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public class JsonpUtils {
	public interface ControllerDelegate {
		Map delegate();
	}

	public static String getResultForJsonp(String callback, ControllerDelegate delegate) {
		Map resultMap = null;
		try {
			resultMap = delegate.delegate();
		} catch (BusinessException e) {
			resultMap = ResponseMapBuilder.newBuilder()
					.putBusinessException(e)
					.getResult();
		}
		return getByMap(callback, resultMap);
	}

	public static String getResultForJsonp(HttpServletRequest request, ControllerDelegate delegate) {
		String callback = request.getParameter("callback");
		return getResultForJsonp(callback, delegate);
	}

	public static String getByMap(String callback, Map<String,Object> result){
		String strRes = JSONObject.fromObject(result).toString();
		strRes = callback + "(" + strRes + ")";
		return strRes;
	}
}
