package com.cxqm.xiaoerke.common.filter;

import java.util.HashMap;

/**
 * Created by sunzb on 2017/12/8.
 */
public class DMUserInfo {

    private static ThreadLocal<HashMap<String, Object>> threadLocals = new ThreadLocal<HashMap<String, Object>>();


    public static final String CURRENT_DUSER = "CURRENT_DUSER";
    public static final String CURRENT_WEIXIN_DUSER = "CURRENT_WEIXIN_DUSER";

    /**
     * 取得线程变量值
     *
     * @param name
     *            线程变量名
     * @return 线程变量值
     */
    public static Object getValue(String name) {

        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap<String, Object>());
        }
        return threadLocals.get().get(name);
    }

    /**
     * 获取医生信息
     * @param <T>
     * @return
     */
    public static <T> T getDoctorInfo(){

        return (T)getValue(CURRENT_DUSER);
    }

    /**
     * 获取医生微信信息
     * @param <T>
     * @return
     */
    public static <T> T getDoctorWechatInfo(){

        return (T)getValue(CURRENT_WEIXIN_DUSER);
    }

    /**
     * 存入医生信息
     * @param t
     * @param <T>
     */
    public static <T> void setDoctorInfo(T t){

        setValue(CURRENT_DUSER,t);
    }

    /**
     * 存入医生微信信息
     * @param t
     * @param <T>
     */
    public static <T> void setDoctorWechatInfo(T t){

        setValue(CURRENT_WEIXIN_DUSER,t);
    }

    /**
     * 设置线程变量值
     *
     * @param name
     *            线程变量名
     * @param value
     *            线程变量值
     */
    public static void setValue(String name, Object value) {

        //清空另一个线程用户配置线程
        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap<String, Object>());
        }
        threadLocals.get().put(name, value);
    }

    public static void clearDUserInfoValue(){

        DMUserInfo.setValue(DMUserInfo.CURRENT_DUSER,"");
    }

    public static void clearDUserWechatInfoValue(){

        DMUserInfo.setValue(DMUserInfo.CURRENT_WEIXIN_DUSER,"");
    }

    public static void removeValue(String name) {

        if (threadLocals.get() == null) {
            return;
        }
        threadLocals.get().remove(name);
    }

    public static void clear() {

        if (threadLocals.get() != null) {
            threadLocals.get().clear();
        }
    }

}
