package com.cxqm.xiaoerke.common.filter;

import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;

import java.util.HashMap;

/**
 * Created by sunzb on 16/12/23.
 */
public class MUserInfo {

	private static ThreadLocal<HashMap<String, Object>> threadLocals = new ThreadLocal<HashMap<String, Object>>();


	public static final String CURRENT_USER = "CURRENT_USER";
	public static final String CURRENT_WEIXIN_USER = "CURRENT_WEIXIN_USER";

	/**
	 * 取得线程变量值
	 *
	 * @param name
	 *            线程变量名
	 * @return 线程变量值
	 */
	public static Object getValue(String name) {
		if (threadLocals.get() == null) {
			threadLocals.set(new HashMap<String, Object>());
		}
		return threadLocals.get().get(name);
	}

	/**
	 * 设置线程变量值
	 *
	 * @param name
	 *            线程变量名
	 * @param value
	 *            线程变量值
	 */
	public static void setValue(String name, Object value) {
		//清空另一个线程用户配置线程
		if (threadLocals.get() == null) {
			threadLocals.set(new HashMap<String, Object>());
		}
		threadLocals.get().put(name, value);
	}

	public static void setUserInfoValue(User user){
		MUserInfo.setValue(MUserInfo.CURRENT_USER,user);
	}

	public static User getUserInfoValue(){
		return (User)MUserInfo.getValue(MUserInfo.CURRENT_USER);
	}

	public static void setWeiXinUserInfoValue(WechatUserInfo info){
		MUserInfo.setValue(MUserInfo.CURRENT_WEIXIN_USER,info);
	}

	public static WechatUserInfo getWeiXinUserInfoValue(){
		return (WechatUserInfo)MUserInfo.getValue(MUserInfo.CURRENT_WEIXIN_USER);
	}

	public static void clearWeiXinUserInfoValue(){
		MUserInfo.setValue(MUserInfo.CURRENT_WEIXIN_USER,"");
	}

	public static void removeValue(String name) {
		if (threadLocals.get() == null) {
			return;
		}
		threadLocals.get().remove(name);
	}

	public static void clear() {
		if (threadLocals.get() != null) {
			threadLocals.get().clear();
		}
	}
}
