package com.cxqm.xiaoerke.common.utils;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.*;
import com.cxqm.xiaoerke.common.config.Global;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.springframework.web.multipart.MultipartFile;

/**
 * oss 工具类
 * @author ft
 *
 */
public class OSSObjectTool {
    private static  OSSClient ossClient = null;
	public static String BUCKET_BASE_HOST = null;
    public static String BUCKET_DOCTOR_PIC = null;
    public static String BUCKET_ARTICLE_PIC = null;
	public static String BUCKET_CONSULT_PIC = null;
	public static String BUCKET_COMMON_PIC = null;
	public static String BUCKET_CASE_PIC = null;
	public static String BUCKET_BACKEND_PIC = null;
    static {
        String accesskey = Global.getConfig("aliyun.accesskey");
        String secret =  Global.getConfig("aliyun.secret");
        String host =  Global.getConfig("oss.host");
        BUCKET_DOCTOR_PIC = Global.getConfig("oss.bucket.doctor.pic");
        BUCKET_ARTICLE_PIC = Global.getConfig("oss.bucket.article.pic");
        BUCKET_CONSULT_PIC = Global.getConfig("oss.bucket.consult.pic");
		BUCKET_COMMON_PIC = Global.getConfig("oss.bucket.common.pic");
		BUCKET_CASE_PIC = Global.getConfig("oss.bucket.case.pic");
		BUCKET_BASE_HOST = Global.getConfig("oss.bucket.basehost");
		BUCKET_BACKEND_PIC = Global.getConfig("oss.bucket.backend.pic");
        ossClient = new  OSSClient(host,accesskey, secret);
    }

    /**
     * 上传文件到oss
     * @param key
     * @param length
     * @param in
     * @param bucket
     * @return key
     * @throws OSSException
     * @throws ClientException
     * @throws FileNotFoundException
     */
    public static String uploadFileInputStream(String key, Long length ,InputStream in, String bucket) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(length);
        new HashMap<String,String>();
        ossClient.putObject(bucket, key , in, objectMeta);
        return key;
    }

	public static String uploadFileByUrl(String bucket, String key, String url) throws IOException {
		InputStream inputStream = new URL(url).openStream();
		ossClient.putObject(bucket, key, inputStream);
		return key;
	}

	public static String routeImage(String bucket, String key, Integer route) throws IOException {
		String finalKey = getTouteName(key, route);
		String finalUrl = getUrl(finalKey, bucket);
		uploadFileByUrl(bucket, key, finalUrl);
		return key;
	}

	public static String uploadFileByMultipartFile(String key, MultipartFile file, String bucket) throws IOException {
		if (file==null){
			return null;
		}

		String ext = getExtname(file);

		long length = file.getSize();

		String resultKey = OSSObjectTool.uploadFileInputStream((key == null ? IdGen.uuid()+ext : key), length, file.getInputStream(), bucket);

		file.getInputStream().close();
		return resultKey;
	}
	public static String getExtname(MultipartFile file){
		String contentType = file.getContentType();
		MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
		String ext = "";
		try {
			MimeType mimeType = allTypes.forName(contentType);
			ext = mimeType.getExtension();
			if (ext == null || ext.trim().length() == 0) {
				int lastPointIndex = file.getOriginalFilename().lastIndexOf('.');
				if (lastPointIndex > 0) {
					ext = file.getOriginalFilename().substring(lastPointIndex);
				}
			}
		} catch (MimeTypeException e) {
			ext = ".jpg";
		}
		return ext;
	}
	/**
	 * 获取素材完整路径
	 * @param key
	 * @param bucket
	 * @return
	 */
	public static String getUrl(String key, String bucket) {
		return String.format("http://%s.%s/%s", bucket, BUCKET_BASE_HOST, key);
	}

    /**
     * 获取医生头像的 base url, 注 base url + key = full url
     * @return
     */
    public static String getDoctorPicBaseUrl(){
        return "http://xiaoerke-doctor-pic.oss-cn-beijing.aliyuncs.com/";
    }

    public static String getConsultMediaBaseUrl(){
        http://xiaoerke-common-pic.oss-cn-beijing.aliyuncs.com/
        return "http://xiaoerke-common-pic.oss-cn-beijing.aliyuncs.com/";
    }

    public static Map<String,String> getObject(String bucketName, String key)
            throws OSSException, ClientException, FileNotFoundException {
        //OSSObject ossObject = ossClient.getObject(bucketName, key);
        return null;
    }

    public static void main(String[] args) throws Exception {
		String  newFolder = "abc/def";
		boolean found = ossClient.doesObjectExist("junhaoyun-backend", newFolder);

		ossClient.putObject("junhaoyun-backend", newFolder, new ByteArrayInputStream(new byte[0]));
		System.out.println(found);
	}
	public static List<String> getChildFolders(String bucket,String currentFolder){
		List<String> folders = new ArrayList<String>();
		// 构造ListObjectsRequest请求
		ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket);
		listObjectsRequest.setDelimiter("/");
		if (currentFolder.startsWith("/")) {
			listObjectsRequest.setPrefix(currentFolder.substring(1));
		} else {
			listObjectsRequest.setPrefix(currentFolder);
		}

		ObjectListing listing = ossClient.listObjects(listObjectsRequest);
		for (String commonPrefix : listing.getCommonPrefixes()) {
			folders.add(commonPrefix.replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"));
		}
		return folders;
	}
	public static List<OSSFile> getChildFiles(String bucket,String currentFolder){
		List<OSSFile> files = new ArrayList<OSSFile>();
		// 构造ListObjectsRequest请求
		ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket);
// "/" 为文件夹的分隔符
		listObjectsRequest.setDelimiter("/");
// 列出fun目录下的所有文件和文件夹
		listObjectsRequest.setPrefix(currentFolder.substring(1));
		ObjectListing listing = ossClient.listObjects(listObjectsRequest);
// 遍历所有Object
		for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
			if (currentFolder.substring(1).equals(objectSummary.getKey()) && objectSummary.getSize() == 0) {
				continue;
			}
			Long size = null;
			files.add(new OSSFile(objectSummary.getKey().replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"), objectSummary.getLastModified(), objectSummary.getSize()));
		}
		return files;
	}
	public static Boolean createFolder(String bucket,String newFolder){
		boolean found = ossClient.doesObjectExist(bucket, newFolder);
		if (!found){
			ossClient.putObject(bucket, newFolder, new ByteArrayInputStream(new byte[0]));
		}
		return true;
	}
	public static Boolean uploadFile(String bucket,String key,InputStream inputStream){
		ossClient.putObject(bucket, key, inputStream);
		return true;
	}
	public static Boolean renameFile(String bucket,String fromKey,String toKey){
		CopyObjectResult result = ossClient.copyObject(bucket,fromKey,bucket,toKey);
		delFile(bucket,fromKey);
		return true;
	}
	public static Boolean isExists(String bucket,String key){
		return ossClient.doesObjectExist(bucket, key);
	}
	public static Boolean delFile(String bucket,String key){
		if (isExists(bucket, key)){
			ossClient.deleteObject(bucket, key);
		}
		return true;
	}
	public static class OSSFile {
		public OSSFile() {}
		public OSSFile(String fileName, Date lastModified, Long size) {
			this.fileName = fileName;
			this.lastModified = lastModified;
			this.size = size;
		}

		private String fileName;
		private Date lastModified;
		private Long size;

		public String getFileName() {
			return fileName;
		}

		public void setFileName(String fileName) {
			this.fileName = fileName;
		}

		public Date getLastModified() {
			return lastModified;
		}

		public void setLastModified(Date lastModified) {
			this.lastModified = lastModified;
		}

		public Long getSize() {
			return size;
		}

		public void setSize(Long size) {
			this.size = size;
		}
	}

	/**
	 * 根据aliyun规则，获取旋转后的图片名
	 * @param fileName
	 * @param angle
	 * @return
	 */
	public static String getTouteName(String fileName, Integer angle) {
		if (fileName == null) {
			return null;
		}
		if (angle == null) {
			return fileName;
		}
		return fileName + "?x-oss-process=image/resize,m_lfit,w_4096,h_4096,limit_1/auto-orient,0/rotate," + angle;
	}
}
