/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.interceptor;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.utils.CacheUtils;
import com.cxqm.xiaoerke.common.utils.CookieUtils;
import com.cxqm.xiaoerke.common.utils.Exceptions;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.sys.dao.LogDao;
import com.cxqm.xiaoerke.modules.sys.dao.MenuDao;
import com.cxqm.xiaoerke.modules.sys.entity.Log;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.MongoLog;
import com.cxqm.xiaoerke.modules.sys.interceptor.SystemControllerLog;
import com.cxqm.xiaoerke.modules.sys.interceptor.SystemServiceLog;
import com.cxqm.xiaoerke.modules.sys.service.LogMongoDBServiceImpl;
import com.cxqm.xiaoerke.modules.sys.service.MongoDBService;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

@Aspect
@Component
public class SystemLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(SystemLogAspect.class);
    public static final String CACHE_MENU_NAME_PATH_MAP = "menuNamePathMap";
    private static MongoDBService<MongoLog> mongoDBService = SpringContextHolder.getBean(LogMongoDBServiceImpl.class);
    private static LogDao logDao = SpringContextHolder.getBean(LogDao.class);
    private static MenuDao menuDao = SpringContextHolder.getBean(MenuDao.class);
    private static String mongoEnabled = Global.getConfig("mongo.enabled");
    private static ExecutorService threadExecutor = Executors.newCachedThreadPool();

    @Pointcut(value="@annotation(com.cxqm.xiaoerke.modules.sys.interceptor.SystemServiceLog)")
    public void serviceAspect() {
    }

    @Pointcut(value="@annotation(com.cxqm.xiaoerke.modules.sys.interceptor.SystemControllerLog)")
    public void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        try {
            String title = SystemLogAspect.getControllerMethodDescription(joinPoint);
            SystemLogAspect.saveLog(request, null, null, title);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Before(value="serviceAspect()")
    public void doBeforeService(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        try {
            String title = SystemLogAspect.getServiceMethodDescription(joinPoint);
            SystemLogAspect.saveLog(request, null, null, title);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @AfterThrowing(pointcut="serviceAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        try {
            String title = SystemLogAspect.getServiceMethodDescription(joinPoint);
            SystemLogAspect.saveLog(request, null, null, title);
        }
        catch (Exception e1) {
            logger.error(e.getMessage());
        }
    }

    public static String getServiceMethodDescription(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String description = "";
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            description = method.getAnnotation(SystemServiceLog.class).description();
            break;
        }
        return description;
    }

    public static String getControllerMethodDescription(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String description = "";
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            description = method.getAnnotation(SystemControllerLog.class).description();
            break;
        }
        return description;
    }

    public static void saveLog(HttpServletRequest request, Object handler, Exception ex, String title) {
        String openId = (String)request.getSession().getAttribute("openId");
        Log log = new Log();
        log.setTitle(title);
        log.setType(ex == null ? "1" : "2");
        log.setRemoteAddr(StringUtils.getRemoteAddr(request));
        log.setUserAgent(request.getHeader("user-agent"));
        log.setRequestUri(request.getRequestURI());
        log.setParams(request.getParameterMap());
        log.setMethod(request.getMethod());
        log.setOpenId(openId);
        log.setUserId(UserUtils.getUser().getId());
        if (StringUtils.isNull(openId)) {
            log.setOpenId(CookieUtils.getCookie(request, "openId"));
        }
        SaveLogThread thread = new SaveLogThread(log, handler, ex);
        threadExecutor.execute(thread);
    }

    public static String getMenuNamePath(String requestUri, String permission) {
        String menuNamePath;
        String href = StringUtils.substringAfter((String)requestUri, (String)Global.getAdminPath());
        Map menuMap = (Map)CacheUtils.get(CACHE_MENU_NAME_PATH_MAP);
        if (menuMap == null) {
            menuMap = Maps.newHashMap();
            List<Menu> menuList = menuDao.findAllList(new Menu());
            for (Menu menu : menuList) {
                String namePath = "";
                if (menu.getParentIds() != null) {
                    String[] namePathList = Lists.newArrayList();
                    String[] stringArray = StringUtils.split((String)menu.getParentIds(), (String)",");
                    int n = stringArray.length;
                    block1: for (int i = 0; i < n; ++i) {
                        String id = stringArray[i];
                        if (Menu.getRootId().equals(id)) continue;
                        for (Menu m : menuList) {
                            if (!m.getId().equals(id)) continue;
                            namePathList.add(m.getName());
                            continue block1;
                        }
                    }
                    namePathList.add(menu.getName());
                    namePath = StringUtils.join((Iterable)namePathList, (String)"-");
                }
                if (StringUtils.isNotBlank((CharSequence)menu.getHref())) {
                    menuMap.put(menu.getHref(), namePath);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)menu.getPermission())) continue;
                for (String p : StringUtils.split((String)menu.getPermission())) {
                    menuMap.put(p, namePath);
                }
            }
            CacheUtils.put(CACHE_MENU_NAME_PATH_MAP, menuMap);
        }
        if ((menuNamePath = (String)menuMap.get(href)) == null) {
            Object p;
            String[] stringArray = StringUtils.split((String)permission);
            int n = stringArray.length;
            for (int i = 0; i < n && !StringUtils.isNotBlank((CharSequence)(menuNamePath = (String)menuMap.get(p = stringArray[i]))); ++i) {
            }
            if (menuNamePath == null) {
                return "";
            }
        }
        return menuNamePath;
    }

    public static class SaveLogThread
    extends Thread {
        private Log log;
        private Object handler;
        private Exception ex;

        public SaveLogThread(Log log, Object handler, Exception ex) {
            super(SaveLogThread.class.getSimpleName());
            this.log = log;
            this.handler = handler;
            this.ex = ex;
        }

        @Override
        public void run() {
            if (StringUtils.isBlank((CharSequence)this.log.getTitle())) {
                String permission = "";
                if (this.handler instanceof HandlerMethod) {
                    Method m = ((HandlerMethod)this.handler).getMethod();
                    RequiresPermissions rp = m.getAnnotation(RequiresPermissions.class);
                    permission = rp != null ? StringUtils.join((Object[])rp.value(), (String)",") : "";
                }
                this.log.setTitle(SystemLogAspect.getMenuNamePath(this.log.getRequestUri(), permission));
            }
            this.log.setException(Exceptions.getStackTraceAsString(this.ex));
            if (StringUtils.isNull(this.log.getTitle()) && StringUtils.isNotBlank((CharSequence)this.log.getParams()) && this.log.getParams().split("=").length > 0) {
                this.log.setTitle(this.log.getParams().split("=")[1]);
            }
            this.log.preInsert();
            if ("true".equalsIgnoreCase(mongoEnabled)) {
                MongoLog mongoLog = LogMongoDBServiceImpl.buildMongoLog(this.log);
                mongoDBService.insert(mongoLog);
            }
        }
    }
}

