/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.security;

import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.sys.security.UsernamePasswordToken;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.util.WebUtils;

public class FormAuthenticationFilter
extends org.apache.shiro.web.filter.authc.FormAuthenticationFilter {
    public static final String DEFAULT_CAPTCHA_PARAM = "validateCode";
    public static final String DEFAULT_MOBILE_PARAM = "mobileLogin";
    public static final String DEFAULT_MESSAGE_PARAM = "message";
    public static final String MESSAGE_UNCERTIFIED = "2";
    public static final String MESSAGE_INCORRECT_VERIFYCODE = "0";
    private String captchaParam = "validateCode";
    private String mobileLoginParam = "mobileLogin";
    private String messageParam = "message";

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        if (password == null) {
            password = "";
        }
        boolean rememberMe = this.isRememberMe(request);
        String host = StringUtils.getRemoteAddr((HttpServletRequest)request);
        String captcha = this.getCaptcha(request);
        boolean mobile = this.isMobileLogin(request);
        return new UsernamePasswordToken(username, password.toCharArray(), rememberMe, host, captcha, mobile);
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    public String getMobileLoginParam() {
        return this.mobileLoginParam;
    }

    protected boolean isMobileLogin(ServletRequest request) {
        return WebUtils.isTrue((ServletRequest)request, (String)this.getMobileLoginParam());
    }

    public String getMessageParam() {
        return this.messageParam;
    }

    protected void setFailureAttribute(ServletRequest request, AuthenticationException ae) {
        request.setAttribute(this.getFailureKeyAttribute(), (Object)ae.getClass().getName());
        if (ae.getMessage() != null && StringUtils.startsWith((CharSequence)ae.getMessage(), (CharSequence)"msg:")) {
            String message = StringUtils.replace((String)ae.getMessage(), (String)"msg:", (String)"");
            request.setAttribute(this.getMessageParam(), (Object)message);
        }
    }

    public String getSuccessUrl() {
        return super.getSuccessUrl();
    }

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response) throws Exception {
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.getSuccessUrl(), null, (boolean)true);
    }
}

