package com.cxqm.xiaoerke.common.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.util.UriUtils;

import com.cxqm.xiaoerke.common.config.Global;

/**
 * 查看CK上传的图片
 * @author ThinkGem
 * @version 2014-06-25
 */
public class UserfilesDownloadServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;
	private Logger logger = LoggerFactory.getLogger(getClass());

	public void fileOutputStream(HttpServletRequest req, HttpServletResponse resp) 
			throws ServletException, IOException {
		String filepath = req.getRequestURI();
		int index = filepath.indexOf(Global.USERFILES_BASE_URL);
		if(index >= 0) {
			filepath = filepath.substring(index + Global.USERFILES_BASE_URL.length());
		}
		try {
			filepath = UriUtils.decode(filepath, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			logger.error(String.format("解释文件路径失败，URL地址为%s", filepath), e1);
		}
		File file = new File(Global.getUserfilesBaseDir() + Global.USERFILES_BASE_URL + filepath);
		try {
			FileCopyUtils.copy(new FileInputStream(file), resp.getOutputStream());
			resp.setHeader("Content-Type", "application/octet-stream");
			return;
		} catch (FileNotFoundException e) {
			req.setAttribute("exception", new FileNotFoundException("请求的文件不存在"));
			req.getRequestDispatcher("/WEB-INF/views/error/404.jsp").forward(req, resp);
		}
	}



	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		String filepath = req.getRequestURI();
		int index = filepath.indexOf(Global.USERFILES_BASE_URL);
		if(index >= 0) {
			filepath = filepath.substring(index + Global.USERFILES_BASE_URL.length());
		}
		try {
			filepath = UriUtils.decode(filepath, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			logger.error(String.format("解释文件路径失败，URL地址为%s", filepath), e1);
		}
		String[] dirs = filepath.split("/");
		boolean isThumbs = false;
		if (dirs.length >= 2) {
			String fileName = dirs[dirs.length - 1];
			String afterPoint = fileName;
			int pointIndex = fileName.indexOf('.');
			if (pointIndex >= 0) {
				afterPoint = fileName.substring(pointIndex);
			}
			if (afterPoint.indexOf("-") >= 0 || afterPoint.indexOf("_") >= 0 || afterPoint.indexOf("!") >= 0 || afterPoint.indexOf("/") >= 0) {
				// 说明调用者制定了某种样式，此时系统认为这个样式覆盖_thumbs逻辑
				filepath = removeIndexOneAndJoin(dirs);
			} else if (dirs[1].equals("_thumbs")) {
				isThumbs = true;
				filepath = removeIndexOneAndJoin(dirs);
			}

		}
		if (isThumbs) {
			filepath = filepath + "-thumbs";
		}

		resp.sendRedirect(OSSObjectTool.getUrl(filepath, OSSObjectTool.BUCKET_BACKEND_PIC));

//		fileOutputStream(req, resp);
	}

	private String removeIndexOneAndJoin(String[] dirs) {
		List<String> strings = new ArrayList<String>(Arrays.asList(dirs));
		strings.remove(1);
		dirs = strings.toArray(new String[strings.size()]);
		return StringUtils.join(dirs, "/");
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
//		fileOutputStream(req, resp);
		this.doGet(req, resp);
	}
}
