/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.GetUserObjectTypeInterface;
import com.cxqm.xiaoerke.common.bean.ICookieEntity;
import com.cxqm.xiaoerke.common.utils.HttpRequestUtil;
import com.cxqm.xiaoerke.common.utils.JsonUtil;
import com.cxqm.xiaoerke.common.utils.MD5UtilNew;
import com.cxqm.xiaoerke.common.utils.WCurrentUserUtil;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinUtil {
    public static Logger logger = LoggerFactory.getLogger(WeixinUtil.class);
    public static final Integer NOT_JUMP_STATUS = 0;
    public static final Integer JUMP_STATUS = 1;
    public static final Integer JUMP_REGISTER_STATUS = 2;
    public static final String GET_OPENID_BY_CODE = "https://api.weixin.qq.com/sns/oauth2/access_token?";
    public static final String GET_INFO_BY_TOKEN_OPENID = "https://api.weixin.qq.com/sns/userinfo?";
    public static final String GET_CGI_BIN_BY_TOKEN_OPENID = "https://api.weixin.qq.com/cgi-bin/user/info?";

    public static WechatBean getOpenIdByCode(String appid, String secret, String code) {
        String httpReq = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
        String json = HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
        WechatBean wechat = null;
        try {
            wechat = JsonUtil.getObjFromJsonStr(json, WechatBean.class);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362WechatBean\u5931\u8d25", (Throwable)e);
        }
        if (wechat == null || wechat.getOpenid() == null) {
            logger.error(String.format("oauth\u8ba4\u8bc1\u5931\u8d25[%s,%s,%s]\uff1a%s", appid, secret, code, json));
        }
        return wechat;
    }

    public static WechatUserInfo getInfoByAccessTokenOpenId(WechatBean wechat) {
        String httpReq = "https://api.weixin.qq.com/sns/userinfo?access_token=" + wechat.getAccess_token() + "&openid=" + wechat.getOpenid() + "&lang=zh_CN";
        String json = HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
        WechatUserInfo info = null;
        try {
            info = JsonUtil.getObjFromJsonStr(json, WechatUserInfo.class);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362WechatUserInfo\u5931\u8d25", (Throwable)e);
        }
        if (info == null || info.getNickname() == null) {
            logger.error(String.format("oauth\u62c9\u53bb\u7528\u6237\u4fe1\u606f1\u5931\u8d25[%s,%s]\uff1a%s", wechat.getAccess_token(), wechat.getOpenid(), json));
        }
        return info;
    }

    public static WechatUserInfo getCgiBinByAccessTokenOpenId(WechatBean wechat) {
        String httpReq = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + wechat.getAccess_token() + "&openid=" + wechat.getOpenid() + "&lang=zh_CN";
        String json = HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
        WechatUserInfo info = null;
        try {
            info = JsonUtil.getObjFromJsonStr(json, WechatUserInfo.class);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362WechatUserInfo\u5931\u8d25", (Throwable)e);
        }
        if (info == null || info.getNickname() == null) {
            logger.error(String.format("oauth\u62c9\u53bb\u7528\u6237\u4fe1\u606f2\u5931\u8d25[%s,%s]\uff1a%s", wechat.getAccess_token(), wechat.getOpenid(), json));
        }
        return info;
    }

    public static boolean isWeiXin(HttpServletRequest request) {
        return WeixinUtil.isWeiXin(request, null);
    }

    public static boolean isWeiXin(HttpServletRequest request, String ignoreWechatParamName) {
        String uaOri = request.getHeader("user-agent");
        if (uaOri == null) {
            return false;
        }
        String ua = uaOri.toLowerCase();
        if (ua.indexOf("micromessenger") > 0) {
            if (ignoreWechatParamName == null || ignoreWechatParamName.trim().length() == 0) {
                return true;
            }
            String ignore_wechat = request.getParameter(ignoreWechatParamName);
            return ignore_wechat == null || !ignore_wechat.equals("1");
        }
        return false;
    }

    public static User getUserFromCookie(HttpServletRequest request) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        return WeixinUtil.getUserFromCookie(request, WCurrentUserUtil.COOKIE_USERINFO_KEY, WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY, WCurrentUserUtil.COOKIE_VERSION_KEY, WCurrentUserUtil.COOKIEPK, WCurrentUserUtil.COOKIE_VERSION, User.class);
    }

    public static <T> T getUserFromCookie(HttpServletRequest request, String userInfoKey, String userInfoTokenKey, String vserionKey, String cookiePK, Integer cookieVersion, GetUserObjectTypeInterface userInterface) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        return WeixinUtil.getUserFromCookie(request, userInfoKey, userInfoTokenKey, vserionKey, cookiePK, cookieVersion, userInterface, null);
    }

    public static <T extends ICookieEntity> T getUserFromCookie(HttpServletRequest request, String userInfoKey, String userInfoTokenKey, String vserionKey, String cookiePK, Integer cookieVersion, Class<T> t) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        return WeixinUtil.getUserFromCookie(request, userInfoKey, userInfoTokenKey, vserionKey, cookiePK, cookieVersion, null, t);
    }

    private static <T extends ICookieEntity> T getUserFromCookie(HttpServletRequest request, String userInfoKey, String userInfoTokenKey, String vserionKey, String cookiePK, Integer cookieVersion, GetUserObjectTypeInterface userInterface, Class<T> t) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        request.setCharacterEncoding("utf-8");
        Cookie[] cookies = request.getCookies();
        T userEntity = null;
        String userCookie = null;
        String userHiddenCookie = null;
        Integer versionCookie = null;
        if (cookies != null && cookies.length > 0) {
            String userCookieStr;
            String tokenOri;
            String token;
            for (Cookie cookie : cookies) {
                if (userInfoKey.equals(cookie.getName())) {
                    userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                if (userInfoTokenKey.equals(cookie.getName())) {
                    userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                if (!vserionKey.equals(cookie.getName())) continue;
                versionCookie = Integer.valueOf(cookie.getValue());
            }
            if (userCookie != null && (token = MD5UtilNew.getMD5String(tokenOri = (userCookieStr = String.valueOf(userCookie)) + cookiePK)).equals(userHiddenCookie) && versionCookie == cookieVersion) {
                JSONObject json = JSONObject.fromObject((Object)userCookieStr);
                userEntity = WeixinUtil.getPackagingUserCookie(json, t, userInterface);
            }
        }
        return userEntity;
    }

    private static <T extends ICookieEntity> T getPackagingUserCookie(JSONObject json, Class<T> t, GetUserObjectTypeInterface userInterface) throws IllegalAccessException, NoSuchFieldException, InstantiationException {
        if (userInterface == null) {
            return WCurrentUserUtil.getPackagingUserCookie(json, t);
        }
        return (T)((ICookieEntity)userInterface.getUser(json));
    }

    public static WechatUserInfo getWechatUserInfoFromCookie(HttpServletRequest request) throws UnsupportedEncodingException {
        return WeixinUtil.getWechatUserInfoFromCookie(request, WCurrentUserUtil.COOKIE_WEIXIN_USERINFO_KEY, WCurrentUserUtil.COOKIEPK, WCurrentUserUtil.COOKIE_USERINFO_WEIXIN_TOKEN_KEY);
    }

    public static WechatUserInfo getWechatUserInfoFromCookie(HttpServletRequest request, String wechatKey, String wechatPK, String wechatTokenKey) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        Cookie[] cookies = request.getCookies();
        WechatUserInfo userEntity = null;
        String weixinCookie = null;
        String userHiddenCookie = null;
        if (cookies != null) {
            String userCookieStr;
            String tokenOri;
            String token;
            for (Cookie cookie : cookies) {
                if (wechatKey.equals(cookie.getName())) {
                    weixinCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                if (!wechatTokenKey.equals(cookie.getName())) continue;
                userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
            }
            if (weixinCookie != null && (token = MD5UtilNew.getMD5String(tokenOri = (userCookieStr = String.valueOf(weixinCookie)) + wechatPK)).equals(userHiddenCookie)) {
                JSONObject u = JSONObject.fromObject((Object)weixinCookie);
                userEntity = (WechatUserInfo)JSONObject.toBean((JSONObject)u, WechatUserInfo.class);
            }
        }
        return userEntity;
    }
}

