/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.security.shiro.cache;

import com.cxqm.xiaoerke.common.utils.JedisUtils;
import com.cxqm.xiaoerke.common.web.Servlets;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class JedisCacheManager
implements CacheManager {
    private String cacheKeyPrefix = "shiro_cache_";

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        return new JedisCache(this.cacheKeyPrefix + name);
    }

    public String getCacheKeyPrefix() {
        return this.cacheKeyPrefix;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public class JedisCache<K, V>
    implements Cache<K, V> {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private String cacheKeyName = null;

        public JedisCache(String cacheKeyName) {
            this.cacheKeyName = cacheKeyName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) throws CacheException {
            if (key == null) {
                return null;
            }
            Object v = null;
            HttpServletRequest request = Servlets.getRequest();
            if (request != null && (v = request.getAttribute(this.cacheKeyName)) != null) {
                return (V)v;
            }
            Object value = null;
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                value = JedisUtils.toObject(jedis.hget(JedisUtils.getBytesKey(this.cacheKeyName), JedisUtils.getBytesKey(key)));
                this.logger.debug("get {} {} {}", new Object[]{this.cacheKeyName, key, request != null ? request.getRequestURI() : ""});
            }
            catch (Exception e) {
                this.logger.error("get {} {} {}", new Object[]{this.cacheKeyName, key, request != null ? request.getRequestURI() : "", e});
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
            if (request != null && value != null) {
                request.setAttribute(this.cacheKeyName, value);
            }
            return (V)value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V put(K key, V value) throws CacheException {
            if (key == null) {
                return null;
            }
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                jedis.hset(JedisUtils.getBytesKey(this.cacheKeyName), JedisUtils.getBytesKey(key), JedisUtils.toBytes(value));
                this.logger.debug("put {} {} = {}", new Object[]{this.cacheKeyName, key, value});
            }
            catch (Exception e) {
                this.logger.error("put {} {}", new Object[]{this.cacheKeyName, key, e});
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V remove(K key) throws CacheException {
            Object value = null;
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                value = JedisUtils.toObject(jedis.hget(JedisUtils.getBytesKey(this.cacheKeyName), JedisUtils.getBytesKey(key)));
                jedis.hdel(JedisUtils.getBytesKey(this.cacheKeyName), (byte[][])new byte[][]{JedisUtils.getBytesKey(key)});
                this.logger.debug("remove {} {}", (Object)this.cacheKeyName, key);
            }
            catch (Exception e) {
                this.logger.warn("remove {} {}", new Object[]{this.cacheKeyName, key, e});
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
            return (V)value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() throws CacheException {
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                jedis.hdel(JedisUtils.getBytesKey(this.cacheKeyName), (byte[][])new byte[0][]);
                this.logger.debug("clear {}", (Object)this.cacheKeyName);
            }
            catch (Exception e) {
                this.logger.error("clear {}", (Object)this.cacheKeyName, (Object)e);
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            int size = 0;
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                size = jedis.hlen(JedisUtils.getBytesKey(this.cacheKeyName)).intValue();
                this.logger.debug("size {} {} ", (Object)this.cacheKeyName, (Object)size);
                int n = size;
                return n;
            }
            catch (Exception e) {
                this.logger.error("clear {}", (Object)this.cacheKeyName, (Object)e);
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<K> keys() {
            HashSet keys = Sets.newHashSet();
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                Set set = jedis.hkeys(JedisUtils.getBytesKey(this.cacheKeyName));
                for (byte[] key : set) {
                    keys.add(key);
                }
                this.logger.debug("keys {} {} ", (Object)this.cacheKeyName, (Object)keys);
                HashSet hashSet = keys;
                return hashSet;
            }
            catch (Exception e) {
                this.logger.error("keys {}", (Object)this.cacheKeyName, (Object)e);
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
            return keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<V> values() {
            List vals = Collections.emptyList();
            Jedis jedis = null;
            try {
                jedis = JedisUtils.getResource();
                List col = jedis.hvals(JedisUtils.getBytesKey(this.cacheKeyName));
                for (byte[] val : col) {
                    vals.add(val);
                }
                this.logger.debug("values {} {} ", (Object)this.cacheKeyName, vals);
                List list = vals;
                return list;
            }
            catch (Exception e) {
                this.logger.error("values {}", (Object)this.cacheKeyName, (Object)e);
            }
            finally {
                JedisUtils.returnResource(jedis);
            }
            return vals;
        }
    }
}

