/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.service;

import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class BaseService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public static String dataScopeFilter(User user, String officeAlias, String userAlias) {
        StringBuilder sqlString = new StringBuilder();
        ArrayList dataScope = Lists.newArrayList();
        if (!user.isAdmin()) {
            boolean isDataScopeAll = false;
            for (Role r : user.getRoleList()) {
                for (String oa : StringUtils.split((String)officeAlias, (String)",")) {
                    String officeIds;
                    if (dataScope.contains(r.getDataScope()) || !StringUtils.isNotBlank((CharSequence)oa)) continue;
                    if ("1".equals(r.getDataScope())) {
                        isDataScopeAll = true;
                    } else if ("2".equals(r.getDataScope())) {
                        sqlString.append(" OR " + oa + ".id = '" + user.getCompany().getId() + "'");
                        sqlString.append(" OR " + oa + ".parent_ids LIKE '" + user.getCompany().getParentIds() + user.getCompany().getId() + ",%'");
                    } else if ("3".equals(r.getDataScope())) {
                        sqlString.append(" OR " + oa + ".id = '" + user.getCompany().getId() + "'");
                        sqlString.append(" OR (" + oa + ".parent_id = '" + user.getCompany().getId() + "' AND " + oa + ".type = '2')");
                    } else if ("4".equals(r.getDataScope())) {
                        sqlString.append(" OR " + oa + ".id = '" + user.getOffice().getId() + "'");
                        sqlString.append(" OR " + oa + ".parent_ids LIKE '" + user.getOffice().getParentIds() + user.getOffice().getId() + ",%'");
                    } else if ("5".equals(r.getDataScope())) {
                        sqlString.append(" OR " + oa + ".id = '" + user.getOffice().getId() + "'");
                    } else if ("9".equals(r.getDataScope()) && StringUtils.isNotEmpty((CharSequence)(officeIds = StringUtils.join(r.getOfficeIdList(), (String)"','")))) {
                        sqlString.append(" OR " + oa + ".id IN ('" + officeIds + "')");
                    }
                    dataScope.add(r.getDataScope());
                }
            }
            if (!isDataScopeAll) {
                if (StringUtils.isNotBlank((CharSequence)userAlias)) {
                    for (String ua : StringUtils.split((String)userAlias, (String)",")) {
                        sqlString.append(" OR " + ua + ".id = '" + user.getId() + "'");
                    }
                } else {
                    for (String oa : StringUtils.split((String)officeAlias, (String)",")) {
                        sqlString.append(" OR " + oa + ".id IS NULL");
                    }
                }
            } else {
                sqlString = new StringBuilder();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sqlString.toString())) {
            return " AND (" + sqlString.substring(4) + ")";
        }
        return "";
    }
}

