/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.service;

import com.cxqm.xiaoerke.common.service.TreeService;
import com.cxqm.xiaoerke.modules.sys.dao.OfficeDao;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OfficeService
extends TreeService<OfficeDao, Office> {
    public List<Office> findAll() {
        return UserUtils.getOfficeList();
    }

    @Override
    public List<Office> findList(Boolean isAll) {
        if (isAll != null && isAll.booleanValue()) {
            return UserUtils.getOfficeAllList();
        }
        return UserUtils.getOfficeList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Office> findList(Office office) {
        office.setParentIds(office.getParentIds() + "%");
        return ((OfficeDao)this.dao).findByParentIdsLike(office);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Office office) {
        super.save(office);
        UserUtils.removeCache("officeList");
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Office office) {
        super.delete(office);
        UserUtils.removeCache("officeList");
    }
}

