/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.junit;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.junit.AssertionFailedException;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class AssertEx
extends Assert {
    protected AssertEx() {
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            AssertEx.fail(message);
        }
    }

    public static void assertTrueByError(IErrorInfo error, boolean condition) {
        if (!condition) {
            AssertEx.failByError(error);
        }
    }

    public static void assertTrue(boolean condition) {
        AssertEx.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        AssertEx.assertTrue(message, !condition);
    }

    public static void assertFalseByError(IErrorInfo error, boolean condition) {
        AssertEx.assertTrueByError(error, !condition);
    }

    public static void assertFalse(boolean condition) {
        AssertEx.assertFalse(null, condition);
    }

    public static void fail() {
        AssertEx.fail(null);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        AssertEx.failNotEquals(message, expected, actual);
    }

    public static void assertEqualsByError(IErrorInfo error, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        AssertEx.failNotEqualsByError(error);
    }

    public static void assertEquals(Object expected, Object actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new ComparisonFailure(message, expected, actual);
    }

    public static void assertEqualsByError(IErrorInfo error, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new BusinessException(error);
    }

    public static void assertEquals(String expected, String actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                AssertEx.failNotEquals(message, new Double(expected), new Double(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertEx.failNotEquals(message, new Double(expected), new Double(actual));
        }
    }

    public static void assertEqualsByError(IErrorInfo error, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                AssertEx.failByError(error);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertEx.failByError(error);
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        AssertEx.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                AssertEx.failNotEquals(message, new Float(expected), new Float(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertEx.failNotEquals(message, new Float(expected), new Float(actual));
        }
    }

    public static void assertEqualsByError(IErrorInfo error, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                AssertEx.failByError(error);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertEx.failByError(error);
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        AssertEx.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        AssertEx.assertEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertEqualsByError(IErrorInfo error, long expected, long actual) {
        AssertEx.assertEqualsByError(error, new Long(expected), new Long(actual));
    }

    public static void assertEquals(long expected, long actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        AssertEx.assertEquals(message, new Boolean(expected), new Boolean(actual));
    }

    public static void assertEqualsByError(IErrorInfo error, boolean expected, boolean actual) {
        AssertEx.assertEqualsByError(error, new Boolean(expected), new Boolean(actual));
    }

    public static void assertEquals(boolean expected, boolean actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        AssertEx.assertEquals(message, new Byte(expected), new Byte(actual));
    }

    public static void assertEqualsByError(IErrorInfo error, byte expected, byte actual) {
        AssertEx.assertEqualsByError(error, new Byte(expected), new Byte(actual));
    }

    public static void assertEquals(byte expected, byte actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        AssertEx.assertEquals(message, new Character(expected), new Character(actual));
    }

    public static void assertEqualsByError(IErrorInfo error, char expected, char actual) {
        AssertEx.assertEqualsByError(error, new Character(expected), new Character(actual));
    }

    public static void assertEquals(char expected, char actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        AssertEx.assertEquals(message, new Short(expected), new Short(actual));
    }

    public static void assertEqualsByError(IErrorInfo error, short expected, short actual) {
        AssertEx.assertEqualsByError(error, new Short(expected), new Short(actual));
    }

    public static void assertEquals(short expected, short actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        AssertEx.assertEquals(message, new Integer(expected), new Integer(actual));
    }

    public static void assertEqualsByError(IErrorInfo error, int expected, int actual) {
        AssertEx.assertEqualsByError(error, new Integer(expected), new Integer(actual));
    }

    public static void assertEquals(int expected, int actual) {
        AssertEx.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        AssertEx.assertNotNull(null, object);
    }

    public static void assertNotNull(String message, Object object) {
        AssertEx.assertTrue(message, object != null);
    }

    public static void assertNotNullByError(IErrorInfo error, Object object) {
        AssertEx.assertTrueByError(error, object != null);
    }

    public static void assertNull(Object object) {
        AssertEx.assertNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        AssertEx.assertTrue(message, object == null);
    }

    public static void assertNullByError(IErrorInfo error, Object object) {
        AssertEx.assertTrueByError(error, object == null);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        AssertEx.failNotSame(message, expected, actual);
    }

    public static void assertSameByError(IErrorInfo error, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        AssertEx.failNotSameByError(error);
    }

    public static void assertSame(Object expected, Object actual) {
        AssertEx.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            AssertEx.failSame(message);
        }
    }

    public static void assertNotSameByError(IErrorInfo error, Object expected, Object actual) {
        if (expected == actual) {
            AssertEx.failSameByError(error);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        AssertEx.assertNotSame(null, expected, actual);
    }

    public static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        AssertEx.fail(formatted + "expected not same");
    }

    private static void failSameByError(IErrorInfo error) {
        AssertEx.failByError(error);
    }

    public static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        AssertEx.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotSameByError(IErrorInfo error) {
        AssertEx.failByError(error);
    }

    public static void failNotEquals(String message, Object expected, Object actual) {
        AssertEx.fail(AssertEx.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    private static void failNotEqualsByError(IErrorInfo error) {
        AssertEx.failByError(error);
    }

    public static void fail(String message) {
        throw new AssertionFailedException(message);
    }

    public static void failByError(IErrorInfo error) {
        throw new BusinessException(error);
    }
}

