/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.queue;

import com.cxqm.xiaoerke.common.queue.RedisDelayQueueEntity;
import com.cxqm.xiaoerke.common.queue.RedisDelayQueueTiming;
import com.cxqm.xiaoerke.common.queue.RedisQueue;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisDelayQueue
implements InitializingBean,
DisposableBean {
    private RedisTemplate redisTemplate;
    private String key;
    private RedisConnectionFactory factory;
    private RedisConnection connection;
    private BoundZSetOperations<String, RedisDelayQueueEntity> setOperations;
    private Lock lock = new ReentrantLock();
    private RedisDelayQueueEntity delayQueueEntity;
    private Thread listenerThread;
    private boolean isClosed;

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisDelayQueueEntity getDelayQueueEntity() {
        return this.delayQueueEntity;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void afterPropertiesSet() throws Exception {
        this.factory = this.redisTemplate.getConnectionFactory();
        this.connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.factory);
        this.setOperations = this.redisTemplate.boundZSetOps((Object)this.key);
        this.listenerThread = new ListenerThread();
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public void addByExpiredTime(RedisDelayQueueTiming queueTiming, Date expiredTime) {
        this.setOperations.add(new RedisDelayQueueEntity(queueTiming.getQueueName(), queueTiming.getValue()), new Double(expiredTime.getTime()).doubleValue());
    }

    public void addByAfterSecond(RedisDelayQueueTiming queueTiming, long second) {
        this.addByExpiredTime(queueTiming, new Date(new Date().getTime() + second * 1000L));
    }

    public void cancel(RedisDelayQueueTiming queueTiming) {
        this.setOperations.remove(new Object[]{new RedisDelayQueueEntity(queueTiming.getQueueName(), queueTiming.getValue())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RedisDelayQueueEntity> getListForTimeout() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Long currentTime = new Date().getTime();
            this.connection.multi();
            Set ts = this.setOperations.rangeByScore(0.0, new Double(currentTime.longValue()).doubleValue());
            this.setOperations.removeRangeByScore(0.0, new Double(currentTime.longValue()).doubleValue());
            this.connection.exec();
            if (CollectionUtils.isEmpty((Collection)ts)) {
                List<RedisDelayQueueEntity> list = null;
                return list;
            }
            ArrayList<RedisDelayQueueEntity> result = new ArrayList<RedisDelayQueueEntity>();
            for (RedisDelayQueueEntity t : ts) {
                result.add(t);
            }
            ArrayList<RedisDelayQueueEntity> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            this.connection.discard();
            List<RedisDelayQueueEntity> list = null;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() throws Exception {
        System.out.println("----destroy.... ");
        this.isClosed = true;
        this.shutdown();
        this.connection.getSentinelConnection().close();
        this.connection.shutdown();
        this.connection.close();
        RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.factory);
        RedisConnectionUtils.releaseConnection((RedisConnection)this.connection, (RedisConnectionFactory)this.factory);
    }

    private void shutdown() {
        try {
            this.listenerThread.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ListenerThread
    extends Thread {
        ListenerThread() {
        }

        @Override
        public void run() {
            try {
                while (!RedisDelayQueue.this.isClosed) {
                    List<RedisDelayQueueEntity> ts = RedisDelayQueue.this.getListForTimeout();
                    if (ts != null && ts.size() > 0) {
                        for (RedisDelayQueueEntity t : ts) {
                            ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
                            Object bean = applicationContext.getBean(t.getKey());
                            if (bean == null || !(bean instanceof RedisQueue)) continue;
                            RedisQueue redisQueue = (RedisQueue)bean;
                            redisQueue.pushFromHead(t.getValue());
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

