/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.service;

import com.cxqm.xiaoerke.common.persistence.BaseEntity;
import com.cxqm.xiaoerke.common.persistence.CrudDao;
import com.cxqm.xiaoerke.common.persistence.DataEntity;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.service.BaseService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class CrudService<D extends CrudDao<T>, T extends DataEntity<T>>
extends BaseService {
    @Autowired
    protected D dao;

    public T get(String id) {
        return (T)((DataEntity)((Object)this.dao.get((String)id)));
    }

    public T get(T entity) {
        return (T)((DataEntity)this.dao.get(entity));
    }

    public List<T> findList(T entity) {
        return this.dao.findList(entity);
    }

    public Page<T> findPage(Page<T> page, T entity) {
        ((BaseEntity)entity).setPage(page);
        page.setList(this.dao.findList(entity));
        return page;
    }

    @Transactional(readOnly=false)
    public void save(T entity) {
        if (((BaseEntity)entity).getIsNewRecord()) {
            ((DataEntity)entity).preInsert();
            this.dao.insert(entity);
        } else {
            ((DataEntity)entity).preUpdate();
            this.dao.update(entity);
        }
    }

    @Transactional(readOnly=false)
    public void delete(T entity) {
        this.dao.delete(entity);
    }
}

