/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.queue;

import com.cxqm.xiaoerke.common.queue.RedisQueueListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisQueue<T>
implements InitializingBean,
DisposableBean {
    private RedisTemplate redisTemplate;
    private String key;
    private int cap = Short.MAX_VALUE;
    private byte[] rawKey;
    private RedisConnectionFactory factory;
    private RedisConnection connection;
    private BoundListOperations<String, T> listOperations;
    private Lock lock = new ReentrantLock();
    private RedisQueueListener listener;
    private Thread listenerThread;
    private boolean isClosed;

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setListener(RedisQueueListener listener) {
        this.listener = listener;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void afterPropertiesSet() throws Exception {
        this.factory = this.redisTemplate.getConnectionFactory();
        this.connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.factory);
        this.rawKey = this.redisTemplate.getKeySerializer().serialize((Object)this.key);
        this.listOperations = this.redisTemplate.boundListOps((Object)this.key);
        if (this.listener != null) {
            this.listenerThread = new ListenerThread();
            this.listenerThread.setDaemon(true);
            this.listenerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T takeFromTail(int timeout) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            List results = this.connection.bRPop(timeout, (byte[][])new byte[][]{this.rawKey});
            if (CollectionUtils.isEmpty((Collection)results)) {
                T t = null;
                return t;
            }
            Object object = this.redisTemplate.getValueSerializer().deserialize((byte[])results.get(1));
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T takeFromTail() throws InterruptedException {
        return this.takeFromTail(0);
    }

    public void pushFromHead(T value) {
        this.listOperations.leftPush(value);
    }

    public void pushFromTail(T value) {
        this.listOperations.rightPush(value);
    }

    public T removeFromHead() {
        return (T)this.listOperations.leftPop();
    }

    public T removeFromTail() {
        return (T)this.listOperations.rightPop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T takeFromHead(int timeout) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            List results = this.connection.bLPop(timeout, (byte[][])new byte[][]{this.rawKey});
            if (CollectionUtils.isEmpty((Collection)results)) {
                T t = null;
                return t;
            }
            Object object = this.redisTemplate.getValueSerializer().deserialize((byte[])results.get(1));
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T takeFromHead() throws InterruptedException {
        return this.takeFromHead(0);
    }

    public void destroy() throws Exception {
        System.out.println(this.isClosed + "|destroy....");
        if (this.isClosed) {
            return;
        }
        this.shutdown();
        this.connection.getSentinelConnection().close();
        this.connection.shutdown();
        this.connection.close();
        RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.factory);
        RedisConnectionUtils.releaseConnection((RedisConnection)this.connection, (RedisConnectionFactory)this.factory);
    }

    private void shutdown() {
        try {
            this.listenerThread.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ListenerThread
    extends Thread {
        ListenerThread() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        Object value = RedisQueue.this.takeFromHead();
                        System.out.println("take...");
                        if (value == null) continue;
                        try {
                            RedisQueue.this.listener.onMessage(value);
                            continue block4;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LoggerFactory.getLogger(this.getClass()).error("\u961f\u5217\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

